<?php

namespace App\Http\Controllers;


use App\Http\Controllers\Controller;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Response;
use Input;
use App\Models\Debtor;
use App\Models\Config;
use App\Models\DebtorInvoice;
use App\Models\User;
use App\Models\Calendar;
use App\Models\EventModel;
use App\Models\Client;
use App\Models\InvoiceFollow;
use App\Http\Requests\Calendar\CreateRequest;
use App\Http\Requests\Calendar\EditRequest;


class CalendarController extends Controller {

    protected $request;
    protected $debtor;
    protected $config;
    protected $client;
    protected $user;
    protected $paginationSize;
    protected $calendar;
    protected $loginUser;
    protected $eventModel;
    protected $invoiceFollow;

    public function __construct(Request $request, Debtor $debtor, Config $config, User $user, Client $client, Calendar $calendar, EventModel $eventModel,InvoiceFollow $invoiceFollow) {

        $this->request = $request;
        $this->debtor = $debtor;
        $this->config = $config;
        $this->user = $user;
        $this->paginationSize = $config->find(1)->value;
        $this->client = $client;
        $this->calendar = $calendar;
        $this->loginUser = Auth::user();
        $this->eventModel=$eventModel;
        $this->invoiceFollow =$invoiceFollow;
    }

    public function index() {


        $calendar = $this->calendar;
        $calendars = $calendar->orderBy('id', 'DESC')->paginate($this->paginationSize);
        $calendars = DB::table('calendars')->orderBy('id', 'DESC')->paginate($this->paginationSize);

        $detailCalendars=array();
        foreach($calendars as $calendar)
        {
            $value['title']='666666';
            $value['start']='2017-07-09';
           $detailCalendars[]=$value;
        }
        $startDate['set']='no';
         $startDate['date']='no';
         if ($this->request->session()->has('startDate')) {
            $startDate['date'] = $this->request->session()->get('startDate');
           $this->request->session()->forget('startDate');
            $startDate['set'] = 'yes';
        }
      // dd($startDate);
         if ($this->request->has('search')) {




                return redirect()->route('client.index', ['search' => $this->request->search]);


            $search = $this->request->search;
        }

       $invoiceFollows= $this->invoiceFollow->where('status', '=' ,'todo')->get();

        return view('calendars.index', compact('calendars', 'detailCalendars', 'startDate', 'invoiceFollows'));
    }

    public function create($client = '') {
        $path = explode('/', $this->request->path());
//        echo '<pre>';
//        var_dump($path);
//        exit;
        $type = 'todo';
        $formPath = 0;
        $debtorArray = array(
            'name' => '',
            'id' => '',
            'debtor_code' => ''
        );
        $debtorArray['set'] = 'no';
        if ($this->request->session()->has('debtorArray')) {
            $debtorArray = $this->request->session()->get('debtorArray', []);
            $this->request->session()->forget('debtorArray');
            $debtorArray['set'] = true;
        }

        $clientArray = array(
            'name' => '',
            'id' => '',
            'client_code' => ''
        );
        $clientArray['set'] = 'no';

        if ($path[2] == 'debtor') {
            $debtor = $this->debtor->where('id', $path[3])->get();
            $debtor = $debtor[0];
            $debtorArray = array(
                'name' => $debtor->name,
                'id' => $debtor->id,
                'debtor_code' => $debtor->debtor_code
            );
            $formPath = 2;
            $debtorArray['set'] = 'yes';

            $client = $this->client->where('id', $path[1])->get();
            $client = $client[0];
            $clientArray = array(
                'name' => $client->name,
                'id' => $client->id,
                'client_code' => $client->client_code
            );
            $clientArray['set'] = 'no';
        } elseif ($path[0] == 'client') {
            $client = $this->client->where('id', $path[1])->get();
            $client = $client[0];
            $clientArray = array(
                'name' => $client->name,
                'id' => $client->id,
                'client_code' => $client->client_code
            );
            $formPath = 1;
            $clientArray['set'] = 'yes';
        } elseif ($path[0] == 'debtor') {
            $debtor = $this->debtor->where('id', $path[1])->get();
            $debtor = $debtor[0];
            $debtorArray = array(
                'name' => $debtor->name,
                'id' => $debtor->id,
                'debtor_code' => $debtor->debtor_code
            );
            $formPath = 3;
            $debtorArray['set'] = 'yes';
        }

        if ($this->request->session()->has('clientArray')) {
            $clientArray = $this->request->session()->get('clientArray', []);
            $this->request->session()->forget('clientArray');
            $clientArray['set'] = true;
        }

        if ($path[1] == 'call' || $path[2] == 'call' || (isset($path[4]) && $path[4] == 'call')) {
            $type = 'call';
            return view('calendars.create', compact('type', 'debtorArray', 'clientArray', 'formPath'));
        }
        return view('calendars.create', compact('type', 'debtorArray', 'clientArray', 'formPath'));
    }

    public function store($model = '') {
        $path = explode('/', $this->request->path());
        $request = $this->request;
        $calendar = $this->calendar;
//        echo '<pre>';var_dump($path);exit;
      //  $calendar->name = $request->name;
        $calendar->user_name = Auth::user()->first_name . ' ' . Auth::user()->last_name;
        $calendar->user_id = Auth::user()->id;
        $calendar->client_id = $request->client_id;
        $calendar->debtor_id = $request->debtor_id;
        $calendar->status = $request->status;
        $calendar->type = $request->type;
        $calendar->start_date = $request->start_date;
        $calendar->start_time = $request->start_time;
        $calendar->end_date = $request->end_date;
        $calendar->end_time = $request->end_time;
        $calendar->remainder = $request->remainder;
        if ($path[0] == 'calendar' && $path[1] != 'call' && $path[1] != 'todo') {
            $calendarData = DB::table('calendars')->where('id', $path[1])->get();
            $calendarData = $calendarData[0];
            $calendar = array();
            $calendar['id'] = $calendarData->id;
            $calendar['calendar_code'] = $calendarData->calendar_code;
          //  $calendar['name'] = $request->name;
            $calendar['user_name'] = Auth::user()->first_name . ' ' . Auth::user()->last_name;
            $calendar['user_id'] = Auth::user()->id;
            $calendar['client_id'] = $request->client_id;
            $calendar['debtor_id'] = $request->debtor_id;
            $calendar['status'] = $request->status;
            $calendar['type'] = $request->type;
            $calendar['start_date'] = $request->start_date;
            $calendar['start_time'] = $request->start_time;
            $calendar['end_date'] = $request->end_date;
            $calendar['end_time'] = $request->end_time;
            $calendar['remainder'] = $request->remainder;
            DB::table('calendars')->where('id', $path[1])->update($calendar);
        } else {
            $calendar->save();
        }

        if ($path[0] == 'calendar' && $path[1] != 'call' && $path[1] != 'todo') {
            $calendar = DB::table('calendars')->where('id', $path[1])->get();
            $calendar = $calendar[0];

            if (!is_null($calendar->client_id) && $calendar->client_id != 0) {
                $client = $this->client->where('id', $calendar->client_id)->get();
                $client = $client[0];
            }
            if (!is_null($calendar->debtor_id) && $calendar->debtor_id != 0) {
                $debtor = $this->debtor->where('id', $calendar->debtor_id)->get();
                $debtor = $debtor[0];
            }
            if (isset($client) && isset($debtor)) {
                return view('calendars.show', compact('calendar', 'client', 'debtor'));
            } elseif (isset($client)) {
                return view('calendars.show', compact('calendar', 'client'));
            } elseif (isset($debtor)) {
                return view('calendars.show', compact('calendar', 'debtor'));
            } else {
                return view('calendars.show', compact('calendar'));
            }
        }

        if ($path[2] == 'debtor') {
            $client = $this->client->find($path[1]);
            $debtor = $this->debtor->find($path[3]);
            return redirect()->route('client.debtor.show', compact('client', 'debtor'));
        } elseif ($path[0] == 'client') {
            $client = $this->client->find($path[1]);
            return redirect()->route('client.detail', compact('client'));
        } elseif ($path[0] == 'debtor') {
            $debtor = $this->debtor->find($path[1]);
            return redirect()->route('debtor.show', compact('debtor'));
        }
        //dd();
        $dataFormat = $request->start_date;
        if($request->start_date != '')
        {
            $dataFormat =Carbon::createFromFormat('d/m/Y', $request->start_date)->format('Y-m-d');
        }
$this->request->session()->put('startDate',  $dataFormat );
        return redirect()->route('calendar.index');
    }

    public function detail() {

        $path = explode('/', $this->request->path());
        if ($path[0] == 'calendar') {
            $calendar = DB::table('calendars')->where('id', $path[1])->get();
            $calendar = $calendar[0];
        }
        if (!is_null($calendar->client_id) && $calendar->client_id != 0) {
            $client = $this->client->where('id', $calendar->client_id)->get();
            $client = $client[0];
        }
        if (!is_null($calendar->debtor_id) && $calendar->debtor_id != 0) {
            $debtor = $this->debtor->where('id', $calendar->debtor_id)->get();
            $debtor = $debtor[0];
        }

        if (isset($client) && isset($debtor)) {
            return view('calendars.show', compact('calendar', 'client', 'debtor'));
        } elseif (isset($client)) {
            return view('calendars.show', compact('calendar', 'client'));
        } elseif (isset($debtor)) {
            return view('calendars.show', compact('calendar', 'debtor'));
        } else {
            return view('calendars.show', compact('calendar'));
        }
    }

    public function edit() {
        $path = explode('/', $this->request->path());
        if ($path[0] == 'calendar') {
            $calendar = DB::table('calendars')->where('id', $path[1])->get();
            $calendar = $calendar[0];
            $start_timeParts = explode(':', $calendar->start_time);
            $calendar->start_time = $start_timeParts[0] . ':' . $start_timeParts[1];
            $end_timeParts = explode(':', $calendar->end_time);
            $calendar->end_time = $end_timeParts[0] . ':' . $end_timeParts[1];
        }


        $clientArray = array(
            'name' => '',
            'id' => '',
            'client_code' => ''
        );
        $clientArray['set'] = 'no';

        $debtorArray = array(
            'name' => '',
            'id' => '',
            'debtor_code' => ''
        );
        $debtorArray['set'] = 'no';

        if (!is_null($calendar->client_id) && $calendar->client_id != 0) {
            $client = $this->client->where('id', $calendar->client_id)->get();
            $client = $client[0];
            $clientArray = array(
                'name' => $client->name,
                'id' => $client->id,
                'client_code' => $client->client_code
            );
            $clientArray['set'] = 'yes';
        }

        $type = $calendar->type;
        if (!is_null($calendar->debtor_id) && $calendar->debtor_id != 0) {
            $debtor = $this->debtor->where('id', $calendar->debtor_id)->get();

            $debtor = $debtor[0];

            $debtorArray = array(
                'name' => $debtor->name,
                'id' => $debtor->id,
                'debtor_code' => $debtor->debtor_code
            );
            $debtorArray['set'] = 'yes';
        }

        if ($this->request->session()->has('debtorArray')) {
            $debtorArray = $this->request->session()->get('debtorArray', []);
            $this->request->session()->forget('debtorArray');
            $debtorArray['set'] = true;
        }


        if ($this->request->session()->has('clientArray')) {
            $clientArray = $this->request->session()->get('clientArray', []);
            $this->request->session()->forget('clientArray');
            $clientArray['set'] = true;
        }

        if (isset($client) && isset($debtor)) {
            return view('calendars.edit', compact('calendar', 'client', 'debtor', 'type', 'debtorArray', 'clientArray'));
        } elseif (isset($client)) {
            return view('calendars.edit', compact('calendar', 'client', 'type', 'debtorArray', 'clientArray'));
        } elseif (isset($debtor)) {
            return view('calendars.edit', compact('calendar', 'debtor', 'type', 'debtorArray', 'clientArray'));
        } else {
            return view('calendars.edit', compact('calendar', 'type', 'debtorArray', 'clientArray'));
        }
    }

    public function delete() {
        $path = explode('/', $this->request->path());
        DB::table('calendars')->where('id', $path[1])->delete();
        return redirect()->route('calendar.index');
    }

}
