<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Response;
use Redirect;
use Input;
use File;
use App\Models\Report;
use App\Models\Client;
use App\Models\Debtor;
use App\Models\Condition;
use App\Models\FixedReport;
use App\Models\ClientAccount;
use App\Http\Requests\Report\CreateRequest;
use App\Http\Requests\Report\EditRequest;
use Maatwebsite\Excel\Facades\Excel;

class ClientAccountController extends Controller {

    protected $request;
    protected $report;
    protected $condition;
    protected $client;
    protected $debtor;
    protected $modelOb = array();
    protected $fixedReport;
    protected $monthArray;
    protected $clientAccount;

    public function __construct(Request $request, Report $report, Client $client, Debtor $debtor, Condition $condition, FixedReport $fixedReport, ClientAccount $clientAccount) {

        $this->request = $request;
        $this->report = $report;
        $this->condition = $condition;
        $this->client = $client;
        $this->debtor = $client;
        $this->clientAccount=$clientAccount;
        $this->modelOb['Client'] = $client;
        $this->modelOb['Debtor'] = $debtor;
        $this->fixedReport = $fixedReport;

        $this->monthArray = array();
        $this->monthArray[0] = 'not';
        $this->monthArray["01"] = 'January';
        $this->monthArray["02"] = 'February';
        $this->monthArray["03"] = 'March';
        $this->monthArray["04"] = 'April';
        $this->monthArray["05"] = 'May';
        $this->monthArray["06"] = 'June';
        $this->monthArray["07"] = 'July';
        $this->monthArray["08"] = 'August';
        $this->monthArray["09"] = 'September';
        $this->monthArray[10] = 'October';
        $this->monthArray[11] = 'November';
        $this->monthArray[12] = 'December';







        //$this->middleware('auth');
    }

    public function index() {

        $client = $this->client;

        //   $pagination = report('setting.pagination');;

        if ($this->request->ajax()) {

//********
            $report ='';
            return Response()->json($report);
        }

         $month = date("m");
        $year = date("Y");
        $valueString = $this->monthArray[$month] . '/' . $year;
        $value = $month . '/' . $year;
        if ($this->request->has('filter')) {
            $value = $this->request->value;
            $valueArray = explode('/', $value);

            $month = $valueArray[0];
            $year = $valueArray[1];
            $valueString = $this->monthArray[$month] . '/' . $year;
        }


        $clients = $client->paginate(20);

        return view('clientAccount.index', compact('clients', 'value', 'valueString', 'month', 'year'));
    }

    public function store()
    {

        $request=$this->request;
        $clientAccount= $this->clientAccount;
        $clientAccount->commission_cheque_no=$request->commission_cheque_no;
        $clientAccount->commission=$request->commission;
        $clientAccount->amount_cheque_no=$request->amount_cheque_no;
        $clientAccount->amount=$request->amount;
        $clientAccount->paid_date=$request->payment_date;
        $clientAccount->client_id=$request->client_id;
        $clientAccount->paid_month=$request->paid_month;
        $clientAccount->save();

         return redirect()->route('client.account.index');

    }

    public function show($id) {
        $report = $this->fixedReport->find($id);



        $modelName = $this->client;

        $view = 'reports.fixed.show';
        $fields=$this->field1();
        if ($id == 1) {
            // $fields=$this->field1();
            $datas = $this->data1();
        }
        if ($id == 2) {
            // $fields=$this->field1();
            $datas = $this->data2();
            $view = 'reports.fixed.show2';
        }


        if ($this->request->type == 'export') {


 if ($id == 1) {
            // $fields=$this->field1();
            $fileArray = $this->data11();
        }
        if ($id == 2) {
            // $fields=$this->field1();
            $fileArray = $this->data22();
            $view = 'reports.fixed.show2';
        }

            if ($this->request->action == 'excel5') {
                Excel::create('Filename', function($excel) use($fileArray) {

                    $excel->sheet('Sheetname', function($sheet) use($fileArray) {

                        $sheet->fromArray($fileArray);
                    });
                })->export('xls');
            }
            if ($this->request->action == 'excel2007') {
                Excel::create('Filename', function($excel) use($fileArray) {

                    $excel->sheet('Sheetname', function($sheet) use($fileArray) {

                        $sheet->fromArray($fileArray);
                    });
                })->export('xls');
            }

            if ($this->request->action == 'csv') {
                Excel::create('Filename', function($excel) use($fileArray) {

                    $excel->sheet('Sheetname', function($sheet) use($fileArray) {

                        $sheet->fromArray($fileArray);
                    });
                })->export('csv');
            }

            if ($this->request->action == 'pdf') {
                Excel::create('Filename', function($excel) use($fileArray) {

                    $excel->sheet('Sheetname', function($sheet) use($fileArray) {
                        $sheet->freezeFirstRow();

                        $sheet->fromArray($fileArray, null, 'A1', true);
                    });
                })->export('pdf');
            }

            exit;
        }
        $month = date("m");
        //dd($month);
        $year = date("Y");
        // dd($this->monthArray[$month]);
        $valueString = $this->monthArray[$month] . '/' . $year;
        $value = $month . '/' . $year;
        if ($this->request->has('filter')) {
            $value = $this->request->value;
            $valueArray = explode('/', $value);

            $month = $valueArray[0];
            $year = $valueArray[1];
            $valueString = $this->monthArray[$month] . '/' . $year;
        }


        // dd($fields[0]->name);

        return view($view, compact('report', 'datas', 'fields', 'value', 'valueString'));
    }

    public function field1() {
        $fields = array();
        $fields[0]['name'] = 'Client code';
        $fields[0]['db_name'] = 'client_code';
        $fields[1]['name'] = 'Name';
        $fields[1]['db_name'] = 'name';
        return $fields;
    }

    public function data1() {
        $modelName = $this->client;
        $clientDatas = $modelName->get();
        $datas = array();
        foreach ($clientDatas as $key => $clientData) {

            $datas[$key]['name'] = $clientData->name;
            $datas[$key]['client_code'] = $clientData->client_code;
            $datas[$key]['payments'] = array();

            $balance = 0.00;
            $keyPayemntChek = 0;
            $month = date("m");

            $year = date("Y");

            if ($this->request->has('filter')) {
                $value = $this->request->value;
                $valueArray = explode('/', $value);

                $month = $valueArray[0];
                $year = $valueArray[1];
            }

            $tt = 0;
            // $paymentOb = $clientData->payments()->whereRaw('MONTH(payment_date) = "' . $month . '"')->whereRaw('YEAR(payment_date) = "' . $year . '"')->get();
            $paymentOb = $clientData->payments()->whereRaw('MONTH(payment_date) = "' . $month . '"')->whereRaw('YEAR(payment_date) = "' . $year . '"')->get();

            foreach ($paymentOb as $keyPayemnt => $payment) {

                $datas[$key]['payments'][$keyPayemnt]['payment_date'] = $payment->payment_date;
                $datas[$key]['payments'][$keyPayemnt]['type'] = $payment->paid_place;
                $datas[$key]['payments'][$keyPayemnt]['reference'] = $payment->debtorInvoice->invoice_code;
                $datas[$key]['payments'][$keyPayemnt]['debtor'] = $payment->debtor->debtor_code;
                $datas[$key]['payments'][$keyPayemnt]['payment_type'] = $payment->payment_type;
                $datas[$key]['payments'][$keyPayemnt]['amount'] = $payment->amount;
                $balance = number_format($balance + $payment->amount, 2);
                $datas[$key]['payments'][$keyPayemnt]['balance'] = $balance;
                $keyPayemntChek = $keyPayemnt;
                $tt = 1;
            }
            if ($tt) {
                $datas[$key]['payments'][$keyPayemnt + 1]['payment_date'] = "28-" . $month . "-" . $year;

                $datas[$key]['payments'][$keyPayemnt + 1]['type'] = "Trf Trust";
                $datas[$key]['payments'][$keyPayemnt + 1]['reference'] = "";
                $datas[$key]['payments'][$keyPayemnt + 1]['debtor'] = "";
                $datas[$key]['payments'][$keyPayemnt + 1]['payment_type'] = "";
                $commition = number_format($balance / 100 * $clientData->commission, 2);
                $balance = number_format($balance - $commition, 2);
                $datas[$key]['payments'][$keyPayemnt + 1]['amount'] = $commition;

                $datas[$key]['payments'][$keyPayemnt + 1]['balance'] = $balance;

                $datas[$key]['payments'][$keyPayemnt + 2]['payment_date'] = "28-" . $month . "-" . $year;
                $datas[$key]['payments'][$keyPayemnt + 2]['type'] = "Paid Trst";
                $datas[$key]['payments'][$keyPayemnt + 2]['reference'] = "";
                $datas[$key]['payments'][$keyPayemnt + 2]['debtor'] = "";
                $datas[$key]['payments'][$keyPayemnt + 2]['payment_type'] = "";


                $datas[$key]['payments'][$keyPayemnt + 2]['amount'] = $balance;

                $datas[$key]['payments'][$keyPayemnt + 2]['balance'] = '0.00';
            }
        }

        return $datas;
    }

    public function data2() {
        $modelName = $this->client;
        $clientDatas = $modelName->get();
        $datas = array();
        foreach ($clientDatas as $key => $clientData) {

            $datas[$key]['name'] = $clientData->name;
            $datas[$key]['client_code'] = $clientData->client_code;
            $datas[$key]['payments'] = array();

            $balance = 0.00;
            $keyPayemntChek = 0;
            $month = date("m");

            $year = date("Y");

            if ($this->request->has('filter')) {
                $value = $this->request->value;
                $valueArray = explode('/', $value);

                $month = $valueArray[0];
                $year = $valueArray[1];
            }

            $tt = 0;
            // $paymentOb = $clientData->payments()->whereRaw('MONTH(payment_date) = "' . $month . '"')->whereRaw('YEAR(payment_date) = "' . $year . '"')->get();
            $paymentOb = $clientData->payments()->whereRaw('MONTH(payment_date) = "' . $month . '"')->whereRaw('YEAR(payment_date) = "' . $year . '"')->get();
            $balance = 0;
            foreach ($paymentOb as $keyPayemnt => $payment) {

                $datas[$key]['payments'][$keyPayemnt]['payment_date'] = $payment->payment_date;
                $datas[$key]['payments'][$keyPayemnt]['type'] = 'commission';
                if ($payment->payment_place == 'Paid To CTC') {
                     $commisionString='% commission on';
                } else {
                    $commisionString="% comm'sn (pymt)";
                }
                $datas[$key]['payments'][$keyPayemnt]['reference'] = $payment->debtorInvoice->invoice_code;
                $datas[$key]['payments'][$keyPayemnt]['debtor'] = $payment->debtor->debtor_code;
                $datas[$key]['payments'][$keyPayemnt]['payment_type'] = str_replace('.00', '', $clientData->commission) . '% commission on';
               $commission =$payment->commission;
                if($commission =='0.00')
                {
                    $commission= number_format( $payment->amount * $clientData->commission / 100 , 2 );
                }
                $datas[$key]['payments'][$keyPayemnt]['amount'] =$commission;

                $balance = number_format($balance +$commission, 2);
                $datas[$key]['payments'][$keyPayemnt]['balance'] = $balance;
                $keyPayemntChek = $keyPayemnt;
                $tt = 1;
            }
            if ($tt) {
                $datas[$key]['payments'][$keyPayemnt + 1]['payment_date'] = "28-" . $month . "-" . $year;

                $datas[$key]['payments'][$keyPayemnt + 1]['type'] = "Trf Trust";
                $datas[$key]['payments'][$keyPayemnt + 1]['reference'] = "";
                $datas[$key]['payments'][$keyPayemnt + 1]['debtor'] = "";
                $datas[$key]['payments'][$keyPayemnt + 1]['payment_type'] = "";

                $datas[$key]['payments'][$keyPayemnt + 1]['amount'] = $balance;

                $datas[$key]['payments'][$keyPayemnt + 1]['balance'] = 0.00;
            }
        }

        return $datas;
    }

    public function data11() {
        $modelName = $this->client;
        $clientDatas = $modelName->get();
        $datas = array();
        foreach ($clientDatas as $key => $clientData) {

            $balance = 0.00;
            $keyPayemntChek = 0;
            $month = date("m");

            $year = date("Y");
            $paymentOb = $clientData->payments()->whereRaw('MONTH(payment_date) = "' . $month . '"')->whereRaw('YEAR(payment_date) = "' . $year . '"')->get();
            if ($this->request->has('filter')) {
                $value = $this->request->value;
                $valueArray = explode('/', $value);

                $month = $valueArray[0];
                $year = $valueArray[1];
                $paymentOb = $clientData->payments()->whereRaw('MONTH(payment_date) = "' . $month . '"')->whereRaw('YEAR(payment_date) = "' . $year . '"')->get();
            }
            $tt = 0;
            $datas = array();
            foreach ($paymentOb as $keyPayemnt => $payment) {

                $datas[$keyPayemnt]['name'] = $clientData->name;
                $datas[$keyPayemnt]['client_code'] = $clientData->client_code;

                $datas[$keyPayemnt]['payment_date'] = $payment->payment_date;
                $datas[$keyPayemnt]['type'] = $payment->paid_place;
                $datas[$keyPayemnt]['reference'] = $payment->debtorInvoice->invoice_code;
                $datas[$keyPayemnt]['debtor'] = $payment->debtor->debtor_code;
                $datas[$keyPayemnt]['payment_type'] = $payment->payment_type;
                $datas[$keyPayemnt]['amount'] = $payment->amount;
                $balance = number_format($balance + $payment->amount, 2);
                $datas[$keyPayemnt]['balance'] = $balance;
                $keyPayemntChek = $keyPayemnt;
                $tt = 1;
            }
            if ($tt) {
                $datas[$keyPayemnt + 1]['name'] = $clientData->name;
                $datas[$keyPayemnt + 1]['client_code'] = $clientData->client_code;
                $datas[$keyPayemnt + 1]['payment_date'] = "28-" . $month . "-" . $year;

                $datas[$keyPayemnt + 1]['type'] = "Trf Trust";
                $datas[$keyPayemnt + 1]['reference'] = "";
                $datas[$keyPayemnt + 1]['debtor'] = "";
                $datas[$keyPayemnt + 1]['payment_type'] = "";
                $commition = number_format($balance / 100 * $clientData->commission, 2);
                $balance = number_format($balance - $commition, 2);
                $datas[$keyPayemnt + 1]['amount'] = $commition;

                $datas[$keyPayemnt + 1]['balance'] = $balance;

                $datas[$keyPayemnt + 2]['name'] = $clientData->name;
                $datas[$keyPayemnt + 2]['client_code'] = $clientData->client_code;
                $datas[$keyPayemnt + 2]['payment_date'] = "28-" . $month . "-" . $year;
                $datas[$keyPayemnt + 2]['type'] = "Paid Trst";
                $datas[$keyPayemnt + 2]['reference'] = "";
                $datas[$keyPayemnt + 2]['debtor'] = "";
                $datas[$keyPayemnt + 2]['payment_type'] = "";


                $datas[$keyPayemnt + 2]['amount'] = $balance;

                $datas[$keyPayemnt + 2]['balance'] = '0.00';
            }
        }

        return $datas;
    }

    public function data22() {
        $modelName = $this->client;
        $clientDatas = $modelName->get();
        $datas = array();
        foreach ($clientDatas as $key => $clientData) {

            $balance = 0.00;
            $keyPayemntChek = 0;
            $month = date("m");

            $year = date("Y");
            $paymentOb = $clientData->payments()->whereRaw('MONTH(payment_date) = "' . $month . '"')->whereRaw('YEAR(payment_date) = "' . $year . '"')->get();
            if ($this->request->has('filter')) {
                $value = $this->request->value;
                $valueArray = explode('/', $value);

                $month = $valueArray[0];
                $year = $valueArray[1];
                $paymentOb = $clientData->payments()->whereRaw('MONTH(payment_date) = "' . $month . '"')->whereRaw('YEAR(payment_date) = "' . $year . '"')->get();
            }
            $tt = 0;
            $datas = array();
            foreach ($paymentOb as $keyPayemnt => $payment) {

                $datas[$keyPayemnt]['name'] = $clientData->name;
                $datas[$keyPayemnt]['client_code'] = $clientData->client_code;

                 $datas[$keyPayemnt]['payment_date'] = $payment->payment_date;
                 $datas[$keyPayemnt]['type'] = 'commission';
                if ($payment->payment_place == 'Paid To CTC') {
                     $commisionString='% commission on';
                } else {
                    $commisionString="% comm'sn (pymt)";
                }
                $datas[$keyPayemnt]['reference'] = $payment->debtorInvoice->invoice_code;
                 $datas[$keyPayemnt]['debtor'] = $payment->debtor->debtor_code;
                 $datas[$keyPayemnt]['payment_type'] = str_replace('.00', '', $clientData->commission) . '% commission on';
               $commission =$payment->commission;
                if($commission =='0.00')
                {
                    $commission= number_format( $payment->amount * $clientData->commission / 100 , 2 );
                }
                 $datas[$keyPayemnt]['amount'] =$commission;

                $balance = number_format($balance +$commission, 2);
                $datas[$keyPayemnt]['balance'] = $balance;
                $keyPayemntChek = $keyPayemnt;
                $tt = 1;
            }
            if ($tt) {

                $datas[$keyPayemnt + 1]['name'] = $clientData->name;
                $datas[$keyPayemnt + 1]['client_code'] = $clientData->client_code;
                 $datas[$keyPayemnt + 1]['payment_date'] = "28-" . $month . "-" . $year;

                $datas[$keyPayemnt + 1]['type'] = "Trf Trust";
                $datas[$keyPayemnt + 1]['reference'] = "";
                $datas[$keyPayemnt + 1]['debtor'] = "";
                $datas[$keyPayemnt + 1]['payment_type'] = "";

                $datas[$keyPayemnt + 1]['amount'] = $balance;

                $datas[$keyPayemnt + 1]['balance'] = 0.00;


            }
        }

        return $datas;
    }

}
