<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Models\Client;
use App\Models\Debtor;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Redirect;
use Illuminate\Support\Facades\Response;
use App\Models\Config;
use App\Models\User;
use App\Models\ClientInvoice;
use App\Models\DebtorInvoice;
use App\Models\Field;
use App\Http\Requests\Client\CreateRequest;
use App\Http\Requests\Client\EditRequest;
use Maatwebsite\Excel\Facades\Excel;
use App\Exports\ExportClient;


class ClientController extends Controller {

    protected $request;
    protected $client;
    protected $debtor;
    protected $config;
    protected $paginationSize;
    protected $user;
    protected $clientInvoice;
    protected $field;
    protected $debtorInvoice;

    public function __construct(Request $request, Client $client, Debtor $debtor, Config $config, User $user, ClientInvoice $clientInvoice, Field $field, DebtorInvoice $debtorInvoice) {
        $this->request = $request;
        $this->client = $client;
        $this->debtor = $debtor;
        $this->config = $config;
        $this->user = $user;
        $this->clientInvoice = $clientInvoice;
        $this->field = $field;
        $this->debtorInvoice =$debtorInvoice;
        $this->paginationSize = $config->find(1)->value;
    }

    public function index() {
        $client = $this->client;
        //dd($this->request->all());
        $search = '';
        if ($this->request->ajax()) {

            if ($this->request->has('data_all')) {
                return Response()->json($client->get());
            }

            return Response()->json($client->where('name', 'LIKE', '%' . $this->request->term . '%')->get());
        }

        $orderBy = array();

        if ($this->request->has('search')) {

            $client = $client->where(function ($query) {
                $query->where('email', 'like', '%' . $this->request->search . '%')
                        ->orWhere('client_code', 'like', '%' . $this->request->search . '%')
                        ->orWhere('name', 'like', '%' . $this->request->search . '%');
            });
            if (count($client->get()) < 1) {
                if (count($this->debtor->Where('debtor_code', 'like', '%' . $this->request->search . '%')->orWhere('name', 'like', '%' . $this->request->search . '%')->get())) {
                    return redirect()->route('debtor.index', ['search' => $this->request->search]);
                }
            }
            $search = $this->request->search;
        }
        if ($this->request->has('orderBy')) {
            $clients = $client->orderBy($this->request->dataId, $this->request->orderBy)->paginate($this->paginationSize);
            // $orderBy['orderBy'] = $this->request->orderBy;
            $orderBy['dataId'] = $this->request->dataId;
            if ($this->request->orderBy == 'desc') {
                $orderBy['icon'] = 'fa-sort-alpha-asc';
                $orderBy['orderBy'] = 'asc';
            } else {
                $orderBy['orderBy'] = 'desc';

                $orderBy['icon'] = 'fa-sort-alpha-desc';
            }
        } else {
            $orderBy['dataId'] = 'id';
            $orderBy['icon'] = 'fa-sort-alpha-asc';
            $orderBy['orderBy'] = 'asc';
            $clients = $client->orderBy('id', 'DESC')->paginate($this->paginationSize);
        }


        $fields = $this->field->where('model_id', '6')->get();
        $importEmail = array();
        if ($this->request->session()->has('importrEmail')) {
            $importEmail = $this->request->session()->get('importrEmail', []);

            $this->request->session()->forget('importrEmail');
        }



        return view('clients.index', compact('clients', 'fields', 'importEmail', 'orderBy', 'search'));
    }

    public function create() {
        return view('clients.create');
    }

    public function store(CreateRequest $request) {
        $client = $this->client;
        $client->email = $request->email;
        $client->registered_name = $request->registered_name;
        $client->registered_name2 = $request->registered_name2;
        $client->name = $request->name;
        $client->address1 = $request->address1;
        $client->address2 = $request->address2;
        $client->address3 = $request->address3;
        $client->post_code = $request->post_code;
        $client->contact_person = $request->contact_person;
        $client->tel_number = $request->tel_number;
        $client->mobile_number = $request->mobile_number;
        $client->registered_office = $request->registered_office;
        $client->state_of_incorp = $request->state_of_incorp;
        //  $client->minimum_fees = $request->minimum_fees;
        //   $client->maximum_fees = $request->maximum_fees;
        $client->final_demand_rate = $request->final_demand_rate;
        $client->personal_call_rate = $request->personal_call_rate;
        $client->red_letter_rate = $request->red_letter_rate;
        $client->credit_limit = $request->credit_limit;
        $client->commission = $request->commission;
        $client->state_of_incorp = $request->state_of_incorp;
        $client->contact_person = $request->contact_person;

        $client->save();

        // strlen();


        $ClientString = str_replace(' ', '', $request->registered_name);
        $ClientString = strtoupper($ClientString);
        $lenString = strlen($ClientString);
        if ($lenString > 7) {
            $clientCode = substr($ClientString, 0, 7);
        } else {
            $clientCode = substr($ClientString, 0, $lenString);
        }
        $client->client_code = $clientCode;
        $client->save();
        return redirect()->route('client.index');
    }

    public function show($id) {
        $client = $this->client;
        $notes = DB::table('notes')->where('client_id',$client->id)->orderBy('updated_at', 'DESC')->paginate($this->paginationSize);
        return view('clients.show', compact('client', 'notes'));
    }

    public function detail($client) {
        $notes = DB::table('notes')->where('client_id', $client->id)->orderBy('created_at', 'DESC')->paginate($this->paginationSize);
        $calendars = DB::table('calendars')->where('client_id', $client->id)->where('type', 'call')->orderBy('id', 'DESC')->paginate($this->paginationSize);
        $call = view('calendars.result', compact('calendars'));
        $calendars = DB::table('calendars')->where('client_id', $client->id)->where('type', 'todo')->orderBy('id', 'DESC')->paginate($this->paginationSize);
        $todo = view('calendars.result', compact('calendars'));
        return view('clients.newShow', compact('client', 'notes', 'call', 'todo'));
    }

    public function invoice($client) {
        $clientInvoices = $this->clientInvoice;
        $clientInvoices = $clientInvoices->where('client_id', $client->id);
        $search = '';
        if ($this->request->has('search')) {

            $clientInvoices = $clientInvoices->where(function ($query) {
                $query->where('invoice_code', 'like', '%' . $this->request->search . '%');
            });

            $search = $this->request->search;
        }
        $orderBy = array();
        if ($this->request->has('orderBy')) {
            $clientInvoices = $clientInvoices->orderBy($this->request->dataId, $this->request->orderBy)->paginate($this->paginationSize);
            // $orderBy['orderBy'] = $this->request->orderBy;
            $orderBy['dataId'] = $this->request->dataId;
            if ($this->request->orderBy == 'desc') {
                $orderBy['icon'] = 'fa-sort-alpha-asc';
                $orderBy['orderBy'] = 'asc';
            } else {
                $orderBy['orderBy'] = 'desc';

                $orderBy['icon'] = 'fa-sort-alpha-desc';
            }
        } else {
            $orderBy['dataId'] = 'id';
            $orderBy['icon'] = 'fa-sort-alpha-asc';
            $orderBy['orderBy'] = 'asc';
            $clientInvoices = $clientInvoices->orderBy('id', 'DESC')->paginate($this->paginationSize);
        }

        return view('clients.clientInvoice', compact('client', 'clientInvoices', 'orderBy', 'search'));
    }

    public function debtor($client) {



       $debtors = $client->debtorInvoice();

      //  $debtors = $this->debtorInvoice->where('client_id', $client->id);


        if ($this->request->has('search')) {

            $debtors = $debtors->where(function ($query) {
                $query->where('invoice_code', 'like', '%' . $this->request->search . '%')
                        ->orWhere('invoice_state', 'like', '%' . $this->request->search . '%')
                        ->orWhere('name', 'like', '%' . $this->request->search . '%');
            });
            $search = $this->request->search;
        }
        $orderBy = array();
        $debtorCode = $this->request->debtorCode;
        if ($this->request->has('orderBy')) {
            $debtors = $debtors->orderBy($this->request->dataId, $this->request->orderBy)->paginate($this->paginationSize);
            // $orderBy['orderBy'] = $this->request->orderBy;
            $orderBy['dataId'] = $this->request->dataId;
            if ($this->request->orderBy == 'desc') {
                $orderBy['icon'] = 'fa-sort-alpha-asc';
                $orderBy['orderBy'] = 'asc';
            } else {
                $orderBy['orderBy'] = 'desc';

                $orderBy['icon'] = 'fa-sort-alpha-desc';
            }
        } else {
            $orderBy['dataId'] = 'id';
            $orderBy['icon'] = 'fa-sort-alpha-asc';
            $orderBy['orderBy'] = 'asc';
            if ($debtorCode != '') {
                $debtorsAraay = $this->debtor->where('debtor_code', 'like', '%' . $this->request->debtorCode . '%')->pluck('id');
               $debtors = $debtors->whereIn('debtor_id', $debtorsAraay)->orderBy('id', 'DESC')->paginate($this->paginationSize);
            } else {
                 $debtors = $debtors->orderBy('id', 'DESC')->paginate($this->paginationSize);
            }

        }

        $search = $this->request->search;
        return view('clients.debtor', compact('client', 'debtors', 'orderBy', 'debtorCode', 'search'));
    }

    public function edit($client) {
        return view('clients.edit', compact('client'));
    }

    public function update(EditRequest $request, $client) {
        $client->email = $request->email;
        $client->registered_name = $request->registered_name;
        $client->registered_name2 = $request->registered_name2;
        $client->name = $request->name;
        $client->address1 = $request->address1;
        $client->address2 = $request->address2;
        $client->address3 = $request->address3;
        $client->post_code = $request->post_code;
        $client->contact_person = $request->contact_person;
        $client->tel_number = $request->tel_number;
        $client->registered_office = $request->registered_office;
        $client->state_of_incorp = $request->state_of_incorp;
        //  $client->minimum_fees = $request->minimum_fees;
        //   $client->maximum_fees = $request->maximum_fees;
        $client->mobile_number = $request->mobile_number;
        $client->final_demand_rate = $request->final_demand_rate;
        $client->personal_call_rate = $request->personal_call_rate;
        $client->red_letter_rate = $request->red_letter_rate;
        $client->credit_limit = $request->credit_limit;
        $client->commission = $request->commission;
        $client->state_of_incorp = $request->state_of_incorp;
        $client->contact_person = $request->contact_person;
        $client->save();
        return redirect()->route('client.index');
    }

    public function model($id) {
        return $this->client->find($id);
    }

    public function delete($client) {
        $id = $client->id;



        return view('clients.delete', compact('client'));
    }

    public function destroy($client) {
        $id = $client->id;
        foreach($client->debtorInvoices as $deborInvoice)
        {
            $deborInvoice->forceDelete();
        }
        foreach($client->payments  as $payment)
        {
            $payment->forceDelete();
        }

        foreach($client->dues  as $dues)
        {
            $dues->forceDelete();
        }
        foreach($client->clientInvoices  as $clientInvoice)
        {
            $clientInvoice->forceDelete();
        }
        foreach($client->invoiceFollows  as $invoiceFollow)
        {
            $invoiceFollow->forceDelete();
        }
         foreach($client->clientTransactions  as $clientTransaction)
        {
            $clientTransaction->forceDelete();
        }

         foreach($client->clientPayments  as $clientPayment)
        {
            $clientPayment->forceDelete();
        }

         foreach($client->openingBalances  as $openingBalance)
        {
            $openingBalance->forceDelete();
        }


        $client->forceDelete();
        return redirect()->route('client.index');
    }

    // debtor invoice create

    public function debtorInvoiceCreate($client) {
        $debtors = $this->debtor->pluck('email', 'id')->toArray();
        $users = $this->user->pluck('email', 'id')->toArray();
        return view('clients.invoices.debtor.create', compact('client', 'debtors', 'users'));
    }

    public function debtorInvoiceStore($client): \Illuminate\Http\RedirectResponse
    {
        $request = $this->request;
        $debtor_id = $this->request->debtor_id;
        $withPivotArray = array(
            'invoice_state' => $request->invoice_state,
            'invoice_date' => $request->invoice_date,
            'account_state' => $request->account_state,
            'user_id' => $request->user_id,
            'original_debt' => $request->original_debt,
            'current_balance' => $request->current_balance,
            'original_debt' => $request->original_debt,
            'last_payment' => $request->last_payment,
            'last_paid' => $request->last_paid,
            'total_paid' => $request->original_debt - $request->current_balance
        );
        $client->debtorInvoice()->attach($debtor_id, $withPivotArray);
        return redirect()->route('client.debtor', [$client->id]);
    }

    public function debtorInvoiceEdit($client, $id) {
        $invoice = $client->debtorInvoice()->wherePivot('id', $id)->first();
        $debtors = $this->debtor->pluck('email', 'id')->toArray();
        $users = $this->user->pluck('email', 'id')->toArray();
        return view('clients.invoices.debtor.edit', compact('client', 'debtors', 'users', 'invoice'));
    }

    public function debtorInvoiceUpdate($client, $id) {
        return redirect()->route('client.debtor', [$client->id]);
    }

    public function export() {

        //  dd($this->request->all());


        $all = $this->request->all();

        $id_array = array();
        $id_key = 0;
        $field_array = array();
        $field_key = 0;
        foreach ($all as $key => $value) {


            if (strpos($key, 'export_') !== false) {
                $keyId = str_replace('export_', '', $key);
                $id_array[$id_key] = $value;
                $id_key = $id_key + 1;
            }
            if (strpos($key, 'field_') !== false) {
                $field_array[$field_key] = $value;
                $field_key = 1 + $field_key;
            }
        }

        //dd($id_array);

        $clients = $this->client->whereIn('id', $id_array)->get();

        $fileArray = array();
        foreach ($clients as $key => $client) {
            foreach ($field_array as $field) {
                $fileArray[$key][$field] = $client[$field];
            }
        }
        //dd($this->request->exportFor);
        if ($this->request->exportFor == 'excel') {
//            Excel::create('client', function($excel) use($fileArray) {
//
//                $excel->sheet('Sheetname', function($sheet) use($fileArray) {
//
//                    $sheet->fromArray($fileArray);
//                });
//            })->export('xls');
            return Excel::download(new ExportClient($fileArray), 'client.xlsx');
        }
        if ($this->request->exportFor == 'csv') {
            // Excel::create('client', function($excel) use($fileArray) {

            //     $excel->sheet('Sheetname', function($sheet) use($fileArray) {

            //         $sheet->fromArray($fileArray);
            //     });
            // })->export('csv');
            return Excel::download(new ExportClient($fileArray), 'client.csv');

        }
        return 1;
        //  return redirect()->route('client.index');
    }

    public function import($client) {
        $datas =[];
        $datas['import_type'] = 'upload';
        $datas['clientId'] = $client;
        $datas['fields'] =  [];


         $debtors = $client->debtorInvoices()->where('import_type', 'import')->orderBy('id', 'DESC')->paginate($this->paginationSize);

//        dd($debtors );
//
        return view('clients.import', compact('datas', 'debtors'));
    }

}
