<?php

namespace App\Http\Controllers;

use App\Models\Client;
use App\Models\ClientInvoice;
use App\Models\ClientInvoicePdf;
use App\Models\ClientPayment;
use App\Models\ClientTransaction;
use App\Models\Config;
use App\Models\Debtor;
use App\Models\DebtorInvoice;
use App\Http\Requests\Transaction\CreateRequest;
use App\Models\Payment;
use App\Models\User;
//use App\Models\Mail;
//use App\Models\Mail as Mailsend;
use Barryvdh\DomPDF\Facade\Pdf;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Mail;
use Response;

class ClientInvoiceController extends Controller
{
    protected $request;
    protected $client;
    protected $debtor;
    protected $config;
    protected $paginationSize;
    protected $user;
    protected $debtorInvoice;
    protected $clientInvoice;
    protected $transaction;
    protected $clientInvoicePdf;
    protected $monthArray;
    protected $payment;
    protected $clientPayment;

    public function __construct(Request $request, Client $client, Debtor $debtor, Config $config, User $user, DebtorInvoice $debtorInvoice, ClientInvoice $clientInvoice, ClientTransaction $transaction, ClientInvoicePdf $clientInvoicePdf, Payment $payment, ClientPayment $clientPayment) {

        $this->request = $request;
        $this->client = $client;
        $this->debtor = $debtor;
        $this->config = $config;
        $this->user = $user;
        $this->debtorInvoice = $debtorInvoice;
        $this->clientInvoice = $clientInvoice;
        $this->transaction = $transaction;
        $this->paginationSize = $config->find(1)->value;
        $this->clientInvoicePdf = $clientInvoicePdf;
        $this->payment = $payment;
        $this->clientPayment = $clientPayment;
        //$this->middleware('auth');

        $this->monthArray = array();
        $this->monthArray[0] = 'not';
        $this->monthArray["01"] = 'January';
        $this->monthArray["02"] = 'February';
        $this->monthArray["03"] = 'March';
        $this->monthArray["04"] = 'April';
        $this->monthArray["05"] = 'May';
        $this->monthArray["06"] = 'June';
        $this->monthArray["07"] = 'July';
        $this->monthArray["08"] = 'August';
        $this->monthArray["09"] = 'September';
        $this->monthArray[10] = 'October';
        $this->monthArray[11] = 'November';
        $this->monthArray[12] = 'December';
    }

    public function detail($client, $id) {
        $clientInvoice = $this->clientInvoice;
        $clientInvoice = $clientInvoice->find($id);
        $invoice = $clientInvoice;

        $clientInvoice = $this->clientInvoice;
        $clientInvoice = $clientInvoice->find($id);

        $debtorInvoice = $this->debtorInvoice;
        $debtorInvoice = $debtorInvoice->find($clientInvoice->debtor_invoice_id);
        //  dd($clientInvoice);
        $invoice = $debtorInvoice;

        $debtor = $this->debtor->find($invoice->debtor_id);
        $client = $this->client->find($invoice->client_id);
        $invoiceDate = date("d/m/Y");
        // dd($invoiceDate);
        $year = date("Y");
        //  $clientData = $this->client->find(33);
        $month = date("m");
        $valueString = $this->monthArray[$month] . '/' . $year;
        $year = date("Y");
        $value = $month . '/' . $year;
        if ($this->request->has('filter')) {
            $value = $this->request->value;
            $valueArray = explode('/', $value);

            $month = $valueArray[0];
            $year = $valueArray[1];
            $month = $valueArray[0];
            $year = $valueArray[1];
            $valueString = $this->monthArray[$month] . '/' . $year;
            $invoiceDate = $year . "-" . $month . "-5";
        }
        $invoiceDate = date("Y-m-t", strtotime($invoiceDate));



        $invoiceDate = date("d/m/Y", strtotime($invoiceDate));
        $payments = $invoice->payments()->whereRaw('MONTH(payment_date) = "' . $month . '"')->whereRaw('YEAR(payment_date) = "' . $year . '"');
        $total_paid = number_format((float) $invoice->original_debt - (float) $invoice->current_balance, '2');
        $openingBalance = 0.00;
        $openingBalance1 = $invoice->payments()->whereRaw('MONTH(payment_date) = "' . ($month - 1) . '"')->whereRaw('YEAR(payment_date) = "' . $year . '"')->where("trans_description", "commission")->where("payment_type", "Comm PD")->sum("amount");
        $openingBalance2 = $invoice->payments()->whereRaw('MONTH(payment_date) = "' . ($month - 1) . '"')->whereRaw('YEAR(payment_date) = "' . $year . '"')->where("trans_description", "Paid to client (Instead direct)")->sum("commission");
        $openingBalance = $openingBalance2 + $openingBalance1;
        return view('clients.invoices.client.detail', compact('invoice', 'client', 'debtor', 'invoiceDate', 'total_paid', 'clientInvoice', 'payments', 'openingBalance', 'valueString', 'value'));
    }

    public function pdf($client, $id, $action = '') {


//        $clientInvoice = $this->clientInvoice;
//        $clientInvoice = $clientInvoice->find($id);
//        $invoice = $clientInvoice;
//
//        $debtor = $this->debtor->find($invoice->debtor_id);
//        $client = $this->client->find($invoice->client_id);

        $clientInvoice = $this->clientInvoice;
        $clientInvoice = $clientInvoice->find($id);

        $debtorInvoice = $this->debtorInvoice;
        $debtorInvoice = $debtorInvoice->find($clientInvoice->debtor_invoice_id);
        //  dd($clientInvoice);
        $invoice = $debtorInvoice;

        $debtor = $this->debtor->find($invoice->debtor_id);
        $client = $this->client->find($invoice->client_id);
        $invoiceDate = date("Y-m-d");


        // dd($invoiceDate);
        $year = date("Y");
        //  $clientData = $this->client->find(33);
        $month = date("m");

        $year = date("Y");
        $value = $month . '/' . $year;
        if ($this->request->has('filter')) {
            $value = $this->request->value;
            $valueArray = explode('/', $value);

            $month = $valueArray[0];
            $year = $valueArray[1];

            $invoiceDate = $year . "-" . $month . "-5";
        }


        $invoiceDate = date("Y-m-t", strtotime($invoiceDate));

        $invoiceDate = date("d/m/Y", strtotime($invoiceDate));

        $payments = $invoice->payments()->whereRaw('MONTH(payment_date) = "' . $month . '"')->whereRaw('YEAR(payment_date) = "' . $year . '"');
        //$payments = $invoice->payments()->whereRaw('MONTH(payment_date) = "' . $month . '"')->whereRaw('YEAR(payment_date) = "' . $year . '"');
        // dd(1);
//dd($payments->get());
        $pdf = \App::make('dompdf.wrapper');
        $total_paid = number_format((float) $invoice->original_debt - (float) $invoice->current_balance, '2');
        $debtor = $this->debtor->find($invoice->debtor_id);
        $openingBalance = 0.00;
        $openingBalance1 = $invoice->payments()->whereRaw('MONTH(payment_date) = "' . ($month - 1) . '"')->whereRaw('YEAR(payment_date) = "' . $year . '"')->where("trans_description", "Comm'sion")->where("payment_type", "Comm PD")->sum("amount");
        $openingBalance2 = $invoice->payments()->whereRaw('MONTH(payment_date) = "' . ($month - 1) . '"')->whereRaw('YEAR(payment_date) = "' . $year . '"')->where("trans_description", "Paid to client (Instead direct)")->sum("commission");
        $openingBalance = $openingBalance2 + $openingBalance1;
        // dd($invoice);
        $pdf->loadView('pdfs/clientInvoicePdf2', compact('invoice', 'client', 'debtor', 'invoiceDate', 'openingBalance', 'total_paid', 'clientInvoice', 'payments'));
        $pdfData = $pdf->stream();



        if ($this->request->action == 'view') {
            return $pdf->stream();
        }
        return view('clients.invoices.client.pdfs.view', compact('client', 'invoice', 'debtor', 'pdfData', 'clientInvoice', 'value'));
    }

//    public function pdfPost($client, $id, $action = '') {
//        //$clientInvoice = $this->clientInvoice;
//        $clientInvoice = $this->clientInvoice->find($id);
//
//       // $debtorInvoice = $this->debtorInvoice;
//        $debtorInvoice = $this->debtorInvoice->find($clientInvoice->debtor_invoice_id);
//        $invoice = $debtorInvoice;
//        $client = $this->client->find($invoice->client_id);
//        //  dd($clientInvoice);
//        $invoice = $debtorInvoice;
//
//        $debtor = $this->debtor->find($invoice->debtor_id);
//        $client = $this->client->find($invoice->client_id);
//
//
//        // dd(1);
//
//        $pdf = \App::make('dompdf.wrapper');
//        $total_paid = number_format((float) $invoice->original_debt - (float) $invoice->current_balance, '2');
//        $debtor = $this->debtor->find($invoice->debtor_id);
//
//        // dd($invoice);
//        $pdf->loadView('pdfs/clientInvoicePdf2', compact('invoice', 'client', 'debtor', 'total_paid', 'clientInvoice'));
//        $pdfData = $pdf->stream();
//        $filePath = 'assets/invoice/client/' . $client->id;
//        //  chmod($filePath, 0777);
//        if ($this->request->ajax()) {
//
//
//            if (!(File::exists($filePath))) {
//                $result = File::makeDirectory($filePath, 0777, true, true);
//                //  $result = File::makeDirectory($filePath, 0777);
//                chmod($filePath, 0777);
//            }
//
//            $clientInvoicePdf = $this->clientInvoicePdf;
//
//
//            $clientInvoicePdf->invoice_id = $id;
//            $clientInvoicePdf->save();
//            $filePathUrl = $filePath . '/' . $clientInvoicePdf->id . '.pdf';
//            $pdf->save($filePathUrl);
//            chmod($filePathUrl, 0777);
//            $clientInvoicePdf->path = $filePathUrl;
//            $clientInvoicePdf->save();
//            return Response::json(1);
//        } else {
//
//
//            if (!(File::exists($filePath))) {
//                $result = File::makeDirectory($filePath, 0777, true, true);
//                //  $result = File::makeDirectory($filePath, 0777);
//                chmod($filePath, 0777);
//            }
//
//
//            $filePathUrl = $filePath . '/invoice.pdf';
//            $pdf->save($filePathUrl);
//            chmod($filePathUrl, 0777);
//            $closureData = array();
//            $request = $this->request;
//
//            $closureData['to'] = $request->to;
//            $closureData['fromMail'] = 'ravi@radus28.com';
//            $closureData['subject'] = $request->subject;
//            $closureData['emailTemplate'] = 'emails.test';
//            // $emailTemplate = 'emails.test';
//            $data = ['content' => $request->content];
//            $closureData['path'] = $filePathUrl;
//            $closureData['name1'] = 'test.pdf';
//            ;
//            //$this->sendMail($closureData, $data, $pdfData);
//
//            Mailsend::queue($closureData['emailTemplate'], $data, function($message) use($closureData) {
//                $message->to($closureData['to'], 'test')->subject($closureData['subject']);
//                $message->from($closureData['fromMail'], 'test');
//                $message->attach($closureData['path']);
//                // $message->attachData($closureData['file1'], $closureData['name1']);
//                // $message->cc($closureData['cc']);
//                // $message->bcc($closureData['bcc']);
//            });
//        }
//
//        return redirect()->route('client.debtor.invoice.pdf', [$client->id, $invoice->id]);
//    }
    public function pdfPost($client, $id, $action = '') {
        $clientInvoice = $this->clientInvoice->find($id);
        $debtorInvoice = $this->debtorInvoice->find($clientInvoice->debtor_invoice_id);
        $invoice = $debtorInvoice;
        $client = $this->client->find($invoice->client_id);
        $total_paid = number_format((float) $invoice->original_debt - (float) $invoice->current_balance, '2');
        $debtor = $this->debtor->find($invoice->debtor_id);
        $month = date("m");

        $year = date("Y");
        $invoiceDate = $year . "-" . $month . "-5";
        $invoiceDate = date("Y-m-t", strtotime($invoiceDate));
        $pdf = PDF::loadView('pdfs.clientInvoicePdf2', compact('invoice', 'client', 'total_paid', 'debtor', 'clientInvoice','invoiceDate'));

        $pdfData = $pdf->output();
        $filePath = 'assets/invoice/client/' . $client->id;

        if ($this->request->ajax()) {
            if (!(File::exists($filePath))) {
                File::makeDirectory($filePath, 0777, true, true);
                chmod($filePath, 0777);
            }

            $filePathUrl = $filePath . '/' . $id . '.pdf';
            $pdf->save($filePathUrl);
            chmod($filePathUrl, 0777);

            return response()->json(1);
        } else {
            if (!(File::exists($filePath))) {
                File::makeDirectory($filePath, 0777, true, true);
                chmod($filePath, 0777);
            }

            $filePathUrl = $filePath . '/invoice.pdf';
            $pdf->save($filePathUrl);
            chmod($filePathUrl, 0777);

            $closureData = [
                'to' => $this->request->to,
                'fromMail' => 'ravi@radus28.com',
                'subject' => $this->request->subject,
                'emailTemplate' => 'emails.test',
                'path' => $filePathUrl,
                'name1' => 'test.pdf'
            ];

            Mail::queue($closureData['emailTemplate'], ['content' => $this->request->input('content')], function($message) use ($closureData) {
                $message->to($closureData['to'], 'test')->subject($closureData['subject']);
                $message->from($closureData['fromMail'], 'test');
                $message->attach($closureData['path']);
            });
        }

        return redirect()->route('client.debtor.invoice.pdf', [$client->id, $invoice->id]);
    }
    public function edit($client, $id) {

        $clientInvoice = $this->clientInvoice;
        $clientInvoice = $clientInvoice->find($id);
        $invoice = $clientInvoice;

        return view('clients.invoices.client.edit', compact('client', 'clientInvoice'));
    }

    public function update($client, $id) {
        $request = $this->request;

        $clientInvoice = $this->clientInvoice;
        $clientInvoice = $clientInvoice->find($id);
        if ($request->commission_amount > 20) {
            $clientInvoice->commission_amount = $request->commission_amount;
        } else {
            $clientInvoice->commission_amount = 20;
        }
        $clientInvoice->save();

        return redirect()->route('client.invoice', [$client->id]);
    }

    public function transaction($client, $invoiceId) {
        $transaction = $this->transaction;
        // $transaction = $this->transaction->select('payment_type', DB::raw('count(*) as total'))->groupBy('payment_type')->get();
        // dd($transaction);
        $invoice = $this->clientInvoice->find($invoiceId);
        return view('clients.invoices.client.transactions.index', compact('client', 'invoice'));
    }

    public function store(CreateRequest $request, $client, $invoiceId) {

        $invoice = $this->clientInvoice->find($invoiceId);
        $transaction = $this->transaction;
        $transaction->payment_type = $request->payment_type;
        $transaction->amount = $request->amount;
        $transaction->paid_date = $request->paid_date;
        $transaction->gl_code = $request->gl_code;
        $transaction->trans_description = $request->trans_description;
        $transaction->receipt_no = $request->receipt_no;

        $transaction->client_invoice_id = $invoice->id;
        $transaction->client_id = $invoice->client_id;
        $transaction->debtor_id = $invoice->debtor_id;

        $transaction->save();

        return redirect()->route('client.invoice.transaction', [$client->id, $invoiceId]);
    }

    public function storeDebtor(CreateRequest $request, $client, $month, $year, $id = '') {

        $all = $request->all();

        $invoiceDate = $year . "-" . $month . "-5";
        $invoiceDate = date("Y-m-t", strtotime($invoiceDate));
        $invoiceDate = date("d/m/Y", strtotime($invoiceDate));

        $transaction = $this->transaction;

        if($request->has('id'))
        {
            $transaction = $this->transaction->find($request->id);
        }

        $transaction->payment_type = $request->payment_type;
        $transaction->amount = $request->amount;
        $transaction->cheque_date = $request->paid_date;
        $transaction->paid_date = $invoiceDate;
        $transaction->trans_description = 'ctc paid to client';
        if($request->payment_type == 'cheque')
        {
            $transaction->bank = $request->bank;
            $transaction->branch = $request->branch;
            $transaction->cheque_no = $request->cheque_no;
        }
        //  $transaction->gl_code = $request->gl_code;
        // $transaction->trans_description = $request->trans_description;
        // $transaction->receipt_no = $request->receipt_no;


        $transaction->client_id = $client->id;


        $transaction->save();



        return redirect()->route('fixed.report.show', [3,'filter'=>'filter', 'value'=> $month.'/'.$year]);
    }

    public function invoice($client, $month, $year, $id ='') {

        $transaction = $this->transaction;

        if($this->request->has('action'))
        {
            if ($this->request->action == 'bankPdf') {
                $pdf = \App::make('dompdf.wrapper');
                $pdf->loadView('reports/pdf/bankPaymentPdf', compact( 'client', 'month', 'year'));
                return $pdf->stream();
            }

            if ($this->request->action == 'edit') {
                $transaction = $transaction->find($this->request->id);
                return view('reports.fixed.payments.ctcToClientEdit', compact('client', 'month', 'year', 'transaction'));
            }
        }
        return view('reports.fixed.payments.ctcToClient', compact('client', 'month', 'year', 'transaction'));
    }

    public function clienPayview($client, $month, $year, $id='') {
        ////// -edit
        $clientPayment= $this->clientPayment;

        $transaction = $this->transaction;
        if($this->request->has('action'))
        {
            if ($this->request->action == 'edit') {
                $clientPayment = $clientPayment->find(($this->request->id));
                // dd($clientPayment);
                return view('reports.fixed.payments.clientToCtcEdit', compact('client', 'month', 'year', 'transaction', 'clientPayment'));
            }
        }
        return view('reports.fixed.payments.clientToCtc', compact('client', 'month', 'year', 'transaction'));
    }


    public function clientPayStore(CreateRequest $request, $client, $month, $year) {

        // dd($request);

        $all = $request->all();

//dd($all);


        $invoiceDate = $year . "-" . $month . "-5";
        $invoiceDate = date("Y-m-t", strtotime($invoiceDate));
        $invoiceDate = date("d/m/Y", strtotime($invoiceDate));


        $clientPayment= $this->clientPayment;
        if($request->has('id'))
        {
            $clientPayment = $clientPayment->find($request->id);
        }

        $clientPayment->payment_type = $request->payment_type;
        $clientPayment->amount = $request->amount;
        $clientPayment->paid_date = $request->paid_date;
        $clientPayment->for_month = $invoiceDate;
        $clientPayment->trans_description = 'ctc paid to client';
        if($clientPayment->payment_type == 'cheque')
        {
            $clientPayment->bank = $request->bank;
            $clientPayment->branch = $request->branch;
            $clientPayment->cheque_no = $request->cheque_no;
        }
        //  $transaction->gl_code = $request->gl_code;
        // $transaction->trans_description = $request->trans_description;
        // $transaction->receipt_no = $request->receipt_no;


        $clientPayment->client_id = $client->id;


        $clientPayment->save();



        return redirect()->route('fixed.report.show', [3,'filter'=>'filter', 'value'=> $month.'/'.$year]);
    }


    public function sendMail($closureData, $data, $pdfData) {
        $emailTemplate = 'emails.test';
        Mailsend::queue($closureData['emailTemplate'], $data, function($message) use($closureData, $pdfData) {
            $message->to($closureData['to'], 'ravisangar')->subject($closureData['subject']);
            $message->from($closureData['fromMail'], 'kandiah');
            // $message->attachData($closureData['file1'], $closureData['name1']);
            // $message->cc($closureData['cc']);
            // $message->bcc($closureData['bcc']);
        });
    }

}
