<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Redirect;
use Response;
use Input;
use File;
use App\Models\CollectionActionCode;
use App\Http\Requests\CollectionActionCode\CreateRequest;
use App\Http\Requests\CollectionActionCode\EditRequest;

class CollectionActionCodeController extends Controller {

    protected $request;
    protected $collectionActionCode;

    public function __construct(Request $request, CollectionActionCode $collectionActionCode) {

        $this->request = $request;
        $this->collectionActionCode = $collectionActionCode;

        //$this->middleware('auth');
    }

    public function index() {

        $collectionActionCode = $this->collectionActionCode;

        //   $pagination = collectionActionCode('setting.pagination');;

        if ($this->request->ajax()) {

             $collectionActionCode = $collectionActionCode->where(function ($query) {
                $query->where('code', 'like', '%' . $this->request->term . '%');
//                        ->orWhere('description', 'like', '%' . $this->request->search . '%')
//                        ->orWhere('type', 'like', '%' . $this->request->search . '%');
            });

            return Response::json($collectionActionCode->get());
        }


        if ($this->request->has('search')) {

            $collectionActionCode = $collectionActionCode->where(function ($query) {
                $query->where('code', 'like', '%' . $this->request->search . '%')
                        ->orWhere('description', 'like', '%' . $this->request->search . '%');
            });

            $search = $this->request->search;
        }
        $collectionActionCodes = $collectionActionCode->paginate(20);
        $search = $this->request->search;

        return view('settings/collectionActionCodes.index', compact('collectionActionCodes', 'search'));
    }

    public function create() {
        return view('settings/collectionActionCodes.create');
    }

    public function store(CreateRequest $request) {

        $collectionActionCode = $this->collectionActionCode;

        $collectionActionCode->code = $request->code;
        $collectionActionCode->description = $request->description;
        $collectionActionCode->form = $request->form;
        $collectionActionCode->prtr_disc = $request->prtr_disc;
        $collectionActionCode->fee_schedules = $request->fee_schedules;




        $collectionActionCode->save();

        return redirect()->route('collectionActionCode.index');
    }

    public function show($id) {

        return view('settings/collectionActionCodes.show', compact('collectionActionCode'));
    }

    public function edit($collectionActionCode) {

        return view('settings/collectionActionCodes.edit', compact('collectionActionCode'));
    }

    public function update(EditRequest $request, $collectionActionCode) {


        $collectionActionCode->code = $request->code;
        $collectionActionCode->description = $request->description;
        $collectionActionCode->form = $request->form;
        $collectionActionCode->prtr_disc = $request->prtr_disc;
        $collectionActionCode->fee_schedules = $request->fee_schedules;


        $collectionActionCode->save();
        return redirect()->route('collectionActionCode.index');
    }

    public function model($id) {

        return $this->collectionActionCode->find($id);
    }

    public function delete($id) {

        $collectionActionCode = $this->model($id);



        return view('settings/collectionActionCodes.delete', compact('collectionActionCode'));
    }

    public function destroy($collectionActionCode) {

        $id = $collectionActionCode->id;


        $collectionActionCode->delete();

        return redirect()->route('collectionActionCode.index');
    }

}
