<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Models\Config;
use Illuminate\Http\Request;
use Redirect;
use Response;
use Input;
use File;

use App\Http\Requests\Config\CreateRequest;
use App\Http\Requests\Config\EditRequest;

class ConfigController extends Controller {

    protected $request;
    protected $config;

    public function __construct(Request $request, Config $config) {

        $this->request = $request;
        $this->config = $config;

        //$this->middleware('auth');
    }

    public function index() {

        $config = $this->config;

        $pagination = config('setting.pagination');;
        $configs = $config->orderBy('id', 'DESC')->paginate($pagination);

        return view('configs.index', compact('configs'));
    }

    public function create() {
        return view('configs.create');
    }

    public function store(CreateRequest $request) {

        $config = $this->config;

        $config->name = $request->name;
        $config->state = $request->state;
        $config->value = $request->value;


        $config->save();

        return redirect()->route('config.index');
    }

    public function show($id) {

        return view('configs.show', compact('config'));
    }

    public function edit($config) {

        return view('configs.edit', compact('config'));
    }

    public function update(EditRequest $request, $config) {


        $config->name = $request->name;
        $config->state = $request->state;
        $config->value = $request->value;


        $config->save();
        return redirect()->route('config.index');
    }

    public function model($id) {

        return $this->config->find($id);
    }

    public function delete($config) {
        $id = $config->id;



        return view('configs.delete', compact('config'));
    }

    public function destroy($config) {

        $id = $config->id;


        $config->delete();

        return redirect()->route('config.index');
    }

}
