<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Models\DebtType;
use Illuminate\Http\Request;
use Redirect;
use Response;
use Input;
use File;
use App\Http\Requests\DebtType\CreateRequest;
use App\Http\Requests\DebtType\EditRequest;

class DebtTypeController extends Controller {

    protected $request;
    protected $debtType;

    public function __construct(Request $request, DebtType $debtType) {

        $this->request = $request;
        $this->debtType = $debtType;

        //$this->middleware('auth');
    }

    public function index() {

        $debtType = $this->debtType;

        //   $pagination = debtType('setting.pagination');;

        if ($this->request->ajax()) {

             $debtType = $debtType->where(function ($query) {
                $query->where('code', 'like', '%' . $this->request->term . '%');
//                        ->orWhere('description', 'like', '%' . $this->request->search . '%')
//                        ->orWhere('type', 'like', '%' . $this->request->search . '%');
            });

            return Response::json($debtType->get());
        }

         if ($this->request->has('search')) {

            $debtType = $debtType->where(function ($query) {
                $query->where('description', 'like', '%' . $this->request->search . '%')
                        ->orWhere('code', 'like', '%' . $this->request->search . '%');
            });

            $search=$this->request->search;
        }
        $search=$this->request->search;
 $debtTypes = $debtType->paginate(20);
        return view('settings/debtTypes.index', compact('debtTypes', 'search'));
    }

    public function create() {
        return view('settings/debtTypes.create');
    }

    public function store(CreateRequest $request) {

        $debtType = $this->debtType;

        $debtType->code = $request->code;
        $debtType->description = $request->description;





        $debtType->save();

        return redirect()->route('debtType.index');
    }

    public function show($id) {

        return view('settings/debtTypes.show', compact('debtType'));
    }

    public function edit($debtType) {

        return view('settings/debtTypes.edit', compact('debtType'));
    }

    public function update(EditRequest $request, $debtType) {


       $debtType->code = $request->code;
        $debtType->description = $request->description;


        $debtType->save();
        return redirect()->route('debtType.index');
    }

    public function model($id) {

        return $this->debtType->find($id);
    }

    public function delete($id) {

        $debtType = $this->model($id);



        return view('settings/debtTypes.delete', compact('debtType'));
    }

    public function destroy($debtType) {

        $id = $debtType->id;


        $debtType->delete();

        return redirect()->route('debtType.index');
    }

}
