<?php

namespace App\Http\Controllers;


use App\Http\Requests\Debtor\CreateRequest;
use App\Http\Requests\Debtor\EditRequest;
use App\Models\Client;
use App\Models\Config;
use App\Models\Debtor;
use App\Models\DebtorInvoice;
use App\Models\Field;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Facades\Excel;

class DebtorController extends Controller
{
    protected $request;
    protected $debtor;
    protected $config;
    protected $debtorInvoice;
    protected $user;
    protected $paginationSize;
    protected $client;
    protected $field;

    public function __construct(Request $request, Debtor $debtor, Config $config, DebtorInvoice $debtorInvoice, User $user, Client $client, Field $field) {
        $this->request = $request;
        $this->debtor = $debtor;
        $this->config = $config;
        $this->user = $user;
        $this->debtorInvoice = $debtorInvoice;
        $this->paginationSize = $config->find(1)->value;
        $this->client = $client;
        $this->field = $field;
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Contracts\Foundation\Application|\Illuminate\Contracts\View\Factory|\Illuminate\Contracts\View\View|Response
     */
    public function index($client = '')
    {
        $search = '';
        $debtor = $this->debtor;


        if ($this->request->ajax()) {
            if ($this->request->has('data_all')) {
                return Response()->json($debtor->get());
            }

            if ($this->request->term == '') {
                return Response::json($debtor->limit(30)->offset(30)->get());
            }
            return Response::json($debtor->where('name', 'LIKE', '%' . $this->request->term . '%')->get());
        }

        $path = explode('/', $this->request->path());
        $paginationSize = Config::find(1)->value;

        if ($path[0] == 'client') {
            $debtorsAraay = array("0" => 0);
            $debtorsAraay = $this->debtorInvoice->where('client_id', $client->id)->pluck('debtor_id')->toArray();
            $debtors = $debtor->where('debtor_code', 'like', '%' . $this->request->debtorCode . '%')->whereIn('id', $debtorsAraay)->paginate($paginationSize);

            $debtorCode = $this->request->debtorCode;
            //dd($debtors);
            return view('clients.debtors.index', compact('debtors','debtorCode' , 'client'));
        }
        $orderBy = array();
        if ($this->request->has('search')) {

            $debtor = $debtor->where(function ($query) {
                $query->where('email', 'like', '%' . $this->request->search . '%')
                    ->orWhere('debtor_code', 'like', '%' . $this->request->search . '%')
                    ->orWhere('name', 'like', '%' . $this->request->search . '%')
                    ->orWhere('first_name', 'like', '%' . $this->request->search . '%')
                    ->orWhere('last_name', 'like', '%' . $this->request->search . '%');
                ;
            });

            if(count($debtor->get()) < 1)
            {


                return redirect()->route('client.index', ['search' => $this->request->search]);
            }

            $search = $this->request->search;
        }

        if ($this->request->has('orderBy')) {
            $debtors = $debtor->orderBy($this->request->dataId, $this->request->orderBy)->paginate($this->paginationSize);
            // $orderBy['orderBy'] = $this->request->orderBy;
            $orderBy['dataId'] = $this->request->dataId;
            if ($this->request->orderBy == 'desc') {
                $orderBy['icon'] = 'fa-sort-alpha-asc';
                $orderBy['orderBy'] = 'asc';
            } else {
                $orderBy['orderBy'] = 'desc';

                $orderBy['icon'] = 'fa-sort-alpha-desc';
            }
        } else {
            $orderBy['dataId'] = 'id';
            $orderBy['icon'] = 'fa-sort-alpha-asc';
            $orderBy['orderBy'] = 'asc';
            $debtors = $debtor->orderBy('id', 'DESC')->paginate($this->paginationSize);
        }
        //  $debtors = $debtor->paginate($paginationSize);
        $fields = $this->field->where('model_id', '11')->get();
        $importEmail = array();
        if ($this->request->session()->has('importrEmail')) {
            $importEmail = $this->request->session()->get('importrEmail', []);

            $this->request->session()->forget('importrEmail');
        }

        return view('debtors.index', compact('debtors', 'fields', 'importEmail', 'search', 'orderBy'));
    }



    /**
     * Show the form for creating a new resource.
     *
     * @return Response
     */
    public function create($client = '')
    {
        $path = explode('/', $this->request->path());
        if ($path[0] == 'client') {
            return view('clients.invoices.debtor.createDebtor', compact('client'));
        }
        return view('debtors.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param Request $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function store(CreateRequest $request, $client = '')
    {
        $debtor = $this->debtor;
        $path = explode('/', $this->request->path());
        $debtor->email = $request->email;
        $debtor->name_type = $request->name_type;
        if ($request->name_type == 'company') {
            $debtor->name = $request->name;
            $debtorString = str_replace(' ', '', $request->name);
            $lenString = strlen($debtorString);
            if ($lenString > 7) {
                $debtorCode = substr($debtorString, 0, 7);
            } else {
                $debtorCode = substr($debtorString, 0, $lenString);
            }
        }
        if ($request->name_type == 'person') {
            $debtor->last_name = $request->last_name;
            $debtor->first_name = $request->first_name;
            $debtor->name = $request->last_name . ' ' . $request->first_name;
            $lastName = $request->last_name;


            $firstName = $request->first_name;

            $lenString = strlen($lastName);
            if ($lenString > 5) {
                $debtorCode = substr($lastName, 0, 5);
            } else {
                $debtorCode = substr($lastName, 0, $lenString);
            }

            $lenString = strlen($firstName);
            if ($lenString > 2) {
                $debtorCode = $debtorCode . substr($firstName, 0, 2);
            } else {
                $debtorCode = $debtorCode . substr($firstName, 0, $lenString);
            }
        }


        $debtor->mailing_address = $request->mailing_address;
        $debtor->contact_number = $request->contact_number;
        $debtor->mailing_suburb = $request->mailing_suburb;
        $debtor->mailing_state = $request->mailing_state;

        $debtor->mailing_postcode = $request->mailing_postcode;
        $debtor->debtor_code = $request->debtor_code;
        $debtor->save();

        if ($path[0] == 'client') {
            $debtorArray = array(
                'name' => $debtor->name,
                'id' => $debtor->id,
                'debtor_code' => $debtor->debtor_code
            );
            $this->request->session()->put('debtorArray', $debtorArray);
            return redirect()->route('client.debtor.invoice.create', [$client->id]);
        }
        return redirect()->route('debtor.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Contracts\Foundation\Application|\Illuminate\Contracts\View\Factory|\Illuminate\Contracts\View\View|Response
     */
    public function show($client = '', $debtor = '')
    {
        $path = explode('/', $this->request->path());
        if ($path[0] != 'client') {
            $debtor = $client;
            $client = $this->client;
        }

        $calendars = DB::table('calendars')->where('debtor_id', $debtor->id)->where('type', 'call')->orderBy('id', 'DESC')->paginate($this->paginationSize);
        $call = view('calendars.result', compact('calendars'));
        $calendars = DB::table('calendars')->where('debtor_id', $debtor->id)->where('type', 'todo')->orderBy('id', 'DESC')->paginate($this->paginationSize);
        $todo = view('calendars.result', compact('calendars'));
        $notes = DB::table('notes')->where('debtor_id', $debtor->id)->orderBy('created_at', 'DESC')->paginate($this->paginationSize);
        if ($path[0] == 'client') {
            return view('clients.debtors.show', compact('client', 'debtor', 'notes', 'call', 'todo'));
        }
        return view('debtors.show', compact('client', 'debtor', 'call', 'todo', 'notes'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Contracts\Foundation\Application|\Illuminate\Contracts\View\Factory|\Illuminate\Contracts\View\View|Response
     */
    public function edit($client, $debtor = '')
    {
        $path = explode('/', $this->request->path());
        if ($path[0] == 'client') {
            return view('clients.debtors.edit', compact('debtor', 'client'));
        } else {
            $debtor = $client;
        }
        return view('debtors.edit', compact('debtor'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param Request $request
     * @param  int  $id
     * @return Response
     */
//    public function update(EditRequest $request, $client, $debtor = '', $invoiceId)
    public function update(EditRequest $request, $client, $debtor = '',)
    {
        //$invoice = Invoice::findOrFail($invoiceId);
        $path = explode('/', $this->request->path());
        if ($path[0] != 'client') {
            $debtor = $client;
        }

        $debtor->email = $request->email;
        $debtor->name_type = $request->name_type;
        if ($request->name_type == 'company') {
            $debtor->name = $request->name;
            $debtorString = str_replace(' ', '', $request->name);
            $lenString = strlen($debtorString);
            if ($lenString > 7) {
                $debtorCode = substr($debtorString, 0, 7);
            } else {
                $debtorCode = substr($debtorString, 0, $lenString);
            }
            // $debtor->debtor_code = $debtorCode;
        }
        if ($request->name_type == 'person') {
            $debtor->last_name = $request->last_name;
            $debtor->first_name = $request->first_name;
            $debtor->name = $request->last_name . ' ' . $request->first_name;
            $lastName = $request->last_name;
            ;

            $firstName = $request->first_name;

            $lenString = strlen($firstName);
            if ($lenString > 5) {
                $debtorCode = substr($firstName, 0, 5);
            } else {
                $debtorCode = substr($firstName, 0, $lenString);
            }

            $lenString = strlen($lastName);
            if ($lenString > 2) {
                $debtorCode = $debtorCode . substr($lastName, 0, 2);
            } else {
                $debtorCode = $debtorCode . substr($lastName, 0, $lenString);
            }
            // $debtor->debtor_code = $debtorCode;
        }





        $debtor->mailing_address = $request->mailing_address;
        $debtor->mailing_suburb = $request->mailing_suburb;
        $debtor->mailing_state = $request->mailing_state;
        $debtor->mailing_postcode = $request->mailing_postcode;
        $debtor->contact_number = $request->contact_number;
        $debtor->save();
        if ($path[0] == 'client') {
            return redirect()->route('client.debtor.show', [$client->id, $debtor->id]);
            return view('clients.debtors.show', compact('debtor', 'client'));
        } else {
            return redirect()->route('debtor.index');
            return view('debtors.index', compact('debtor'));
        }
    }

    public function model($id) {
        return $this->debtor->find($id);
    }

    public function delete($debtor_id) {
        // dd($debtor);
        $debtor = $this->debtor->find($debtor_id);
        return view('debtors.delete', compact('debtor'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return Response
     */
    public function destroy($debtor)
    {
        $id = $debtor->id;

        foreach($debtor->debtorInvoice2 as $deborInvoice)
        {
            $deborInvoice->forceDelete();
        }
        foreach($debtor->payments  as $payment)
        {
            $payment->forceDelete();
        }

        foreach($debtor->dues  as $dues)
        {
            $dues->forceDelete();
        }
        foreach($debtor->clientInvoices  as $clientInvoice)
        {
            $clientInvoice->forceDelete();
        }
        foreach($debtor->invoiceFollows  as $invoiceFollow)
        {
            $invoiceFollow->forceDelete();
        }




        $debtor->forceDelete();
        return redirect()->route('debtor.index');
    }

    public function detail($client = '', $debtor = '') {
        if ($path[0] == 'client') {
            $notes = DB::table('notes')->where('debtor_id', $debtor->id)->orderBy('created_at', 'DESC')->paginate($this->paginationSize);
            return view('debtors.show', compact('debtor', 'notes'));
        }
        $debtor = $client;
        $notes = DB::table('notes')->where('debtor_id', $debtor->id)->orderBy('created_at', 'DESC')->paginate($this->paginationSize);
        return view('debtors.show', compact('debtor', 'notes'));
    }

    public function invoice($debtor) {
        // $debtorInvoice = $this->debtorInvoice;
        $paginationSize = Config::find(1)->value;
        $invoices = $this->debtorInvoice->where('debtor_id', $debtor->id)->paginate($paginationSize);
        return view('debtors.invoice', compact('debtor', 'invoices'));
    }

    public function debtor($debtor) {
        $paginationSize = Config::find(1)->value;
        $debtors = $debtor->debtors()->paginate($paginationSize);
        return view('debtors.debtor', compact('debtor', 'debtors'));
    }

    public function export()
    {

        //  dd($this->request->all());


        $all = $this->request->all();

        $id_array = array();
        $id_key = 0;
        $field_array = array();
        $field_key = 0;
        foreach ($all as $key => $value) {


            if (strpos($key, 'export_') !== false) {
                $keyId = str_replace('export_', '', $key);
                $id_array[$id_key] = $value;
                $id_key = $id_key + 1;
            }
            if (strpos($key, 'field_') !== false) {
                $field_array[$field_key] = $value;
                $field_key = 1 + $field_key;
            }
        }
        //dd($id_array);

        $debtors = $this->debtor->whereIn('id', $id_array)->get();

        $fileArray = array();
        foreach ($debtors as $key => $debtor) {
            foreach ($field_array as $field) {
                $fileArray[$key][$field] = $debtor[$field];
            }
        }
        //dd($this->request->exportFor);
        if ($this->request->exportFor == 'excel') {
            Excel::create('client', function ($excel) use ($fileArray) {

                $excel->sheet('Sheetname', function ($sheet) use ($fileArray) {

                    $sheet->fromArray($fileArray);
                });
            })->export('xls');
        }
        if ($this->request->exportFor == 'csv') {
            Excel::create('client', function ($excel) use ($fileArray) {

                $excel->sheet('Sheetname', function ($sheet) use ($fileArray) {

                    $sheet->fromArray($fileArray);
                });
            })->export('csv');
        }
        return 1;
        //  return redirect()->route('client.index');
    }

    public function import() {
        $datas['import_type'] = 'upload';
        return view('debtors.import', compact('datas'));
    }

}
