<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
//use Illuminate\Support\Facades\File;
use Redirect;
use Response;
use Input;
use File;
use App\Models\Client;
use App\Models\Debtor;
use App\Models\Config;
use App\Models\User;
use App\Models\Mail;
use App\Models\Mail as Mailsend;
use App\Models\EmailTemplate;
use App\Models\MailField;
use App\Models\DebtorInvoice;
use App\Models\ClientInvoice;
use App\Models\DebtorInvoicePdf;
use App\Models\DebtType;
use App\Models\InvoiceFollow;
use App\Models\Calendar;
use App\Models\InvoiceCharge;
use App\Http\Requests\DebtorInvoice\CreateRequest;
use App\Http\Requests\DebtorInvoice\EditRequest;
use Illuminate\Support\Facades\Validator;
use App\Models\Solicitor;
class DebtorInvoiceController extends Controller {

    protected $request;
    protected $client;
    protected $debtor;
    protected $config;
    protected $paginationSize;
    protected $user;
    protected $debtorInvoice;
    protected $clientInvoice;
    protected $mailField;
    protected $toData = '';
    protected $ccData = '';
    protected $bccData = '';
    protected $loginUser;
    protected $connection;
    protected $mail;
    protected $emailTemplate;
    protected $solicitor;
    protected $debtorInvoicePdf;
    protected $debtType;
    protected $follow;
    protected $calendar;
    protected $invoiceCharge;

    public function __construct(Request $request, Client $client, Debtor $debtor, Config $config, User $user, DebtorInvoice $debtorInvoice, ClientInvoice $clientInvoice, Mail $mail, MailField $mailField, Auth $auth, EmailTemplate $emailTemplate, Solicitor $solicitor, DebtorInvoicePdf $debtorInvoicePdf, DebtType $debtType, InvoiceFollow $follow, Calendar $calendar, InvoiceCharge $invoiceCharge) {

        $this->request = $request;
        $this->client = $client;
        $this->debtor = $debtor;
        $this->config = $config;
        $this->user = $user;
        $this->debtorInvoice = $debtorInvoice;
        $this->clientInvoice = $clientInvoice;
        $this->paginationSize = $config->find(1)->value;
        $this->mailField = $mailField;
        $this->loginUser = Auth::user();
        $this->mail = $mail;
        $this->emailTemplate = $emailTemplate;
        $this->solicitor = $solicitor;
        $this->debtorInvoicePdf = $debtorInvoicePdf;
        $this->debtType = $debtType;
        $this->follow = $follow;
        $this->calendar = $calendar;
        $this->invoiceCharge = $invoiceCharge;

        //$this->middleware('auth');
    }

    public function index() {



        $debtorInvoice = $this->debtorInvoice;


        if ($this->request->ajax()) {
            if ($this->request->has('id')) {
                $data = $debtorInvoice->find($this->request->id);

                $data->clientName = $data->client->name;
                $data->debtorName = $data->debtor->name;
                return Response::json($data);
            }

            return Response::json($debtorInvoice->where('invoice_code', 'LIKE', '%' . $this->request->term . '%')->get());
        }
    }

    public function create($client) {


        // $debtors = $this->debtor->where('id', 0)->pluck('email', 'id');
        $users = $this->user->pluck('email', 'id')->toArray();
        $debtorArray = array();

        $debtorArray = array(
            'name' => '22',
            'id' => '',
            'debtor_code' => ''
        );
        $debtorArray['set'] = 'no';
        // $this->request->session()->forget('debtorArray');
        //  $this->request->session()->push('debtorArray', $debtorArray);
        // dd($this->request->session()->has('debtorArray'));
        //dd($this->request->session()->get('debtorArray', [])[0]);
        if ($this->request->session()->has('debtorArray')) {
            $debtorArray = $this->request->session()->get('debtorArray', []);
            $this->request->session()->forget('debtorArray');
            $debtorArray['set'] = true;
        }


        return view('clients.invoices.debtor.create', compact('client', 'debtorArray', 'users'));
    }

    public function store(CreateRequest $request, $client) {
        $debtor_id = $request->debtor_id;
//        $withPivotArray = array(
//            'invoice_state' => $request->invoice_state,
//            'invoice_date' => $request->invoice_date,
//            'account_state' => $request->account_state,
//            'user_id' => $request->user_id,
//            'original_debt' => $request->original_debt,
//            'current_balance' => $request->current_balance,
//            'original_debt' => $request->original_debt,
//            'last_payment' => $request->last_payment,
//            'last_paid' => $request->last_paid
//        );
//        $client->debtorInvoice()->attach($debtor_id, $withPivotArray);
        $debtorInvoice = $this->debtorInvoice;
        $debtorInvoice->debtor_id = $debtor_id;
        $debtorInvoice->client_id = $client->id;
        $debtorInvoice->invoice_date = $request->invoice_date;
        $debtorInvoice->account_state = $request->account_state;
        $debtorInvoice->invoice_status_code_id = $request->invoice_status_code_id;
        $debtorInvoice->debt_type_id = $request->debt_type_id;
        $debtorInvoice->user_id = $request->user_id;
        $debtorInvoice->original_debt = $request->original_debt;
        $debtorInvoice->current_balance = $request->current_balance;
        $debtorInvoice->original_debt = $request->original_debt;
        $debtorInvoice->last_payment = $request->last_payment;
        $debtorInvoice->last_paid = $request->last_paid;
        $debtorInvoice->invoice_state = $request->invoice_state;

        $debtorInvoice->reference1 = $request->reference1;
        $debtorInvoice->reference2 = $request->reference2;
        $debtorInvoice->reference3 = $request->reference3;
        $debtorInvoice->reference4 = $request->reference4;
        $debtorInvoice->reference5 = $request->reference5;

        //
        $debtorInvoice->solicitor_id = $request->solicitor_id;
        //
        $debtorInvoice->solicitor_cost_date = $request->solicitor_cost_date;
        $debtorInvoice->recoverable_cost_date = $request->recoverable_cost_date;
        $debtorInvoice->non_recoverable_cost_date = $request->non_recoverable_cost_date;
        $debtorInvoice->debt_recovered_date = $request->debt_recovered_date;
        $debtorInvoice->costs_recovered_date = $request->costs_recovered_date;
        $debtorInvoice->total_paid = $debtorInvoice->original_debt - $debtorInvoice->current_balance;
        $chargeType = 0;
        if ($request->charge_type == 1) {
            $chargeType = 1;
        }
        $debtorInvoice->charge_type = $chargeType;
        $debtorInvoice->save();


        $clientInvoice = $this->clientInvoice;
        $clientInvoice->client_id = $client->id;
        $clientInvoice->debtor_id = $debtor_id;
        $clientInvoice->debtor_invoice_id = $debtorInvoice->id;
        $clientInvoice->save();

        $idlen = strlen($clientInvoice->id);

        //$debtorInvoiceCode = 'DIn' . $len . $debtorInvoice->id;
        if ($request->debtor_invoice_code != '') {
            $debtorInvoice->invoice_code = $request->debtor_invoice_code;
        }
        $debtorInvoice->save();
        //  $clientInvoiceCode = 'CIn' . $len . $clientInvoice->id;
        $clientInvoice->commission_amount = 20;
        // $clientInvoice->invoice_code = $clientInvoiceCode;
        $clientInvoice->save();


        // FDL mail send start

        $mail = $this->mail;
        $emailTemplate = $this->emailTemplate;
        $emailTemplates = $emailTemplate->find(1);
        $debtorModel = $this->debtor->find($debtor_id);
        $emailContent = $emailTemplates->content;

        $emailContent = $emailTemplates->content;
        $emailContent = $this->replaceEmailVariable('client', $client, $emailContent);
        $emailContent = $this->replaceEmailVariable('debtor', $debtorModel, $emailContent);
        $emailContent = $this->replaceEmailVariable('debtor-invoice', $debtorInvoice, $emailContent);

        $subject = $this->replaceEmailVariable('client', $client, $emailTemplates->subject);
        $subject = $this->replaceEmailVariable('debtor', $debtorModel, $subject);
        $subject = $this->replaceEmailVariable('debtor-invoice', $debtorInvoice, $subject);
//        echo '<pre>';
//        var_dump($emailContent);exit;
        $mail->content = $emailContent;

        $mail->subject = $subject;
        $mail->user_id = Auth::user()->id;


        $mail->save();
        $closureData = array();

        $closureData['to'] = $debtorModel->email;
        $closureData['cc'] = array();
        $closureData['bcc'] = array();
        $mail->cc = json_encode($closureData['cc']);
        $mail->bcc = json_encode($closureData['bcc']);
        $mail->to = json_encode($closureData['to']);
        $mail->save();

        //  $closureData['to'] = explode(',', $this->request->to);
        $closureData['subject'] = $subject;
        $data = array();

        $data['content'] = $emailContent;


        $closureData['fromMail'] = Auth::user()->office_mail;

        $validator = Validator::make(
                        ['name' => Auth::user()->office_mail], ['name' => 'required|email']
        );
        if ($validator->fails()) {
            // The given data did not pass validation
            $closureData['fromMail'] = Auth::user()->email;
        }
        /**
          Mailsend::queue('emails.test', $data, function($message) use($closureData) {
          $message->to($closureData['to'])->subject($closureData['subject']);
          $message->from($closureData['fromMail']);
          $message->cc($closureData['cc']);


          $message->bcc($closureData['bcc']);
          });
          //END

         * */
        return redirect()->route('client.debtor.invoice', [$client->id]);
    }

    public function edit($model, $id) {

        $path = explode('/', $this->request->path());

        if ($path[0] == 'debtor') {
            $debtor = $model;
        } else {
            $client = $model;
        }
        // $invoice = $client->debtorInvoice()->wherePivot('id', $id)->first();
        $debtorInvoice = $this->debtorInvoice;
        $debtorInvoice = $debtorInvoice->find($id);
        $invoice = $debtorInvoice;
        $debtors = $this->debtor->pluck('debtor_code', 'id')->toArray();
        $users = $this->user->pluck('email', 'id')->toArray();
        if ($path[0] == 'debtor') {
            return view('debtors.invoiceEdit', compact('debtor', 'debtors', 'users', 'invoice'));
        }
        return view('clients.invoices.debtor.edit', compact('client', 'debtors', 'users', 'invoice'));
    }

    public function show($model, $id) {

        // $invoice = $client->debtorInvoice()->wherePivot('id', $id)->first();
        $path = explode('/', $this->request->path());

        if ($path[0] == 'debtor') {
            $debtor = $model;
        } else {
            $client = $model;
        }
        $debtorInvoice = $this->debtorInvoice;
        $debtorInvoice = $debtorInvoice->find($id);
        $invoice = $debtorInvoice;
        $notes = DB::table('notes')->where('debtor_invoice_id', $debtorInvoice->id)->orderBy('created_at', 'DESC')->paginate($this->paginationSize);
        $debtor = $this->debtor->find($invoice->debtor_id);
        $client = $this->client->find($invoice->client_id);
        $solicitor = $this->solicitor->find($invoice->solicitor_id);
        $emailTemplate = $this->emailTemplate;
        $FDLEmailTemplate = $emailTemplate->find(1);

        $emailContent = $FDLEmailTemplate->content;
        $emailContent = $this->replaceEmailVariable('client', $client, $emailContent);
        $emailContent = $this->replaceEmailVariable('debtor', $debtor, $emailContent);
        $emailContent = $this->replaceEmailVariable('debtor-invoice', $invoice, $emailContent);
        if($debtorInvoice->debt_type_id == 0)
        {
            $description= '';
            if( $this->debtType->where('code', $debtorInvoice->details_debt_code)->count())
            {
                 $description = $this->debtType->where('code', $debtorInvoice->details_debt_code)->first()->description;
            }
            $emailContent = str_replace( '$debt-type-description$', $description, $emailContent);
        }
        else
        {
            $description =$debtorInvoice->debtType->description;
             $emailContent = str_replace( '$debt-type-description$', $description, $emailContent);
        }
        $FDLEmailTemplate->content = $emailContent;

        //   dd($invoice->getAttributes());

        $subject = $this->replaceEmailVariable('client', $client, $FDLEmailTemplate->subject);
        $subject = $this->replaceEmailVariable('debtor', $debtor, $subject);
        $subject = $this->replaceEmailVariable('debtor-invoice', $invoice, $subject);
        $FDLEmailTemplate->subject = $subject;

        $solicitorEmailTemplate = $emailTemplate->find(3);
        $solicitorEmailContent = $solicitorEmailTemplate->content;
        $solicitorEmailContent = $this->replaceEmailVariable('client', $client, $solicitorEmailContent);
        $solicitorEmailContent = $this->replaceEmailVariable('debtor', $debtor, $solicitorEmailContent);
        $solicitorEmailContent = $this->replaceEmailVariable('debtor-invoice', $invoice, $solicitorEmailContent);
        $solicitorEmailContent = $this->replaceEmailVariable('solicitor', $solicitor, $solicitorEmailContent);
        $solicitorEmailTemplate->content = $solicitorEmailContent;

        $solicitorEmailSubject = $this->replaceEmailVariable('client', $client, $solicitorEmailTemplate->subject);
        $solicitorEmailSubject = $this->replaceEmailVariable('debtor', $debtor, $solicitorEmailSubject);
        $solicitorEmailSubject = $this->replaceEmailVariable('debtor-invoice', $invoice, $solicitorEmailSubject);
        $solicitorEmailTemplate->subject = $solicitorEmailSubject;

        if ($this->request->action == 'fdlPdf') {
             $view = view('pdfs.invoiceFdlPdf', compact('FDLEmailTemplate'));
             $view = view('layouts.fdlPdf2', compact('debtor'));
             $view = $this->fdlEditF($view, $client ,$debtor , $invoice );

            //$html = $view->render();
              $pdf = \App::make('dompdf.wrapper');
            //  dd($html);
                    $pdf->loadHTML($view);
          return   $pdf->stream('FDL.pdf');
            return view('pdfs.invoiceFdlPdf', compact('FDLEmailTemplate'));
            //dd($this->request->action);
        }

       // $view = view('pdfs.invoiceFdlPdf', compact('FDLEmailTemplate'));
             $viewA2 = view('layouts.letters.emails.a2', compact('debtor'));
            // dd(1);
             $viewA2 = $this->fdlEditF($viewA2, $client ,$debtor , $invoice );
             $viewA2 = $this->dueData($viewA2 , $invoice);
            //$html = $view->render();



         if ($this->request->action == 'a2') {
             $view = view('pdfs.invoiceFdlPdf', compact('FDLEmailTemplate'));
             $view = view('layouts.a2', compact('debtor'));
            // dd(1);
             $view = $this->fdlEditF($view, $client ,$debtor , $invoice );
             $view = $this->dueData($view , $invoice);
            //$html = $view->render();
              $pdf = \App::make('dompdf.wrapper');
            //  dd($html);
                    $pdf->loadHTML($view);
          return   $pdf->stream('a2.pdf');
            return view('pdfs.invoiceFdlPdf', compact('FDLEmailTemplate'));
            //dd($this->request->action);
        }

        $viewItg = view('layouts.letters.emails.itg', compact('debtor'));
            // dd(1);
             $viewItg = $this->fdlEditF($viewItg, $client ,$debtor , $invoice );
             $viewItg = $this->dueData($viewItg , $invoice);

         if ($this->request->action == 'itg') {
             $view = view('pdfs.invoiceFdlPdf', compact('FDLEmailTemplate'));
             $view = view('layouts.itg', compact('debtor'));
            // dd(1);
             $view = $this->fdlEditF($view, $client ,$debtor , $invoice );
             $view = $this->dueData($view , $invoice);
            //$html = $view->render();
              $pdf = \App::make('dompdf.wrapper');
            //  dd($html);
                    $pdf->loadHTML($view);
          return   $pdf->stream('itg.pdf');
            return view('pdfs.invoiceFdlPdf', compact('FDLEmailTemplate'));
            //dd($this->request->action);
        }
        $viewSfn = view('layouts.letters.emails.sfn', compact('debtor'));
            // dd(1);
             $viewSfn = $this->fdlEditF($viewSfn, $client ,$debtor , $invoice );
             $viewSfn = $this->dueData($viewSfn , $invoice);
         if ($this->request->action == 'sfn') {
             $view = view('pdfs.invoiceFdlPdf', compact('FDLEmailTemplate'));
             $view = view('layouts.sfn', compact('debtor'));
            // dd(1);
             $view = $this->fdlEditF($view, $client ,$debtor , $invoice );
             $view = $this->dueData($view , $invoice);
            //$html = $view->render();
              $pdf = \App::make('dompdf.wrapper');
            //  dd($html);
                    $pdf->loadHTML($view);
          return   $pdf->stream('itg.pdf');
            return view('pdfs.invoiceFdlPdf', compact('FDLEmailTemplate'));
            //dd($this->request->action);
        }

        $viewAb = view('layouts.letters.emails.ab', compact('debtor'));
            // dd(1);
             $viewAb = $this->fdlEditF($viewAb, $client ,$debtor , $invoice );
             $viewAb = $this->dueData($viewAb , $invoice);

         if ($this->request->action == 'ab') {

             $view = view('layouts.ab', compact('debtor'));
            // dd(1);
             $view = $this->fdlEditF($view, $client ,$debtor , $invoice );
             $view = $this->dueData($view , $invoice);
            //$html = $view->render();
              $pdf = \App::make('dompdf.wrapper');
            //  dd($html);
                    $pdf->loadHTML($view);
          return   $pdf->stream('itg.pdf');
            return view('pdfs.invoiceFdlPdf', compact('FDLEmailTemplate'));
            //dd($this->request->action);
        }

        $receipt = view('layouts.letters.emails.receipt', compact('debtor'));
            // dd(1);
             $receipt = $this->fdlEditF($receipt, $client ,$debtor , $invoice );
             $receipt = $this->dueData($receipt , $invoice);

        if ($this->request->action == 'receipt') {

             $view = view('layouts.receipt', compact('debtor'));
            // dd(1);
             $view = $this->fdlEditF($view, $client ,$debtor , $invoice );
             $view = $this->dueData($view , $invoice);
            //$html = $view->render();
              $pdf = \App::make('dompdf.wrapper');
            //  dd($html);
                    $pdf->loadHTML($view);
          return   $pdf->stream('itg.pdf');
            return view('pdfs.invoiceFdlPdf', compact('FDLEmailTemplate'));
            //dd($this->request->action);
        }

        $mails = $this->mail;

        if ($path[0] == 'debtor') {
            return view('debtors.invoiceDetail', compact('debtor', 'invoice', 'notes', 'mails'));
        }




        return view('clients.invoices.debtor.show', compact('client', 'invoice', 'notes', 'debtor', 'solicitor', 'FDLEmailTemplate', 'solicitorEmailTemplate', 'mails', 'viewA2', 'viewAb', 'viewSfn', 'viewItg', 'receipt'));
    }

    public function pdf($client, $id, $action = '') {


        $debtorInvoice = $this->debtorInvoice;
        $debtorInvoice = $debtorInvoice->find($id);
        $invoice = $debtorInvoice;

        $debtor = $this->debtor->find($invoice->debtor_id);
        $client = $this->client->find($invoice->client_id);




        // dd(1);

        $pdf = \App::make('dompdf.wrapper');
        $total_paid = number_format((float) $invoice->original_debt - (float) $invoice->current_balance, '2');
        $debtor = $this->debtor->find($invoice->debtor_id);

        // dd($invoice);
        $pdf->loadView('pdfs/debtorInvoicePdf', compact('invoice', 'client', 'debtor', 'total_paid'));
        $pdfData = $pdf->stream();

        if ($this->request->ajax()) {

            $filePath = 'assets/invoice/' . $debtor->id;
            if (!(File::exists($filePath))) {
                // File::makeDirectory($path, 0777, true, true);
                $result = File::makeDirectory($filePath, 0775);
                //chmod($filePath, 0777);
            }
            $pdf->save($filePath . '1.pdf');
            return Response::json(2);
        }

        if ($this->request->action == 'view') {
            return $pdf->stream();
        }
        return view('clients.invoices.debtor.pdfs.view', compact('client', 'invoice', 'debtor', 'pdfData'));
    }

    public function pdfPost($client, $id, $action = '') {


        $debtorInvoice = $this->debtorInvoice;
        $debtorInvoice = $debtorInvoice->find($id);
        $invoice = $debtorInvoice;

        $debtor = $this->debtor->find($invoice->debtor_id);
        $client = $this->client->find($invoice->client_id);


        // dd(1);

        $pdf = \App::make('dompdf.wrapper');
        $total_paid = number_format((float) $invoice->original_debt - (float) $invoice->current_balance, '2');
        $debtor = $this->debtor->find($invoice->debtor_id);

        // dd($invoice);
        $pdf->loadView('pdfs/debtorInvoicePdf', compact('invoice', 'client', 'debtor', 'total_paid'));
        $pdfData = $pdf->stream();
        $filePath = 'assets/invoice/debtor/' . $debtor->id;
        //  chmod($filePath, 0777);
        if ($this->request->ajax()) {


            if (!(File::exists($filePath))) {
                $result = File::makeDirectory($filePath, 0777, true, true);
                //  $result = File::makeDirectory($filePath, 0777);
                chmod($filePath, 0777);
            }

            $debtorInvoicePdf = $this->debtorInvoicePdf;


            $debtorInvoicePdf->invoice_id = $id;
            $debtorInvoicePdf->save();
            $filePathUrl = $filePath . '/' . $debtorInvoicePdf->id . '.pdf';
            $pdf->save($filePathUrl);
            chmod($filePathUrl, 0777);
            $debtorInvoicePdf->path = $filePathUrl;
            $debtorInvoicePdf->save();
            return Response::json(1);
        } else {


            if (!(File::exists($filePath))) {
                $result = File::makeDirectory($filePath, 0777, true, true);
                //  $result = File::makeDirectory($filePath, 0777);
                chmod($filePath, 0777);
            }


            $filePathUrl = $filePath . '/invoice.pdf';
            $pdf->save($filePathUrl);
            chmod($filePathUrl, 0777);
            $closureData = array();
            $request = $this->request;

            $closureData['to'] = $request->to;
            $closureData['fromMail'] = 'antoinette@ctcdebtcollections.com.au';
            $closureData['subject'] = $request->subject;
            $closureData['emailTemplate'] = 'emails.test';
            // $emailTemplate = 'emails.test';
            $data = ['content' => $request->content];
            $closureData['path'] = $filePathUrl;
            $closureData['name1'] = 'test.pdf';
            ;
            //$this->sendMail($closureData, $data, $pdfData);

            Mailsend::queue($closureData['emailTemplate'], $data, function($message) use($closureData) {
                $message->to($closureData['to'], 'test')->subject($closureData['subject']);
                $message->from($closureData['fromMail'], 'test');
                $message->attach($closureData['path']);
                // $message->attachData($closureData['file1'], $closureData['name1']);
                // $message->cc($closureData['cc']);
                // $message->bcc($closureData['bcc']);
            });
        }

        return redirect()->route('client.debtor.invoice.pdf', [$client->id, $invoice->id]);
    }

    public function update($model, $id) {
        $request = $this->request;

        $path = explode('/', $this->request->path());

        if ($path[0] == 'debtor') {
            $debtor = $model;
        } else {
            $client = $model;
        }



        $debtorInvoice = $this->debtorInvoice;
        $debtorInvoice = $debtorInvoice->find($id);
        if($request->has('fdl_state'))
        {
            $debtorInvoice->fdl_state = 'FDL send';
            $debtorInvoice->action_1st_letter_code = 'FDL';
            $debtorInvoice->save();
            if(count($debtorInvoice->follows) < 1)
            {
            $todayDate = date("d/m/Y");
                    $date = new \DateTime(date("Y-m-d"));
        $date->add(new \DateInterval('P14D'));

         $follow = $this->follow;
        $follow->collection_action_code_id = 16;
       // dd($date->format('d/m/Y'));
        $follow->next_follow_date = $date->format('d/m/Y');
        $follow->date = $todayDate;
           $follow->status = 'followed';
        $invoice = $debtorInvoice;
        //dd($this->follow->where("debtor_invoice_id", $invoice->id)->where("collection_action_code_id", ">",  0)->orderBy('id', 'DESC')->get());
        $follow->client_id = $invoice->client_id;
        $follow->debtor_id = $invoice->debtor_id;
        $follow->user_id = $invoice->user_id;
        $follow->debtor_invoice_id = $invoice->id;

      //  $follow->save();
            }

       // $follow->next_follow_date = $date->format('Y-m-d');
            return redirect()->route('client.debtor.invoice.show', [$client->id, $debtorInvoice->id]);
        }
        $invoice_state = $debtorInvoice->invoice_state;
        if ($debtorInvoice->invoice_state == 'legal action') {
            $debtorInvoice->plaint_filed = $request->plaint_filed;
            $debtorInvoice->plaint_served = $request->plaint_served;
            $debtorInvoice->court = $request->court;
            $debtorInvoice->plaint_number = $request->plaint_number;
            $debtorInvoice->judgement_date = $request->judgement_date;
            $debtorInvoice->arrangement = $request->arrangement;
        }


        $debtorInvoice->reference1 = $request->reference1;
        $debtorInvoice->reference2 = $request->reference2;
        $debtorInvoice->reference3 = $request->reference3;
        $debtorInvoice->reference4 = $request->reference4;
        $debtorInvoice->reference5 = $request->reference5;


        $debtorInvoice->invoice_state = $request->invoice_state;
        $debtorInvoice->invoice_date = $request->invoice_date;
        $debtorInvoice->account_state = $request->account_state;
        $debtorInvoice->user_id = $request->user_id;
        $debtorInvoice->original_debt = $request->original_debt;
        $debtorInvoice->current_balance = $request->current_balance;
        $debtorInvoice->original_debt = $request->original_debt;
        $debtorInvoice->last_payment = $request->last_payment;
        $debtorInvoice->last_paid = $request->last_paid;
        $debtorInvoice->total_paid = $debtorInvoice->original_debt - $debtorInvoice->current_balance;
        if($debtorInvoice->invoice_status_code_id != $request->invoice_status_code_id )
        {
            $debtorInvoice->prev_invoice_status_code_id =$debtorInvoice->invoice_status_code_id;
        }
        $debtorInvoice->invoice_status_code_id = $request->invoice_status_code_id;
        $debtorInvoice->debt_type_id = $request->debt_type_id;
        // acount detail

        $debtorInvoice->solicitor_id = $request->solicitor_id;

        $debtorInvoice->solicitor_cost_date = $request->solicitor_cost_date;
        $debtorInvoice->recoverable_cost_date = $request->recoverable_cost_date;
        $debtorInvoice->non_recoverable_cost_date = $request->non_recoverable_cost_date;
        $debtorInvoice->debt_recovered_date = $request->debt_recovered_date;
        $debtorInvoice->costs_recovered_date = $request->costs_recovered_date;
        $chargeType = 0;
        if ($request->charge_type == 1) {
            $chargeType = 1;
        }
        $debtorInvoice->charge_type = $chargeType;
        if ($request->debtor_invoice_code != '') {
            $debtorInvoice->invoice_code = $request->debtor_invoice_code;
        }

        $debtorInvoice->save();

        if ($path[0] == 'debtor') {
            if ($invoice_state != 'legal action' && $request->invoice_state == 'legal action') {
                return redirect()->route('debtor.invoice.edit', [$debtor->id, $id]);
            }
            return redirect()->route('debtor.invoice', [$debtor->id]);
        }

        if ($invoice_state != 'legal action' && $request->invoice_state == 'legal action') {
            return redirect()->route('client.debtor.invoice.edit', [$client->id, $id]);
        }
        return redirect()->route('client.debtor.invoice', [$client->id]);
    }

    public function mailstore($model, $id) {

        $request = $this->request;
        // FDL mail send start
        $debtorInvoice = $this->debtorInvoice;
        $debtorInvoice = $debtorInvoice->find($id);
        $invoice = $debtorInvoice;
        $debtor = $this->debtor->find($invoice->debtor_id);
        $client = $this->client->find($invoice->client_id);
        $mail = $this->mail;
//        echo '<pre>';
//        var_dump($emailContent);exit;
        $mail->content = $request->content;

        $mail->subject = $request->subject;
        $mail->user_id = $this->loginUser->id;


        $mail->save();
        $closureData = array();

        $closureData['to'] = $request->to;
        $closureData['cc'] = array();
        $closureData['bcc'] = array();
        $mail->cc = json_encode($closureData['cc']);
        $mail->bcc = json_encode($closureData['bcc']);
        $mail->to = json_encode($closureData['to']);
         $mail->related_type = 'DebtorInvoice';
           $mail->related_id = $debtorInvoice->id;
        $mail->save();

        //  $closureData['to'] = explode(',', $this->request->to);
        $closureData['subject'] = $request->subject;
        $data = array();

        $data['content'] = $request->content;


        $closureData['fromMail'] = $this->loginUser->office_mail;

        $validator = Validator::make(
                        ['name' => $this->loginUser->office_mail], ['name' => 'required|email']
        );
        if ($validator->fails()) {
            // The given data did not pass validation
            $closureData['fromMail'] = $this->loginUser->email;
        }

        Mailsend::queue('emails.test', $data, function($message) use($closureData) {
            $message->to($closureData['to'])->subject($closureData['subject']);
            $message->from($closureData['fromMail']);
            $message->cc($closureData['cc']);


            $message->bcc($closureData['bcc']);
        });
        //END

        if($request->has('collection_action_code_id'))
        {


//        $follow = $this->follow;
//
//        $follow->collection_action_code_id = $request->collection_action_code_id;
//
//
//        $dateToday = date("d/m/Y");
//
//               $follow->date = $dateToday;
//        $date = new \DateTime(date("Y-m-d"));
//        $date->add(new \DateInterval('P14D'));
////
//        $follow->next_follow_date = $date->format('d/m/Y');
//        $follow->status = 'followed';
//
//        //dd($this->follow->where("debtor_invoice_id", $invoice->id)->where("collection_action_code_id", ">",  0)->orderBy('id', 'DESC')->get());
//        $follow->client_id = $invoice->client_id;
//        $follow->debtor_id = $invoice->debtor_id;
//        $follow->user_id = $invoice->user_id;
//        $follow->debtor_invoice_id = $invoice->id;
//
//        $follow->save();
//
//
//        foreach ($this->follow->where("debtor_invoice_id", $invoice->id)->where("collection_action_code_id", "!=", 0)->orderBy('id', 'DESC')->get() as $kye => $followData) {
//            if ($kye == 0) {
//                $invoice->last_action = $followData->collectionActionCode->code;
//            }
//            if ($kye == 1) {
//                $invoice->action_1st_letter_code = $followData->collectionActionCode->code;
//            }
//            if ($kye == 2) {
//                $invoice->action_2nd_letter_code = $followData->collectionActionCode->code;
//            }
//            if ($kye == 3) {
//                $invoice->action_3rd_letter_code = $followData->collectionActionCode->code;
//            }
//        }
//
//        $invoice->save();
//
//
//
//
////        $calendar = $this->calendar;
////
////
////        //$date = new \DateTime($request->next_follow_date);
////        //    $date->add(new \DateInterval('P14D'));
////        $calendar->name = 'Follow up :' . $invoice->debtor->debtor_code;
////
////        $calendar->user_id = $invoice->user_id;
////        $calendar->client_id = $invoice->client_id;
////        $calendar->debtor_id = $invoice->debtor_id;
////        $calendar->invoice_id = $invoice->id;
////        $calendar->status = 'create';
////        $calendar->type = 'todo';
////        $calendar->start_date = $request->next_follow_date;
////        $calendar->start_time = $request->start_time;
////        $calendar->end_date = $request->next_follow_date;
////        $calendar->end_time = $request->end_time;
////        $calendar->remainder = 0;
////
////        $calendar->save();
//
//
//        if($request->collection_action_code_id == 16)
//            {
//            $invoice->fdl_state = 'FDL send';
//            $invoice->save();
//            $invoiceCharge = $this->invoiceCharge;
//            $invoiceCharge->type = 'FDL';
//            $invoiceCharge->entry_date =$request->date;
//            $invoiceCharge->amount = $client->final_demand_rate;
//
//            $invoiceCharge->save();
//            }
//
//

        }


        return redirect()->route('client.debtor.invoice.show', [$client->id, $invoice->id]);
    }


     public function delete($model, $id) {

        $path = explode('/', $this->request->path());

        if ($path[0] == 'debtor') {
            $debtor = $model;
        } else {
            $client = $model;
        }
        // $invoice = $client->debtorInvoice()->wherePivot('id', $id)->first();
        $debtorInvoice = $this->debtorInvoice;
        $debtorInvoice = $debtorInvoice->find($id);
        $invoice = $debtorInvoice;
        $debtors = $this->debtor->pluck('debtor_code', 'id')->toArray();
        $users = $this->user->pluck('email', 'id')->toArray();
        if ($path[0] == 'debtor') {
            return view('debtors.invoiceEdit', compact('debtor', 'debtors', '', 'users', 'invoice'));
        }
        return view('clients.invoices.debtor.delete', compact('client',  'users', 'invoice'));


    }

    public function destroy($model, $id) {


         $path = explode('/', $this->request->path());

        if ($path[0] == 'debtor') {
            $debtor = $model;
        } else {
            $client = $model;
        }
        // $invoice = $client->debtorInvoice()->wherePivot('id', $id)->first();
        $debtorInvoice = $this->debtorInvoice;
        $debtorInvoice = $debtorInvoice->find($id);
        $invoice = $debtorInvoice;




        foreach($invoice->payments  as $payment)
        {
            $payment->forceDelete();
        }

        foreach($invoice->dues  as $dues)
        {
            $dues->forceDelete();
        }
        foreach($invoice->clientInvoices  as $clientInvoice)
        {
            $clientInvoice->forceDelete();
        }
        foreach($invoice->follows  as $invoiceFollow)
        {
            $invoiceFollow->forceDelete();
        }




        $invoice->forceDelete();
        return redirect()->route('client.debtor.invoice', [$client->id]);
    }

    /**
     *
     * @param type $moduleName string
     * @param type $model object ModuleModel
     * @param type $content string
     * @return type string
     */
    public function replaceEmailVariable($moduleName = false, $model = array(), $content = '') {
        if ($moduleName && $content != '' && !is_null($model)) {
            $content = str_replace('$current-date$', date('d/m/Y'), $content);
            foreach ($model->getAttributes() as $fieldName => $fieldValue) {
                $content = str_replace('$' . $moduleName . '-' . $fieldName . '$', $fieldValue, $content);
            }
        }
        return $content;
    }

    public function fdlEditF($view, $client ,$debtor , $invoice )
    {
        $emailContent = $view;
        $emailContent = $this->replaceEmailVariable('client', $client, $emailContent);
        $emailContent = $this->replaceEmailVariable('debtor', $debtor, $emailContent);
        $emailContent = $this->replaceEmailVariable('debtor-invoice', $invoice, $emailContent);
        if($invoice->debt_type_id == 0)
        {
            $description= '';
            if( $this->debtType->where('code', $invoice->details_debt_code)->count())
            {
                 $description = $this->debtType->where('code', $invoice->details_debt_code)->first()->description;
            }
            $emailContent = str_replace( '$debt-type-description$', $description, $emailContent);
        }
        else
        {
            $description =$invoice->debtType->description;
             $emailContent = str_replace( '$debt-type-description$', $description, $emailContent);
        }
        return  $emailContent;
    }

    public function dueData($emailContent, $invoice)
    {
       $due = $invoice->dues()->where('due_state', 'due' )->orderBy('due_date', 'asc')->first();
        if (optional($due)->exists())
       {
            $emailContent = str_replace( '$due-amount$', $due->amount, $emailContent);
            $emailContent = str_replace( '$due-due_date$', $due->due_date, $emailContent);
            $emailContent = str_replace( '$due-due_period$', $due->due_period, $emailContent);

       }

       return $emailContent;
    }

    public function sendMail($closureData, $data, $pdfData) {
        $emailTemplate = 'emails.test';
        Mailsend::queue($closureData['emailTemplate'], $data, function($message) use($closureData, $pdfData) {
            $message->to($closureData['to'], 'ravisangar')->subject($closureData['subject']);
            $message->from($closureData['fromMail'], 'kandiah');
            // $message->attachData($closureData['file1'], $closureData['name1']);
            // $message->cc($closureData['cc']);
            // $message->bcc($closureData['bcc']);
        });
    }

}
