<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Redirect;
use Response;
use Input;
use File;
use App\Models\Mail as Mailsend;
use App\Models\Payment;
use App\Models\Config;
use Illuminate\Support\Facades\Auth;
use App\Models\DebtorInvoice;
use App\Models\Due;
use App\Http\Requests\Due\CreateRequest;
use App\Http\Requests\Due\EditRequest;
use Illuminate\Support\Facades\Session;

class DueController extends Controller {

    protected $request;
    protected $payment;
    protected $config;
    protected $debtorInvoice;
    protected $due;

    public function __construct(Request $request, Payment $payment, Config $config, DebtorInvoice $debtorInvoice, Due $due) {

        $this->request = $request;
        $this->payment = $payment;
        $this->config = $config;
        $this->debtorInvoice = $debtorInvoice;
        $this->due = $due;
        //$this->middleware('auth');
    }

    public function index($model = '', $invoiceId = '') {

        $path = explode('/', $this->request->path());
        $paginationSize = Config::find(1)->value;
        $due = $this->due;
        $client = $model;






        // $dues = $due->orderBy('id', 'DESC')->paginate($paginationSize);
        $dues = $due->where('debtor_invoice_id', $invoiceId)->orderBy('id', 'DESC')->get();


        $invoice = $this->debtorInvoice->find($invoiceId);



        return view('clients.invoices.debtor.dues.index', compact('dues', 'invoice', 'client'));
    }

    public function create($client, $invoiceId) {
        $invoice = $this->debtorInvoice->find($invoiceId);
//        echo '<pre>';var_dump($client);exit;
        return view('clients.invoices.debtor.payments.create', compact('invoice', 'client'));
    }

    public function store(CreateRequest $request, $client = '', $invoiceId = '') {
//dd(1);
        $all = $request->all();

        $invoice = $this->debtorInvoice->find($invoiceId);

        if ($request->dueSaveType == 'dueCreate') {

            foreach ($all as $key => $value) {


                if (strpos($key, 'due_date_') !== false) {
                    $keyId = str_replace('due_date_', '', $key);
                    if ($all['due_date_' . $keyId] != "" && $all['amount_' . $keyId] != "") {
                        $due = new Due();
                        $due->client_id = $invoice->client_id;
                        $due->debtor_id = $invoice->debtor_id;
                        $due->debtor_invoice_id = $invoice->id;
                        $dueDate = \Carbon\Carbon::createFromFormat('d/m/Y', $all['due_date_' . $keyId])->format('Y-m-d');
                        $due->due_date = $dueDate;
                        $due->amount = $all['amount_' . $keyId];
                        $due->balance = $all['amount_' . $keyId];
                        $due->due_period = $all['due_period'];


                        $due->save();
                    }
                }
            }
        }


        if ($request->dueSaveType == 'duePayment') {
            $payment = $this->payment;






            $payment->payment_type = $request->payment_type;

            $payment->payment_date = $request->payment_date;

            $payment->amount = $request->amount;
            $payment->paid_place = $request->paid_place;
            $invoice = $this->debtorInvoice->find($invoiceId);
            $payment->client_id = $invoice->client_id;
            $payment->debtor_id = $invoice->debtor_id;

            $invoice->last_payment = $request->amount;
            $invoice->current_balance = (float) $invoice->current_balance - (float) $request->amount;
            $invoice->total_paid = (float) $invoice->total_paid + (float) $request->amount;
            $payment->due_id = $request->due_id;
            $due = $this->due->find($request->due_id);
            if ($due->balance == $request->amount) {
                $due->due_state = 'paid';
            } else {
                 $due->due_state=number_format((($due->amount+$request->amount) - $due->balance)/$due->amount * 100, 2).' %';
            }
            $due->balance = (float) $due->balance - (float) $request->amount;

            $due->save();
            if(! $invoice->charge_type)
            {
            $payment->commission = number_format($request->amount / 100 * $invoice->client->commission, 2);
            }
            $payment->debtor_invoice_id = $invoice->id;
            $invoice->save();
            $payment->save();
        }

        if ($request->dueSaveType == 'invoicePayment') {
            $payment = $this->payment;






            $payment->payment_type = $request->payment_type;

            $payment->payment_date = $request->payment_date;

            $payment->amount = $request->amount;
            $payment->paid_place = $request->paid_place;
            $invoice = $this->debtorInvoice->find($invoiceId);
            $payment->client_id = $invoice->client_id;
            $payment->debtor_id = $invoice->debtor_id;

            $invoice->last_payment = $request->amount;
            $invoice->current_balance = (float) $invoice->current_balance - (float) $request->amount;
            $invoice->total_paid = (float) $invoice->total_paid + (float) $request->amount;
            if(! $invoice->charge_type)
            {
            $payment->commission = number_format($request->amount / 100 * $invoice->client->commission, 2);
            }
            $payment->debtor_invoice_id = $invoice->id;
            $invoice->save();
            $payment->save();
        }

        return redirect()->route('client.debtor.invoice.due', [$invoice->client_id, $invoice->id]);
    }

    public function show($id) {

        return view('payments.show', compact('payment'));
    }

    public function detail($payment) {

        return view('payments.show', compact('payment'));
    }

    public function invoice($payment) {

        return view('payments.invoice', compact('payment'));
    }

    public function payment($payment) {


//         $payment = $this->payment;


        $payments = $payment->payments()->paginate(2);
        return view('payments.payment', compact('payment', 'payments'));
    }

    public function edit($client, $invoiceId, $id = '') {
        $path = explode('/', $this->request->path());
        if ($path[0] == 'payment') {
            $payment = $this->model($invoiceId);
            $invoice = $payment->debtorInvoice;
            return view('payments.edit', compact('payment', 'invoice'));
        }
        $payment = $this->model($id);
        $invoice = $payment->debtorInvoice;
        return view('clients.invoices.debtor.payments.edit', compact('payment', 'invoice', 'client'));
    }

    public function update(EditRequest $request, $client = '', $invoiceId = '', $id = '') {
        $path = explode('/', $this->request->path());

        if ($path[0] == 'payment') {
            $id = $invoiceId;
        }
        $payment = $this->model($id);

        $payment->payment_state = $request->payment_state;
        if ($path[0] == 'payment') {
            $invoiceId = $request->debtor_invoice_id;
            $payment->payment_state = 'pay';
        }
        $payment->payment_state = $request->payment_state;
        if ($request->payment_state == 'due') {
            $payment->payment_date = $request->payment_date;
        }
        if ($request->payment_state == 'pay') {
            $payment->payment_type = $request->payment_type;

            $payment->payment_date = $request->payment_date;
            if ($request->payment_type == 'cheque') {
                $payment->bank = $request->bank;
                $payment->branch = $request->branch;
                $payment->drawer = $request->drawer;

                $payment->cheque_no = $request->cheque_no;
                $payment->paid_date = $request->paid_date;
            }
        }

        $payment->paid_place = $request->paid_place;
        $invoice = $this->debtorInvoice->find($invoiceId);
        $payment->client_id = $invoice->client_id;
        $payment->debtor_id = $invoice->debtor_id;
        if ($payment->payment_state == 'pay') {
//            echo $invoice->current_balance;exit;
            $invoice->last_payment = $request->amount;
            $invoice->current_balance = ((float) $invoice->current_balance + (float) $payment->amount) - (float) $request->amount;
            $invoice->total_paid = ((float) $invoice->total_paid + (float) $request->amount) - (float) $payment->amount;
        }
        $payment->amount = $request->amount;
        $payment->commission = number_format($request->amount / 100 * $invoice->client->commission, 2);
        $payment->debtor_invoice_id = $invoice->id;
        $invoice->save();
        $payment->save();
        if ($path[0] == 'payment') {
            return redirect()->route('payment.index');
        }
        return redirect()->route('client.debtor.invoice.payment', [$invoice->client_id, $invoice->id]);
    }

    public function model($id) {

        return $this->payment->find($id);
    }

    public function delete($payment) {
        $id = $payment->id;



        return view('payments.delete', compact('payment'));
    }

    public function send($client, $invoiceId, $id) {

        $payment = $this->model($id);
        $invoice = $payment->debtorInvoice;
        if ($invoice->solicitor_id) {
            $closureData['fromMail'] = $user_id = Auth::user()->email;
            $closureData['subject'] = 'test';
            $data['content'] = '';
            $closureData['to'] = $invoice->solicitor->email;
            Mailsend::queue('emails.test', $data, function($message) use($closureData) {
                $message->to($closureData['to'])->subject($closureData['subject']);
                $message->from($closureData['fromMail']);
            });
        } else {

            Session::put('error', 'Please add the  solicitor');
        }

        return redirect()->route('client.debtor.invoice.payment', [$invoice->client_id, $invoice->id]);
    }

    public function destroy($payment) {

        $id = $payment->id;


        $payment->delete();

        return redirect()->route('payment.index');
    }

}
