<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Models\EmailTemplate;
use Illuminate\Http\Request;
use Redirect;
use Response;
use Input;
use File;
use Illuminate\Support\Facades\DB;
use App\Http\Requests\EmailTemplate\CreateRequest;
use App\Http\Requests\EmailTemplate\EditRequest;
//use App\Http\Controllers\Config;

class EmailTemplateController extends Controller {

    protected $request;
    protected $emailTemplate;

    public function __construct(Request $request, EmailTemplate $emailTemplate) {

        $this->request = $request;
        $this->emailTemplate = $emailTemplate;
    }

    public function index() {

        $emailTemplate = $this->emailTemplate;
        $emailTemplates = $emailTemplate->paginate(20);
        if ($this->request->has('search')) {




                return redirect()->route('client.index', ['search' => $this->request->search]);


            $search = $this->request->search;
        }
        return view('emailTemplates.index', compact('emailTemplates'));
    }

    public function create() {
        return view('emailTemplates.create');
    }

    public function store(CreateRequest $request) {

        $emailTemplate = $this->emailTemplate;

        $emailTemplate->name = $request->name;
        $emailTemplate->deleted = 0;
        $emailTemplate->content = $request->content;
        $emailTemplate->subject = $request->subject;


        $emailTemplate->save();

        return redirect()->route('emailTemplate.index');
    }

    public function show($id) {

        return view('emailTemplates.show', compact('emailTemplate'));
    }

    public function edit($emailTemplate) {

        return view('emailTemplates.edit', compact('emailTemplate'));
    }

    public function update(EditRequest $request, $emailTemplate) {


        $emailTemplate->name = $request->name;
        $emailTemplate->deleted = $request->deleted;
        $emailTemplate->content = $request->content;
        $emailTemplate->subject = $request->subject;

        $emailTemplate->save();
        return redirect()->route('emailTemplate.index');
    }

    public function model($id) {

        return $this->emailTemplate->find($id);
    }

    public function delete($emailTemplate) {
        $id = $emailTemplate->id;



        return view('emailTemplates.delete', compact('emailTemplate'));
    }

    public function destroy($emailTemplate) {

        $id = $emailTemplate->id;


        $emailTemplate->delete();

        return redirect()->route('emailTemplate.index');
    }

}
