<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Models\Field;
use App\Models\Operator;
use Illuminate\Http\Request;
use Redirect;
use Response;
use Input;
use File;

class FieldController extends Controller {

    protected $request;
    protected $field;
    protected $operator;

    public function __construct(Request $request, Field $field , Operator $operator) {

        $this->request = $request;
        $this->field = $field;
        $this->operator=$operator;

        //$this->middleware('auth');
    }

    public function index() {

        $field = $this->field;

        //   $pagination = field('setting.pagination');;

        if ($this->request->ajax()) {

            if ($this->request->has('action')) {
                if($this->request->action=='condition')
                {
               $fieldType= $field->find($this->request->actionValue)->field_type;

              return  Response::json($this->operator->where('name', 'LIKE', '%' . $this->request->term . '%')->where('type', $fieldType)->get());
                }
                if($this->request->action=='conditionValue')
                {

                     return  Response::json($this->operator->find($this->request->actionValue));
                }
                if($this->request->action=='field')
                {

               return  Response::json($field->where('model_id',$this->request->model_id )->get());

                }
                 if($this->request->action=='selectAuto') {

               return  Response::json($field->where('db_name', '=', $this->request->dbName )->where('model_id', $this->request->modelId)->get());

                }
            }


            return Response::json($field->where('name', 'LIKE', '%' . $this->request->term . '%')->where('model_id', '=', $this->request->modelId)->get());
        }

        $fields = $field->paginate(20);

        return view('fields.index', compact('fields'));
    }

}
