<?php

namespace App\Http\Controllers;

use App\Models\Client;
use App\Models\Debtor;
use App\Models\DebtorInvoice;
use App\Models\Field;
use App\Models\Import;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Symfony\Component\Console\Input\Input;

class FileController extends Controller
{

    protected $request;
    protected $db;
    protected $client;
    protected $field;
    protected $debtor;
    protected $debtorFields = array();

    public function __construct(Request $request, DB $db, Client $client, Field $field, Debtor $debtor) {

        $this->request = $request;
        $this->db = $db;
        $this->client = $client;
        $this->field = $field;
        $this->debtor= $debtor;


        //$this->middleware('auth');
    }

    public function import($clientId = false) {
        // file('photo')->getClientOriginalName();
        //dd(Module::get()[0]['name']);

        $allInput = $this->request->all();
        // dd($this->request->file('file')->getClientOriginalName());

        if ($this->request->file_import_type == 'upload') {


            if ($this->request->model_name == 'client') {


                if(is_file($this->request->file('file')) && count($this->importCsvArray()) > 1 
                    && !is_null($this->importCsvArray()[1][0])){ // Modified by ranesh@radus28.com

                    $clientCode = $this->client->find($clientId)->client_code;

                    $clientFileId = $this->client->where('client_code', $this->importCsvArray()[1][0])->first()->id;

                    if($clientCode != $this->importCsvArray()[1][0]){

                        $this->request->session()->flash('error', "the client is not correct.

                            <a href=".route('client.import', [$clientFileId])."> plese click here</a>");

                        return redirect()->route('client.import', [$clientId]);
                    }


                } else{

                    $this->request->session()->flash('error', "please check the file"); // Modified by ranesh@radus28.com

                    return redirect()->route('client.import', [$clientId]);
                }


                $datas['import_type'] = 'mapping';
                $datas['datas'] = $this->importCsvArray();
                $datas['clientId'] = $clientId;
                $this->request->session()->put('importrArray', $datas['datas']);
                $fields = $this->field->where('model_id', '6')->get();

                $datas['fieldsCheck'] = $fields;
                $fields= $this->clientFields();
                $datas['fieldsCheck'] = $fields;
                $fields = $this->clientfiledArray($fields);
                $datas['fields'] = $fields;
                return view('clients.import', compact('datas'));
            }
            if ($this->request->model_name == 'debtor') {


                $datas['import_type'] = 'mapping';
                $datas['datas'] = $this->importCsvArray();
                //dd($datas['datas']);
                $this->request->session()->put('importrArray', $datas['datas']);
                $fields = $this->field->where('model_id', '15')->get();
                $datas['fields'] = $fields;
                return view('debtors.import', compact('datas'));
            }
        } else {
            //dd($this->request);
            $importrArray = $this->request->session()->get('importrArray', []);
            //$this->request->session()->forget('debtorArray');
            $recode = $this->addData($clientId);

            return redirect()->route('client.import', [$clientId]);
        }



        // dd($this->request->file('file'));
    }

    public function addData($clientId) {
        $importrArray = $this->request->session()->get('importrArray', []);

        $allInput = $this->request->all();

        $fileNameId = $this->importFile($clientId);
        // dd($allInput);
        // dd($importrArray);
        //  $keyId=array();
        $recode = array();
        end($importrArray);
        $last_id = key($importrArray);
        foreach ($importrArray as $arrayKey => $imporArrayValue) {
            $addDebtorArray = array();
            $addDebtorInvoiceArray = array();
            if ($arrayKey !== 0) {
                if ($arrayKey !== $last_id) {
                    // dd($arrayKey);
                    $skip = false;
                    foreach ($allInput as $key => $value) {
                        if (strpos($key, 'array_id_') !== false) {
                            if ($value !== "") {
                                $keyId = str_replace('array_id_', '', $key);
                                if ($imporArrayValue[$keyId] !== "") {

                                    if(array_key_exists($value ,$this->debtorField())){

                                        $addDebtorArray[$value] = $imporArrayValue[$keyId];

                                    }

                                    if(array_key_exists($value ,$this->debtorIinvoiceField())){



                                        if ($value == "invoice_status_code_id") {
                                            $addDebtorInvoiceArray[$value] = 16;
                                        } else if($value == "debt_type_id"){
                                            $addDebtorInvoiceArray[$value] = 43;

                                        } else if($value == "original_debt"){

                                            $addDebtorInvoiceArray['current_balance'] = str_replace('$', '',
                                                $imporArrayValue[$keyId]);
                                            $addDebtorInvoiceArray[$value] =  str_replace('$', '',
                                                $imporArrayValue[$keyId]);
                                        } else{
                                            $addDebtorInvoiceArray[$value] = $imporArrayValue[$keyId];
                                        }


                                    }


                                }
                            }
                        }
                    }


                    $this->debtorAndInvoiceCreate($addDebtorArray, $addDebtorInvoiceArray, $clientId, $fileNameId);

                }
                //dd($keyId);
            }
        }

        return 1;
    }

    public function importCsvArray() {
        $csvData = file_get_contents($this->request->file('file'));

        $this->request->session()->put('importFileName', $this->request->file('file')->getClientOriginalName());
        $lines = explode(PHP_EOL, $csvData);
        $array = array();
        $firstRow = array();
        foreach ($lines as $key => $line) {
            // if($key == 0){
            //     $firstRow = $line;
            // }

            $array[] = str_getcsv($line);

            //  $array[] = $this->indexChangeSet(str_getcsv($line), $firstRow);


        }

        return $array;
    }

    public function postUpload() {
        if (Input::hasFile('file')) {

            $file = Input::file('file');
            $name = time() . '-' . $file->getClientOriginalName();

            //check out the edit content on bottom of my answer for details on $storage
            $storage = '/some/world/readible/dir';
            $path = $storage . '/uploads/CSV';

            // Moves file to folder on server
            $file->move($path, $name);

            // Import the moved file to DB and return OK if there were rows affected
            return ( $this->_import_csv($path, $name) ? 'OK' : 'No rows affected' );
        }
    }



    private function clientFields(){

        return [
            'last_name' => 'Surname',
            'first_name' => 'GivenNames',
            'mailing_address' => 'Address',
            'contact_number' => 'MobilePhone',
            'mailing_suburb' => 'Suburb',
            'mailing_state' => 'State',
            'email' => 'Email',
            'mailing_postcode' => 'Postcode',
            'invoice_code' => 'Invoice Code',
            'reference1' => 'Reference 1',
            'reference2' => 'Reference 2',
            'reference3' => 'Reference 3',
            'reference4' => 'Reference 4',
            'invoice_status_code_id' => 'Invoice Status Code',
            'debt_type_id' => 'Debt Type',
            'original_debt' => 'Debt',
        ];

    }

    private function debtorField(){

        return [
            'last_name' => 'last_name',
            'first_name' => 'first_name',
            'mailing_address' => 'mailing_address',
            'contact_number' => 'contact_number',
            'mailing_suburb' => 'mailing_suburb',
            'mailing_state' => 'mailing_state',
            'email' => 'email',
            'mailing_postcode' => 'mailing_postcode',

        ];

    }

    private function debtorIinvoiceField(){

        return [
            'invoice_code' => 'invoice_code',
            'reference1' => 'reference1',
            'reference2' => 'reference2',
            'reference3' => 'reference3',
            'reference4' => 'reference4',
            'invoice_status_code_id' => 'invoice_status_code_id',
            'debt_type_id' => 'debt_type_id',
            'original_debt' => ' original_debt',
        ];

    }

    private function clientfiledArray($fields){

        $setFields = [];
        foreach ($fields as $key => $field) {

            $setFields[] = [
                'id' => $key,
                'text' => $field
            ];
        }

        return $setFields;
    }

    private function debtorAndInvoiceCreate($addDebtorArray, $addDebtorInvoiceArray, $clientId, $fileNameId){

        if(empty($addDebtorArray['first_name'])){

            return true;
        }


        $addDebtorArray['debtor_code'] = $this->debtorCode($addDebtorArray);
        $addDebtorArray['name'] = $this->name($addDebtorArray);
        // echo '<pre>';


        $debtor = Debtor::create($addDebtorArray);

        $addDebtorInvoiceArray['client_id'] = $clientId;
        $addDebtorInvoiceArray['debtor_id'] = $debtor->id;
        $addDebtorInvoiceArray['import_id'] = $fileNameId;
        $addDebtorInvoiceArray['import_type'] = 'import';

        $debtorInvoice = debtorInvoice::create($addDebtorInvoiceArray);


    }

    private function debtorCode($data){
        $lastName = $data['last_name'];


        $firstName = $data['first_name'];
        $debtorCode = '';
        $lenString = strlen($lastName);
        if ($lenString > 5) {
            $debtorCode = substr($lastName, 0, 5);
        } else {
            $debtorCode = substr($lastName, 0, $lenString);
        }

        $lenString = strlen($firstName);
        if ($lenString > 2) {
            $debtorCode = $debtorCode . substr($firstName, 0, 2);
        } else {
            $debtorCode = $debtorCode . substr($firstName, 0, $lenString);
        }

        return $debtorCode;
    }

    private function name($data){
        return $data['last_name'] . ' ' . $data['first_name'];
    }

    private function importFile($clientId){

        $importFileName = $this->request->session()->get('importFileName', '');

        $import = new Import();
        $import->file_name = $importFileName;
        $import->client_id = $clientId;
        $import->user_id = Auth::user()->id;
        $import->save();

        return $import->id;


    }

    public function index(){

        $imports = Import::orderBy('id', 'DESC')->paginate(20);

        return view('imports.index', compact('imports'));
    }

    public function debtorInvoice($id){

        $debtors = Import::find($id)->debtorInvoices;

        return view('imports.show', compact('debtors'));
    }

}
