<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Redirect;
use Response;
use Input;
use File;
use App\Models\Report;
use App\Models\Client;
use App\Models\Debtor;
use App\Models\Condition;
use App\Models\FixedReport;
use App\Models\ClientAccount;
use App\Models\Payment;
use App\Models\Due;
use App\Models\InvoiceFollow;
use App\Models\ClientTransaction;
use App\Models\InvoiceStatusCode;
use App\Models\OpeningBalance;
use App\Models\ClientPayment;
use App\Http\Requests\Report\CreateRequest;
use App\Http\Requests\Report\EditRequest;
use Maatwebsite\Excel\Facades\Excel;
use Barryvdh\DomPDF\Facade\Pdf;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\FromArray;

class FixedReportController extends Controller {

    protected $request;
    protected $report;
    protected $condition;
    protected $client;
    protected $debtor;
    protected $modelOb = array();
    protected $fixedReport;
    protected $monthArray;
    protected $clientAccount;
    protected $due;
    protected $payment;
    protected $invoiceFollow;
    protected $clientTransaction;
    protected $from;
    protected $to;
    protected $openingBalance;
    protected $invoiceStatusCode;
    protected $clientPayment;

    public function __construct(Request $request, Report $report, Client $client, Debtor $debtor, Condition $condition, FixedReport $fixedReport, ClientAccount $clientAccount, Due $due, Payment $payment, InvoiceFollow $invoiceFollow, ClientTransaction $clientTransaction, OpeningBalance $openingBalance, InvoiceStatusCode $invoiceStatusCode, ClientPayment $clientPayment) {

        $this->request = $request;
        $this->report = $report;
        $this->condition = $condition;
        $this->client = $client;
        $this->debtor = $client;
        $this->modelOb['Client'] = $client;
        $this->modelOb['Debtor'] = $debtor;
        $this->fixedReport = $fixedReport;
        $this->clientAccount = $clientAccount;
        $this->due = $due;
        $this->payment = $payment;
        $this->invoiceFollow = $invoiceFollow;
        $this->clientTransaction = $clientTransaction;
        $this->openingBalance = $openingBalance;
        $this->invoiceStatusCode = $invoiceStatusCode;
        $this->clientPayment = $clientPayment;

        $this->monthArray = array();
        $this->monthArray[0] = 'not';
        $this->monthArray["01"] = 'January';
        $this->monthArray["02"] = 'February';
        $this->monthArray["03"] = 'March';
        $this->monthArray["04"] = 'April';
        $this->monthArray["05"] = 'May';
        $this->monthArray["06"] = 'June';
        $this->monthArray["07"] = 'July';
        $this->monthArray["08"] = 'August';
        $this->monthArray["09"] = 'September';
        $this->monthArray[10] = 'October';
        $this->monthArray[11] = 'November';
        $this->monthArray[12] = 'December';







        //$this->middleware('auth');
    }

    public function index() {

        $report = $this->fixedReport;

        //   $pagination = report('setting.pagination');;

        if ($this->request->ajax()) {


            return Response::json($report->get());
        }

        $reports = $report->paginate(20);

        if ($this->request->has('search')) {




            return redirect()->route('client.index', ['search' => $this->request->search]);


            $search = $this->request->search;
        }

        return view('reports.fixed.index', compact('reports'));
    }

    public function store() {
        dd(1);
    }

    public function show($id) {
        $report = $this->fixedReport->find($id);

        set_time_limit(5000);
        // ini_set('memory_limit', '-1');
        ini_set('memory_limit', '2048M');


        if (($this->request->has('to')) || ($this->request->has('from'))) {

            $from = $this->request->from;
            $to = $this->request->to;
            // dd($from.$to);
            $dues = $this->due;
            if ($from != '') {

                $this->from = \Carbon\Carbon::createFromFormat('d/m/Y', $from = $this->request->from)->format('Y-m-d');
            }
            if ($to != '') {
                $this->to = \Carbon\Carbon::createFromFormat('d/m/Y', $from = $this->request->to)->format('Y-m-d');
            }

            $dues = $dues->get();
        }


        $modelName = $this->client;

        $view = 'reports.fixed.show';

        if ($id == 1) {
            // $fields=$this->field1();
            $datas = $this->data1();
        }
        if ($id == 2) {
            // $fields=$this->field1();
            $datas = $this->data2();
            $view = 'reports.fixed.show2';
        }

        if ($id == 3) {
            // $fields=$this->field1();
            $client = $this->client->first();
            if ($this->request->has('clientId')) {
                $client = $this->client->find($this->request->clientId);
            }


            $datas = $this->report3($client);
            $view = 'reports.fixed.show3';
        }

        if ($id == 8) {
            // $fields=$this->field1();
            $client = $this->client->first();
            if ($this->request->has('clientId')) {
                $client = $this->client->find($this->request->clientId);
            }


            $datas = $this->report8($client);
            //  dd(1);
            $view = 'reports.fixed.show8';
        }
        if ($id == 11) {
            // $fields=$this->field1();
            $client = $this->client->first();
            if ($this->request->has('clientId')) {
                $client = $this->client->find($this->request->clientId);
            }


            $datas = $this->report11($client);
            //  dd(1);
            $view = 'reports.fixed.show11';
        }
        if ($id == 12) {
            // $fields=$this->field1();
            $client = $this->client->first();
            if ($this->request->has('clientId')) {
                $client = $this->client->find($this->request->clientId);
            }


            $datas = $this->report12($client);
            //  dd(1);
            $view = 'reports.fixed.show11';
        }

        if ($id == 9) {
            // $fields=$this->field1();
            $client = $this->client->first();
            if ($this->request->has('clientId')) {
                $client = $this->client->find($this->request->clientId);
            }


            $datas = $this->report9();
            //  dd(1);
            $view = 'reports.fixed.show9';
        }




        if ($id == 10) {
            // $fields=$this->field1();



            $datas = $this->report10();
            //  dd(1);
            $view = 'reports.fixed.show10';
        }


         if ($id == 13) {
            // $fields=$this->field1();



            $datas = $this->report13();
            //  dd(1);
            $view = 'reports.fixed.show13';
        }

         if ($id == 14) {
            // $fields=$this->field1();



            $datas = $this->report14();
            //  dd(1);
            $view = 'reports.fixed.show14';
        }


        if ($id == 4) {


            // $fields=$this->field1();
            $client = $this->client->first();
            if ($this->request->has('clientId')) {
                $client = $this->client->find($this->request->clientId);
            }


            $datas = $this->report4();
            $view = 'reports.fixed.show4';
        }

        if ($id == 5) {


            // $fields=$this->field1();
            $client = $this->client->first();

            if ($this->request->has('clientId')) {
                $client = $this->client->find($this->request->clientId);
            }


            $datas = $this->report5();
            $view = 'reports.fixed.show5';
        }


        if ($id == 6) {


            // $fields=$this->field1();
            $client = $this->client->first();

            if ($this->request->has('clientId')) {
                $client = $this->client->find($this->request->clientId);
            }


            $datas = $this->report6();
            $view = 'reports.fixed.show6';
        }
        if ($id == 7) {


            // $fields=$this->field1();
            $client = $this->client->first();

            if ($this->request->has('clientId')) {
                $client = $this->client->find($this->request->clientId);
            }


            $datas = $this->report7();

            $view = 'reports.fixed.show7';
        }



        if ($this->request->type == 'export') {


            if ($id == 1) {
                // $fields=$this->field1();
                $fileArray = $this->data11();
                //  dd($fileArray);
            }
            if ($id == 2) {
                // $fields=$this->field1();
                $fileArray = $this->data22();
                $view = 'reports.fixed.show2';
            }
            if ($id == 7) {
                // $fields=$this->field1();
                $fileArray = $this->report7();
                $view = 'reports.fixed.show2';
            }
            if ($id == 8) {
                // $fields=$this->field1();
                $fileArray = $datas;
                $view = 'reports.fixed.show8';
            }
            if ($id == 11) {
                // $fields=$this->field1();
                $fileArray = $datas;
                $view = 'reports.fixed.show11';
            }
            if ($id == 12) {
                // $fields=$this->field1();
                $fileArray = $datas;
                $view = 'reports.fixed.show11';
            }

//            if ($this->request->action == 'excel5') {
//                Excel::create('Filename', function($excel) use($fileArray) {
//
//                    $excel->sheet('Sheetname', function($sheet) use($fileArray) {
//
//                        $sheet->fromArray($fileArray);
//                    });
//                })->export('xls');
//        }
//            if ($this->request->action == 'excel5') {
//                Excel::download('Filename.xlsx', function($excel) use($fileArray) {
//                    $excel->sheet('Sheetname', function($sheet) use($fileArray) {
//                        $sheet->fromArray($fileArray);
//                    });
//                });
//
//            }
            if ($this->request->action == 'excel5') {

                return Excel::download(function($excel) use($fileArray) {
                    $excel->sheet('Sheetname', function($sheet) use($fileArray) {
                        $sheet->fromArray($fileArray);
                    });
                }, 'Client-credit.xls')->format('xls');
            }
            if ($this->request->action == 'excel2007') {
                Excel::create('Filename', function($excel) use($fileArray) {

                    $excel->sheet('Sheetname', function($sheet) use($fileArray) {

                        $sheet->fromArray($fileArray);
                    });
                })->export('xls');
            }

            if ($this->request->action == 'csv') {
                Excel::create('Filename', function($excel) use($fileArray) {

                    $excel->sheet('Sheetname', function($sheet) use($fileArray) {

                        $sheet->fromArray($fileArray);
                    });
                })->export('csv');
            }

            if ($this->request->action == 'pdf') {
                if ($id == 3) {
                    $client = $this->client->first();
                    if ($this->request->has('clientId')) {
                        $client = $this->client->find($this->request->clientId);
                    }
//                    $data['datas'] = $datas;
//                    $data['client'] = $client;

                    $month = date("m");
                    //dd($month);
                    $year = date("Y");
                    $value = $month . '/' . $year;
                    // dd($this->monthArray[$month]);
                    if ($this->request->has('filter')) {
                        $value = $this->request->value;
                        $valueArray = explode('/', $value);

                        $month = $valueArray[0];
                        $year = $valueArray[1];
                        $valueString = $this->monthArray[$month] . '/' . $year;
                    }



                    $data = $datas;
                    /**      $ll =array();
                      $datas = array();
                      if(count($data) > 1)
                      {
                      $t= 0;
                      for($i=0; $i < count($data); $i=$i+10)
                      {


                      for($j=0; $j < 10 ; $j++)
                      {
                      if( (count($data) > $t))
                      {
                      $datas[$t] =$data[$t];
                      }

                      $t= $t+1;
                      }
                      $filePath ='fileFolder/pdf/debtorStatement';

                      //  dd($datas);
                      // chmod($filePath . '/' . $fileName, 0777);
                      $view = view('reports.pdf.debtStatement', compact('datas', 'value'));
                      //dd($view);
                      $html = $view->render();
                      // dd($html);
                      // return 1;
                      $pdf = \App::make('dompdf.wrapper');
                      $pdf->loadHTML($html)->save('fileFolder/pdf/debtorStatement/'.$i.'.pdf');

                      }

                      }

                      dd(count($ll));
                     *
                     */
                    $datas = array();
                    $datas = $data;

                    $view = view('reports.pdf.debtStatement', compact('datas', 'value'));
                    //dd($view);
                    $html = $view->render();
                    // dd($html);
                    // return 1;
                    $pdf = \App::make('dompdf.wrapper');
                    $pdf->loadHTML($html);

                    // return $pdf->download('report.pdf');
                    return $pdf->stream('Endofmonthstatement_' . $this->monthArray[$month] . '_' . $year . '.pdf');

                    $pdf = \PDF::loadView('reports.pdf.debtStatement', $data);
                    //  return $pdf->stream('End of month statement.pdf');
                    return $pdf->download('Endofmonthstatement_12.pdf');
                } elseif ($id == 4) {
                    $data['datas'] = $datas;


                    $pdf = \PDF::loadView('reports.pdf.monthReport', $data);

                    $month = date("m");
                    //dd($month);
                    $year = date("Y");
                    return $pdf->stream('MonthlyCommissionStatement_'. $this->monthArray[$month] . '_' . $year . '.pdf');
                } elseif ($id == 5) {
                    $data['datas'] = $datas;


                    $pdf = \PDF::loadView('reports.pdf.paymentArrangement', $data);
                    return $pdf->stream();
                } elseif ($id == 6) {
                    $data['datas'] = $datas;


                    $pdf = \PDF::loadView('reports.pdf.creditCardPayment', $data);
                    return $pdf->stream();
                } elseif ($id == 7) {
                    $data['datas'] = $datas;


                    $pdf = \PDF::loadView('reports.pdf.actionReport', $data);
                    return $pdf->stream();
                } elseif ($id == 9) {
                    $data['datas'] = $datas;


                    $pdf = \PDF::loadView('reports.pdf.bankPaymentPdf', $data);
                    return $pdf->stream();
                } elseif ($id == 11) {
                    $data['datas'] = $datas;


                    $pdf = \PDF::loadView('reports.pdf.debtorOfClient', $data);
                    return $pdf->stream();
                } elseif ($id == 1) {
                    $data['datas'] = $datas;



                    $pdf = \PDF::loadView('reports.pdf.clientCreditLedgerReport', $data);
                    // return $pdf->download('report.pdf');
                     $month = date("m");
                    //dd($month);
                    $year = date("Y");
                    return $pdf->stream('ClientdebitLedger_'. $this->monthArray[$month] . '_' . $year . '.pdf');

                } elseif ($id == 2) {
                    $data['datas'] = $datas;
                    // dd($datas);

                    $pdf = \PDF::loadView('reports.pdf.clientDebitLedgerReport', $data);

                     $month = date("m");
                    //dd($month);
                    $year = date("Y");
                    return $pdf->stream('ClientCreditLedger_'. $this->monthArray[$month] . '_' . $year . '.pdf');
                } else {

                    Excel::create('Filename', function($excel) use($fileArray) {

                        $excel->sheet('Sheetname', function($sheet) use($fileArray) {
                            $sheet->freezeFirstRow();

                            $sheet->fromArray($fileArray, null, 'A1', true);
                        });
                    })->export('pdf');
                }
            }

            exit;
        }
        $month = date("m");
        //dd($month);
        $year = date("Y");
        // dd($this->monthArray[$month]);
        $valueString = $this->monthArray[$month] . '/' . $year;
        $value = $month . '/' . $year;
        $from = '';
        $to = '';

        if (($this->request->has('to')) || ($this->request->has('from'))) {
            $from = $this->request->from;
            $to = $this->request->to;
            $valueString == '';
        } else {
            if ($this->request->has('filter')) {
                $value = $this->request->value;
                $valueArray = explode('/', $value);

                $month = $valueArray[0];
                $year = $valueArray[1];
                $valueString = $this->monthArray[$month] . '/' . $year;
            }
        }


        if ($id == 3) {
            // dd($datas);
            // dd(1);
            $clientArray = array();
            $clientArray['set'] = 'no';
            $client = $this->client->first();
            $clientArray['set'] = 'no';
            $clientArray['code'] = $client->client_code;
            $clientArray['name'] = $client->name;
            $clientArray['id'] = $client->id;
            if ($this->request->has('clientId')) {
                if ($this->request->has('clientId') != "") {
                    $client = $this->client->find($this->request->clientId);
                    $clientArray['set'] = 'yes';
                    $clientArray['code'] = $client->client_code??null;
                    $clientArray['name'] = $client->name??null;
                    $clientArray['id'] = $client->id??null;
                }
            }

            $openingBalancesOb = $this->openingBalance;

            //dd($client);
            return view($view, compact('report', 'datas', 'value', 'client', 'clientArray', 'valueString', 'openingBalancesOb'));
        }

        if ($id == 8) {
            // dd($datas);
            // dd(1);
            $clientArray = array();
            $clientArray['set'] = 'no';
            $client = $this->client->first();
            $clientArray['set'] = 'no';
            $clientArray['code'] = $client->client_code;
            $clientArray['name'] = $client->name;
            $clientArray['id'] = $client->id;
            if ($this->request->has('clientId')) {
                if ($this->request->has('clientId') != "") {
                    $client = $this->client->find($this->request->clientId);
                    $clientArray['set'] = 'yes';
                    $clientArray['code'] = $client->client_code;
                    $clientArray['name'] = $client->name;
                    $clientArray['id'] = $client->id;
                }
            }

            $clientArray['invoiceStateCode'] = '';
            if ($this->request->has('invoiceStateCodeId')) {
                $clientArray['set'] = 'code';
                $invoiceStateCodeId = $this->invoiceStatusCode->find($this->request->invoiceStateCodeId);
                $clientArray['invoiceStateCode'] = $invoiceStateCodeId->code . ' ' . $invoiceStateCodeId->description;
            }
            //dd($client);
            return view($view, compact('report', 'datas', 'value', 'client', 'clientArray', 'valueString'));
        }

        if ($id == 11) {
            // dd($datas);
            // dd(1);
            $clientArray = array();
            $clientArray['set'] = 'no';
            $client = $this->client->first();
            $clientArray['set'] = 'no';
            $clientArray['code'] = $client->client_code;
            $clientArray['name'] = $client->name;
            $clientArray['id'] = $client->id;

            if ($this->request->has('clientId')) {
                if ($this->request->has('clientId') != "") {
                    $client = $this->client->find($this->request->clientId);
                    $clientArray['set'] = 'yes';
                    $clientArray['code'] = $client->client_code;
                    $clientArray['name'] = $client->name;
                    $clientArray['id'] = $client->id;
                }
            }


            $clientArray['invoiceStateCode'] = '';
            if ($this->request->has('invoiceStateCodeId')) {
                $clientArray['set'] = 'code';
                $invoiceStateCodeId = $this->invoiceStatusCode->find($this->request->invoiceStateCodeId);
                $clientArray['invoiceStateCodeId'] = $this->request->invoiceStateCodeId;
                $clientArray['invoiceStateCode'] = $invoiceStateCodeId->code . ' ' . $invoiceStateCodeId->description;
            }

            //dd($client);
            return view($view, compact('report', 'datas', 'value', 'client', 'clientArray', 'valueString'));
        }

        if ($id == 4) {
            $client = $this->client->first();
            if ($this->request->has('clientId')) {
                $client = $this->client->find($this->request->clientId);
            }
            // dd($client);
            $clients = $this->client->get();
            $fields = array(
                ['name' => 'Client code', 'db_name' => 'client_code'],
                ['name' => 'Name', 'db_name' => 'name']
            );
            return view($view, compact('report', 'clients', 'datas', 'fields', 'value', 'valueString', 'client'));
        }
        if ($id == 10) {
            $openingBalance = $this->openingBalance;
            $fields = $this->field1();
            return view($view, compact('report', 'datas', 'fields', 'value', 'valueString', 'to', 'from', 'month', 'year', 'openingBalance'));
        }
        // dd($fields[0]->name);
        $fields = $this->field1();
        return view($view, compact('report', 'datas', 'fields', 'value', 'valueString', 'to', 'from'));
    }

    public function field1() {
        $fields = array();
        $fields[0]['name'] = 'Client code';
        $fields[0]['db_name'] = 'client_code';
        $fields[1]['name'] = 'Name';
        $fields[1]['db_name'] = 'name';
        return $fields;
    }

    public function data1() {
        $modelName = $this->client;
        $clientDatas = $modelName->get();
        // $clientDatas = $modelName->limit(30)->get();
        // dd($clientDatas);
        $datas = array();
        foreach ($clientDatas as $key => $clientData) {
            $month = date("m");

            $year = date("Y");
            //  $clientData = $this->client->find(33);
            if ($this->request->has('filter')) {
                $value = $this->request->value;
                $valueArray = explode('/', $value);

                $month = $valueArray[0];
                $year = $valueArray[1];
            }
            $paymentOb = $clientData->payments()->whereRaw('MONTH(payment_date) = "' . $month . '"')->whereRaw('YEAR(payment_date) = "' . $year . '"')->get();
            // dd(count($paymentOb));
            if (count($paymentOb) > 0) {
                $datas[$key]['name'] = $clientData->name;
                $datas[$key]['client_code'] = $clientData->client_code;
                $datas[$key]['payments'] = array();

                $balance = 0.00;
                $keyPayemntChek = 0;
//            $month = date("m");
//
//            $year = date("Y");
//
//            if ($this->request->has('filter')) {
//                $value = $this->request->value;
//                $valueArray = explode('/', $value);
//
//                $month = $valueArray[0];
//                $year = $valueArray[1];
//            }

                $tt = 0;
                // $paymentOb = $clientData->payments()->whereRaw('MONTH(payment_date) = "' . $month . '"')->whereRaw('YEAR(payment_date) = "' . $year . '"')->get();
                //   $paymentOb = $clientData->payments()->whereRaw('MONTH(payment_date) = "' . $month . '"')->whereRaw('YEAR(payment_date) = "' . $year . '"')->get();

                foreach ($paymentOb as $keyPayemnt => $payment) {

                    $datas[$key]['payments'][$keyPayemnt]['payment_date'] = $payment->payment_date;
                    $datas[$key]['payments'][$keyPayemnt]['type'] = $payment->paid_place;
                    $datas[$key]['payments'][$keyPayemnt]['reference'] = $payment->debtorInvoice->invoice_code;
                    $datas[$key]['payments'][$keyPayemnt]['debtor'] = $payment->debtor->debtor_code;
                    $datas[$key]['payments'][$keyPayemnt]['payment_type'] = $payment->payment_type;
                    $datas[$key]['payments'][$keyPayemnt]['amount'] = $payment->amount;
                    $balance = number_format($balance + $payment->amount, 2);
                    $datas[$key]['payments'][$keyPayemnt]['balance'] = $balance;
                    $keyPayemntChek = $keyPayemnt;
                    $tt = 1;
                }
                if ($tt) {
                    $datas[$key]['payments'][$keyPayemnt + 1]['payment_date'] = "28/" . $month . "/" . $year;

                    $datas[$key]['payments'][$keyPayemnt + 1]['type'] = "Trf Trust";
                    $datas[$key]['payments'][$keyPayemnt + 1]['reference'] = "";
                    $datas[$key]['payments'][$keyPayemnt + 1]['debtor'] = "";
                    $datas[$key]['payments'][$keyPayemnt + 1]['payment_type'] = "";
                    $clientAccountData = $clientData->clientTransactions()->whereRaw('MONTH(paid_date) = "' . $month . '"')->whereRaw('YEAR(paid_date) = "' . $year . '"')->sum('amount');
                    $commition = number_format($balance / 100 * $clientData->commission, 2);
//                    if (count($commition == 0)) {
//                        $commition = number_format($balance / 100 * 20, 2);
//                    }
                    if (is_array($commition) && count($commition) == 0) {
                        $commition = number_format($balance / 100 * 20, 2);
                    }
                    // $balance = number_format($balance - $commition, 2);
                    $datas[$key]['payments'][$keyPayemnt + 1]['amount'] = $commition;

                    $datas[$key]['payments'][$keyPayemnt + 1]['balance'] = number_format($balance - $commition, 2);
                    $invoiceDate = $year . "-" . $month . "-5";



                    $invoiceDate = date("Y-m-t", strtotime($invoiceDate));

                    $invoiceDate = date("d/m/Y", strtotime($invoiceDate));
                    $datas[$key]['payments'][$keyPayemnt + 2]['payment_date'] = $invoiceDate;
                    $datas[$key]['payments'][$keyPayemnt + 2]['type'] = "Paid Trst";
                    $datas[$key]['payments'][$keyPayemnt + 2]['reference'] = "";
                    $datas[$key]['payments'][$keyPayemnt + 2]['debtor'] = "";
                    $datas[$key]['payments'][$keyPayemnt + 2]['payment_type'] = "";


                    $datas[$key]['payments'][$keyPayemnt + 2]['amount'] = $clientAccountData;
                    // $datas[$key]['payments'][$keyPayemnt + 2]['balance'] =  "0.00";
                    $datas[$key]['payments'][$keyPayemnt + 2]['balance'] = number_format($balance - $clientAccountData, 2);
                }
            }
        }

        return $datas;
    }

    public function data2() {
        $modelName = $this->client;
        $clientDatas = $modelName->get();
        $datas = array();
        $key = 0;
        foreach ($clientDatas as $clientData) {

            $keyPayemntChek = 0;
            $month = date("m");

            $year = date("Y");

            if ($this->request->has('filter')) {
                $value = $this->request->value;
                $valueArray = explode('/', $value);

                $month = $valueArray[0];
                $year = $valueArray[1];
            }
            $paymentOb = $clientData->payments()->whereRaw('MONTH(payment_date) = "' . $month . '"')->whereRaw('YEAR(payment_date) = "' . $year . '"')->get();
            if (count($paymentOb)) {
                $datas[$key]['name'] = $clientData->name;
                $datas[$key]['client_code'] = $clientData->client_code;
                $datas[$key]['payments'] = array();

                $balance = 0.00;
                $keyPayemntChek = 0;
                $month = date("m");

                $year = date("Y");

                if ($this->request->has('filter')) {
                    $value = $this->request->value;
                    $valueArray = explode('/', $value);

                    $month = $valueArray[0];
                    $year = $valueArray[1];
                }

                $tt = 0;
                // $paymentOb = $clientData->payments()->whereRaw('MONTH(payment_date) = "' . $month . '"')->whereRaw('YEAR(payment_date) = "' . $year . '"')->get();
                $paymentOb = $clientData->payments()->whereRaw('MONTH(payment_date) = "' . $month . '"')->whereRaw('YEAR(payment_date) = "' . $year . '"')->get();
                $balance = 0;
                foreach ($paymentOb as $keyPayemnt => $payment) {

                    $datas[$key]['payments'][$keyPayemnt]['payment_date'] = $payment->payment_date;
                    $datas[$key]['payments'][$keyPayemnt]['type'] = 'commission';
                    if ($payment->payment_place == 'Paid To CTC') {
                        $commisionString = '% commission on';
                    } else {
                        $commisionString = "% comm'sn (pymt)";
                    }
                    $datas[$key]['payments'][$keyPayemnt]['reference'] = $payment->debtorInvoice->invoice_code;
                    $datas[$key]['payments'][$keyPayemnt]['debtor'] = $payment->debtor->debtor_code;
                    $datas[$key]['payments'][$keyPayemnt]['payment_type'] = str_replace('.00', '', $clientData->commission) . '% commission on';
                    $commission = $payment->commission;
                    $commissionPecentRate = $clientData->commission;
                    if ($commissionPecentRate == 0) {
                        $commissionPecentRate = 20;
                    }
                    if ($commission == '0.00') {
                        $commission = number_format(($payment->amount * $commissionPecentRate / 100) * 1.1, 2);
                    }

                    $datas[$key]['payments'][$keyPayemnt]['amount'] = $commission;

                    $balance = number_format($balance + $commission, 2);
                    $datas[$key]['payments'][$keyPayemnt]['balance'] = $balance;
                    $keyPayemntChek = $keyPayemnt;
                    $tt = 1;
                }
                if ($tt) {
                    $invoiceDate = $year . "-" . $month . "-5";



                    $invoiceDate = date("Y-m-t", strtotime($invoiceDate));

                    $invoiceDate = date("d/m/Y", strtotime($invoiceDate));
                    $datas[$key]['payments'][$keyPayemnt + 1]['payment_date'] = $invoiceDate;

                    $datas[$key]['payments'][$keyPayemnt + 1]['type'] = "Trf Trust";
                    $datas[$key]['payments'][$keyPayemnt + 1]['reference'] = "";
                    $datas[$key]['payments'][$keyPayemnt + 1]['debtor'] = "";
                    $datas[$key]['payments'][$keyPayemnt + 1]['payment_type'] = "";

                    $datas[$key]['payments'][$keyPayemnt + 1]['amount'] = $balance;

                    $datas[$key]['payments'][$keyPayemnt + 1]['balance'] = 0.00;
                }
                $key = $key + 1;
            }
        }
//dd($datas);
        return $datas;
    }

    public function report3($client) {
        $month = date("m");

        $year = date("Y");

        if ($this->request->has('filter')) {
            $value = $this->request->value;
            $valueArray = explode('/', $value);

            $month = $valueArray[0];
            $year = $valueArray[1];
        }
        //dd($client);
        //
        $client_ids = array();
        if ($this->request->has('filter')) {
            if ($this->request->has('clientId') && ($this->request->has('clientId') != "")) {
                $client_ids = array($this->request->clientId);
            } else {
                $client_ids = $this->payment->whereRaw('MONTH(payment_date) = "' . $month . '"')->whereRaw('YEAR(payment_date) = "' . $year . '"')->groupBy('client_id')->pluck("client_id")->toArray();
            }
        } else {
            $client_ids = $this->payment->whereRaw('MONTH(payment_date) = "' . $month . '"')->whereRaw('YEAR(payment_date) = "' . $year . '"')->groupBy('client_id')->pluck("client_id")->toArray();
        }
        // dd($client_ids);
        $datas = array();
        foreach ($client_ids as $key => $client_id) {
            $datas[$key]['client'] = $this->client->find($client_id);
            $datas[$key]['payments'] = $this->payment->where('client_id', $client_id)->whereRaw('MONTH(payment_date) = "' . $month . '"')->whereRaw('YEAR(payment_date) = "' . $year . '"')->get();
            $datas[$key]['clientTransactions'] = $this->clientTransaction->where('client_id', $client_id)->whereRaw('MONTH(paid_date) = "' . $month . '"')->whereRaw('YEAR(paid_date) = "' . $year . '"')->sum("amount");
            $datas[$key]['commissionValidation'] = $this->payment->where('client_id', $client_id)->whereRaw('MONTH(payment_date) = "' . $month . '"')->whereRaw('YEAR(payment_date) = "' . $year . '"')->where('trans_description', "Comm'sion")->where('trans_description', "Comm'sion")->count();
            // $datas[$key]['fdlAmounts'] = array();
        }
        if ($month == 1) {
            $monthBefore = 12;
            $yearBefore = $year - 1;
        } else {
            $monthBefore = $month - 1;
            $yearBefore = $year;
        }
        // dd($client_ids);
        // $tt=array();
        $client_id_fdl = $client_ids;
        // dd($key);
        if (!($this->request->has('clientId') && ($this->request->has('clientId') != ""))) {
            foreach ($this->openingBalance->whereNotIn('client_id', $client_ids)->whereRaw('MONTH(last_date_of_month) = "' . $monthBefore . '"')->whereRaw('YEAR(last_date_of_month) = "' . $yearBefore . '"')->get() as $openingBalance) {
               if(count($datas) == 0)
               {

                  $key =0;
               }

                $key = $key + 1;

                $client_id_fdl[$key] = $openingBalance->client_id;               // $tt[] =  $openingBalance->client_id;
                $client_id = $openingBalance->client_id;
                $datas[$key]['client'] = $this->client->find($client_id);
                $datas[$key]['payments'] = $this->payment->where('client_id', $client_id)->whereRaw('MONTH(payment_date) = "' . $month . '"')->whereRaw('YEAR(payment_date) = "' . $year . '"')->get();
                $datas[$key]['clientTransactions'] = $this->clientTransaction->where('client_id', $client_id)->whereRaw('MONTH(paid_date) = "' . $month . '"')->whereRaw('YEAR(paid_date) = "' . $year . '"')->sum("amount");
                $datas[$key]['commissionValidation'] = $this->payment->where('client_id', $client_id)->whereRaw('MONTH(payment_date) = "' . $month . '"')->whereRaw('YEAR(payment_date) = "' . $year . '"')->where('trans_description', "Comm'sion")->where('trans_description', "Comm'sion")->count();
                // $datas[$key]['fdlAmounts'] = array();
            }
        }
        // dd($datas);
        if (!($this->request->has('clientId') && ($this->request->has('clientId') != ""))) {

            // foreach ($this->invoiceFollow->where('collection_action_code_id', 16)->whereNotIn('client_id', $client_id_fdl)->whereRaw('MONTH(date) = "' . $monthBefore . '"')->whereRaw('YEAR(date) = "' . $yearBefore . '"')->get() as $invoiceFollowup) {

            $client_ids = $this->invoiceFollow->whereNotIn('client_id', $client_id_fdl);
            $client_ids = $client_ids->whereRaw('MONTH(date) = "' . $month . '"')->where('collection_action_code_id', '=', '16')->whereRaw('YEAR(date) = "' . $year . '"')->groupBy('client_id')->pluck("client_id")->toArray();
            // dd($client_ids);
            // $client_id_fdl[$key] =  $invoiceFollowup->client_id;
            foreach ($client_ids as $key2 => $client_id) {              // $tt[] =  $openingBalance->client_id;
                $client_id = $client_id;
                $key = $key + 1;
                $datas[$key]['client'] = $this->client->find($client_id);
                $datas[$key]['payments'] = $this->payment->where('client_id', $client_id)->whereRaw('MONTH(payment_date) = "' . $month . '"')->whereRaw('YEAR(payment_date) = "' . $year . '"')->get();
                $datas[$key]['clientTransactions'] = $this->clientTransaction->where('client_id', $client_id)->whereRaw('MONTH(paid_date) = "' . $month . '"')->whereRaw('YEAR(paid_date) = "' . $year . '"')->sum("amount");
                $datas[$key]['commissionValidation'] = $this->payment->where('client_id', $client_id)->whereRaw('MONTH(payment_date) = "' . $month . '"')->whereRaw('YEAR(payment_date) = "' . $year . '"')->where('trans_description', "Comm'sion")->where('trans_description', "Comm'sion")->count();
            }
            // $datas[$key]['fdlAmounts'] = $invoiceFollowup;
            //  }
        }
        // dd($key);
//dd($datas);
        //dd($tt);
        // dd($datas);
        //$data['payments'] = $invoice->payments()->whereRaw('MONTH(payment_date) = "' . $month . '"')->whereRaw('YEAR(payment_date) = "' . $year . '"');
        //  $datas = $client->clientTransactions()->whereRaw('MONTH(paid_date) = "' . $month . '"')->whereRaw('YEAR(paid_date) = "' . $year . '"')->first();
        //dd($datas);
        return $datas;
    }

    public function data11() {
        $modelName = $this->client;
        $clientDatas = $modelName->get();
        //  $clientDatas = $modelName->limit(30)->get();
        $datas = array();
        $keyPayemnt = 0;
        foreach ($clientDatas as $key => $clientData) {

            $balance = 0.00;
            $keyPayemntChek = 0;
            $month = date("m");

            $year = date("Y");
            $paymentOb = $clientData->payments()->whereRaw('MONTH(payment_date) = "' . $month . '"')->whereRaw('YEAR(payment_date) = "' . $year . '"')->get();
            // print_r($paymentOb);
            if ($this->request->has('filter')) {
                $value = $this->request->value;
                $valueArray = explode('/', $value);

                $month = $valueArray[0];
                $year = $valueArray[1];
                $paymentOb = $clientData->payments()->whereRaw('MONTH(payment_date) = "' . $month . '"')->whereRaw('YEAR(payment_date) = "' . $year . '"')->get();
            }

            $tt = 0;
            // print_r($paymentOb);
            foreach ($paymentOb as $keyPayemnt1 => $payment) {

                $datas[$keyPayemnt]['name'] = $clientData->name;
                $datas[$keyPayemnt]['client_code'] = $clientData->client_code;

                $datas[$keyPayemnt]['payment_date'] = $payment->payment_date;
                $datas[$keyPayemnt]['type'] = $payment->paid_place;
                $datas[$keyPayemnt]['reference'] = $payment->debtorInvoice->invoice_code;
                $datas[$keyPayemnt]['debtor'] = $payment->debtor->debtor_code;
                $datas[$keyPayemnt]['payment_type'] = $payment->payment_type;
                $datas[$keyPayemnt]['amount'] = $payment->amount;
                $balance = number_format($balance + $payment->amount, 2);
                $datas[$keyPayemnt]['balance'] = $balance;
                $keyPayemntChek = $keyPayemnt;
                $tt = 1;
                $keyPayemnt = $keyPayemnt + 1;
            }
            // dd($datas);
            if ($tt) {
                $datas[$keyPayemnt + 1]['name'] = $clientData->name;
                $datas[$keyPayemnt + 1]['client_code'] = $clientData->client_code;

                $datas[$keyPayemnt + 1]['payment_date'] = "28/" . $month . "/" . $year;

                $datas[$keyPayemnt + 1]['type'] = "Trf Trust";
                $datas[$keyPayemnt + 1]['reference'] = "";
                $datas[$keyPayemnt + 1]['debtor'] = "";
                $datas[$keyPayemnt + 1]['payment_type'] = "";
                $commition = number_format($balance / 100 * $clientData->commission, 2);
                $balance = number_format($balance - $commition, 2);
                $datas[$keyPayemnt + 1]['amount'] = $commition;

                $datas[$keyPayemnt + 1]['balance'] = $balance;

                $datas[$keyPayemnt + 2]['name'] = $clientData->name;
                $datas[$keyPayemnt + 2]['client_code'] = $clientData->client_code;
                $invoiceDate = $year . "-" . $month . "-5";



                $invoiceDate = date("Y-m-t", strtotime($invoiceDate));

                $invoiceDate = date("d/m/Y", strtotime($invoiceDate));

                $datas[$keyPayemnt + 2]['payment_date'] = $invoiceDate;
                $datas[$keyPayemnt + 2]['type'] = "Paid Trst";
                $datas[$keyPayemnt + 2]['reference'] = "";
                $datas[$keyPayemnt + 2]['debtor'] = "";
                $datas[$keyPayemnt + 2]['payment_type'] = "";


                $datas[$keyPayemnt + 2]['amount'] = $balance;

                $datas[$keyPayemnt + 2]['balance'] = '0.00';
            }
        }
//dd($datas);
        return $datas;
    }

    public function data22() {
        $modelName = $this->client;
        $clientDatas = $modelName->get();
        $datas = array();

        $key = 0;
        $datas = array();
        $keyPayemnt = 0;
        foreach ($clientDatas as $clientData) {

            $balance = 0.00;
            $keyPayemntChek = 0;
            $month = date("m");

            $year = date("Y");
            $paymentOb = $clientData->payments()->whereRaw('MONTH(payment_date) = "' . $month . '"')->whereRaw('YEAR(payment_date) = "' . $year . '"')->get();
            if ($this->request->has('filter')) {
                $value = $this->request->value;
                $valueArray = explode('/', $value);

                $month = $valueArray[0];
                $year = $valueArray[1];
                $paymentOb = $clientData->payments()->whereRaw('MONTH(payment_date) = "' . $month . '"')->whereRaw('YEAR(payment_date) = "' . $year . '"')->get();
            }

            if (count($paymentOb) > 0) {
                $tt = 0;

                foreach ($paymentOb as $keyPayemnt1 => $payment) {

                    $datas[$keyPayemnt]['name'] = $clientData->name;
                    $datas[$keyPayemnt]['client_code'] = $clientData->client_code;

                    $datas[$keyPayemnt]['payment_date'] = $payment->payment_date;
                    $datas[$keyPayemnt]['type'] = 'commission';
                    if ($payment->payment_place == 'Paid To CTC') {
                        $commisionString = '% commission on';
                    } else {
                        $commisionString = "% comm'sn (pymt)";
                    }
                    $datas[$keyPayemnt]['reference'] = $payment->debtorInvoice->invoice_code;
                    $datas[$keyPayemnt]['debtor'] = $payment->debtor->debtor_code;
                    $datas[$keyPayemnt]['payment_type'] = str_replace('.00', '', $clientData->commission) . '% commission on';
                    $commission = $payment->commission;
                    $commission = $payment->commission;
                    $commissionPecentRate = $clientData->commission;
                    if ($commissionPecentRate == 0) {
                        $commissionPecentRate = 20;
                    }
                    if ($commission == '0.00') {
                        $commission = number_format(($payment->amount * $commissionPecentRate / 100) * 1.1, 2);
                    }
                    $datas[$keyPayemnt]['amount'] = $commission;

                    $balance = number_format($balance + $commission, 2);
                    $datas[$keyPayemnt]['balance'] = $balance;
                    $keyPayemntChek = $keyPayemnt;
                    $tt = 1;
                    $keyPayemnt = $keyPayemnt + 1;
                }
                if ($tt) {
                    $invoiceDate = $year . "-" . $month . "-5";



                    $invoiceDate = date("Y-m-t", strtotime($invoiceDate));

                    $invoiceDate = date("d/m/Y", strtotime($invoiceDate));
                    $datas[$keyPayemnt]['name'] = $clientData->name;
                    $datas[$keyPayemnt]['client_code'] = $clientData->client_code;
                    $datas[$keyPayemnt]['payment_date'] = $invoiceDate;

                    $datas[$keyPayemnt]['type'] = "Trf Trust";
                    $datas[$keyPayemnt]['reference'] = "";
                    $datas[$keyPayemnt]['debtor'] = "";
                    $datas[$keyPayemnt]['payment_type'] = "";

                    $datas[$keyPayemnt]['amount'] = $balance;

                    $datas[$keyPayemnt]['balance'] = 0.00;
                    $keyPayemnt = $keyPayemnt + 1;
                }
            }
        }
//dd($datas);
        return $datas;
    }

    public function report4() {
        $month = date("m");

        $year = date("Y");

        if ($this->request->has('filter')) {
            $value = $this->request->value;
            $valueArray = explode('/', $value);

            $month = $valueArray[0];
            $year = $valueArray[1];
        }
        //dd($client);
        $clients = $this->client->get();
        foreach ($clients as $key => $client) {
            $datas[$key]['client_code'] = $client->client_code;
            $datas[$key]['name'] = $client->name;
            $datas[$key]['commission'] = '0.00';
            $datas[$key]['amount'] = '0.00';
            $directPay = '0.00';
            $usCash = '0.00';
            $usCheq = '0.00';
            //dd($client->clientAccounts()->where('paid_month', $this->monthArray[$month] . '/' . $year)->count());

            $usCash = $client->payments()->whereRaw('MONTH(payment_date) = "' . $month . '"')->whereRaw('YEAR(payment_date) = "' . $year . '"')->where('payment_type', 'cash')->where('paid_place', 'Paid to CTC')->sum('amount');

            $directPay = $client->payments()->whereRaw('MONTH(payment_date) = "' . $month . '"')->whereRaw('YEAR(payment_date) = "' . $year . '"')
                            ->where(function($q) {
                                $q->where('trans_description', 'Paid to client (Instead direct)')
                                ->orWhere('trans_description', 'Pd Direct');
                            })->sum('amount');

            $usCheq = $client->payments()->whereRaw('MONTH(payment_date) = "' . $month . '"')->whereRaw('YEAR(payment_date) = "' . $year . '"')->where('payment_type', 'cash')->where('paid_place', 'Paid to CTC')->sum('amount');
            $usCheq = $client->payments()->whereRaw('MONTH(payment_date) = "' . $month . '"')->whereRaw('YEAR(payment_date) = "' . $year . '"')->where('payment_type', 'cheque')->where('paid_place', 'Paid to CTC')->sum('amount');
            $paidUs = $client->payments()->whereRaw('MONTH(payment_date) = "' . $month . '"')->whereRaw('YEAR(payment_date) = "' . $year . '"')
                            ->where(function($q) {
                                $q->where('trans_description', 'Paid CCS')
                                ->orWhere('trans_description', 'Paid to CTC');
                            })->sum('amount');



            //$client->payments()->whereRaw('MONTH(payment_date) = "' . $month . '"')->whereRaw('YEAR(payment_date) = "' . $year . '"')->sum('price');
//               $datas[$key]['amount']= $client->clientAccounts()->where('paid_month', $this->monthArray[$month] . '/' . $year)->first()->amount ;
//                $datas[$key]['commission']= $client->clientAccounts()->where('paid_month', $this->monthArray[$month] . '/' . $year)->first()->commission ;
//

            $commissionRate = 0.00;
            if ($client->commission != 0.00) {
                $commissionRate = $client->commission;
            }

            $datas[$key]['amount'] = 0.00;
            $datas[$key]['commission'] = 0.00;

            $datas[$key]['directPay'] = $directPay;
            $datas[$key]['paidUs'] = $paidUs;
            if ($client->payments()->whereRaw('MONTH(payment_date) = "' . $month . '"')->whereRaw('YEAR(payment_date) = "' . $year . '"')->where('trans_description', "Comm'sion")->where('payment_type', "Comm PD")->count() < 1) {
                $directPayCom = (float) ($directPay * $commissionRate / 100) * 1.1;
            } else {
                $directPayCom = $client->payments()->whereRaw('MONTH(payment_date) = "' . $month . '"')->whereRaw('YEAR(payment_date) = "' . $year . '"')->where('trans_description', "Comm'sion")->where('payment_type', "Comm PD")->first()->amount;
            }
            $datas[$key]['directPayCom'] = $directPayCom;
            if ($client->payments()->whereRaw('MONTH(payment_date) = "' . $month . '"')->whereRaw('YEAR(payment_date) = "' . $year . '"')->where('trans_description', "Comm'sion")->where('payment_type', "Comm PY")->count() < 1) {
                $paidUsCom = (float) ($paidUs * $commissionRate / 100) * 1.1;
            } else {
                $paidUsCom = $client->payments()->whereRaw('MONTH(payment_date) = "' . $month . '"')->whereRaw('YEAR(payment_date) = "' . $year . '"')->where('trans_description', "Comm'sion")->where('payment_type', "Comm PY")->first()->amount;
            }
            //$paidUsCom =number_format((float)$paidUs * $commissionRate / 100, 2);
            $datas[$key]['paidUsCom'] = (float) $paidUsCom;
            $commision = (float) $directPayCom + (float) $paidUsCom;
            $datas[$key]['commission'] = $commision;

            // $total =   number_format((float)$directPay + (float)$paidUs, 2, '.', '') ;
            //   $total =(float)str_replace(',', '', $total);
            $total = (float) $directPay + (float) $paidUs;
            $datas[$key]['total'] = $total;
            $datas[$key]['usCheq'] = (float) $usCheq;
        }



        // $datas = $this->monthArray[$month] . '/' . $year;
        //dd($datas);
        return $datas;
    }

    public function report5() {
        $datas = array();
        //  dd($this->request->has('to'));
        if (($this->request->has('to')) || ($this->request->has('from'))) {

            $from = $this->from;
            $to = $this->to;
            // dd($from.$to);
            $dues = $this->due;
            if ($from != '') {

                $dues = $dues->where('due_date', '>', $from);
            }
            if ($to != '') {
                $dues = $dues->where('due_date', '<', $to);
            }

            $dues = $dues->get();
        } else {
            $month = date("m");

            $year = date("Y");

            if ($this->request->has('filter')) {
                $value = $this->request->value;
                $valueArray = explode('/', $value);

                $month = $valueArray[0];
                $year = $valueArray[1];
            }
            //dd($client);


            $dues = $this->due->whereRaw('MONTH(due_date) = "' . $month . '"')->whereRaw('YEAR(due_date) = "' . $year . '"')->get();
        }
        foreach ($dues as $key => $due) {
            $datas[$key]['debtor_name'] = $due->debtor->name;
            $datas[$key]['client_name'] = $due->client->name;
            $datas[$key]['amount'] = $due->amount;
            $datas[$key]['due_date'] = $due->due_date;
        }



        // $datas = $this->monthArray[$month] . '/' . $year;
        //dd($datas);
        return $datas;
    }

    public function report6() {

        $datas = array();
        //  dd($this->request->has('to'));
        if (($this->request->has('to')) || ($this->request->has('from'))) {

            $from = $this->from;
            $to = $this->to;
            // dd($from.$to);
            $payments = $this->payment;
            if ($from != '') {

                $payments = $payments->where('payment_date', '>', $from);
            }
            if ($to != '') {
                $payments = $payments->where('payment_date', '<', $to);
            }

            $payments = $payments
                    ->where(function($q) {
                        $q->where('payment_type', 'debit card')
                        ->orWhere('payment_type', 'credit card');
                    })
                    ->get();
        } else {

            $month = date("m");

            $year = date("Y");

            if ($this->request->has('filter')) {
                $value = $this->request->value;
                $valueArray = explode('/', $value);

                $month = $valueArray[0];
                $year = $valueArray[1];
            }

            $payments = $this->payment->whereRaw('MONTH(payment_date) = "' . $month . '"')->whereRaw('YEAR(payment_date) = "' . $year . '"')
                    ->where(function($q) {
                        $q->where('payment_type', 'debit card')
                        ->orWhere('payment_type', 'credit card');
                    })
                    ->get();
        }
        //dd($client);


        foreach ($payments as $key => $payment) {
            $datas[$key]['debtor_name'] = $payment->debtor->name;
            $datas[$key]['name_on_card'] = $payment->name_on_card;
            $datas[$key]['card_number'] = $payment->card_number;
            $datas[$key]['card_expiry_date'] = $payment->card_expiry_month . '/' . $payment->card_expiry_year;
            $datas[$key]['receipt_number'] = $payment->receipt_number;
            $datas[$key]['amount'] = $payment->amount;
        }



        // $datas = $this->monthArray[$month] . '/' . $year;
        //dd($datas);
        return $datas;
    }

    public function report7() {

        $datas = array();
        //  dd($this->request->has('to'));
        if (($this->request->has('to')) || ($this->request->has('from'))) {

            $from = $this->from;
            $to = $this->to;
            // dd($from.$to);
            $invoiceFollows = $this->invoiceFollow;
            if ($from != '') {

                $invoiceFollows = $invoiceFollows->where('date', '>', $from);
            }
            if ($to != '') {
                $invoiceFollows = $invoiceFollows->where('date', '<', $to);
            }

            $invoiceFollows = $invoiceFollows->get();
        } else {

            $month = date("m");

            $year = date("Y");

            if ($this->request->has('filter')) {
                $value = $this->request->value;
                $valueArray = explode('/', $value);

                $month = $valueArray[0];
                $year = $valueArray[1];
            }

            $invoiceFollows = $this->invoiceFollow->whereRaw('MONTH(next_follow_date) = "' . $month . '"')->whereRaw('YEAR(next_follow_date) = "' . $year . '"')->get();
        }
        //dd($client);
        ini_set('memory_limit', '-1');

        foreach ($invoiceFollows as $key => $invoiceFollow) {
            $datas[$key]['debtor_name'] = $invoiceFollow->debtor->name;
            $datas[$key]['client_name'] = $invoiceFollow->client->name;
            $datas[$key]['date'] = $invoiceFollow->date;
            $datas[$key]['next_follow_date'] = $invoiceFollow->next_follow_date;
            $debtorInvoice = $invoiceFollow->debtorInvoice;
//            if (count($debtorInvoice)) {
            if ($debtorInvoice !== null && $debtorInvoice->count() > 0) {


                $datas[$key]['original_debt'] = $debtorInvoice->original_debt;
                $datas[$key]['paid_recovery'] = number_format($debtorInvoice->original_debt - $debtorInvoice->current_balance, 2);
                $datas[$key]['current_balance'] = $debtorInvoice->current_balance;
                $datas[$key]['last_payment'] = $debtorInvoice->last_payment;
                $datas[$key]['last_paid'] = $debtorInvoice->last_paid;
            } else {
                $datas[$key]['original_debt'] = "";
                $datas[$key]['paid_recovery'] = "";
                $datas[$key]['current_balance'] = "";
                $datas[$key]['last_payment'] = "";
                $datas[$key]['last_paid'] = "";
            }
            $lastAction = "";
            if ($invoiceFollow->collectionActionCode) {
                $lastAction = $invoiceFollow->collectionActionCode->code;
            }
            $datas[$key]['last_action'] = $lastAction;
        }

        //dd($datas);
        // $datas = $this->monthArray[$month] . '/' . $year;
        //dd($datas);
        return $datas;
    }

    public function report8($client) {
        $clientData = $client;

        $balance = 0.00;
        $keyPayemntChek = 0;
        $month = date("m");
        $datas = array();
        $year = date("Y");
        $paymentOb = $clientData->payments()->whereRaw('MONTH(payment_date) = "' . $month . '"')->whereRaw('YEAR(payment_date) = "' . $year . '"')->get();
        if ($this->request->has('filter')) {
            $value = $this->request->value;
            $valueArray = explode('/', $value);

            $month = $valueArray[0];
            $year = $valueArray[1];
            $paymentOb = $clientData->payments()->whereRaw('MONTH(payment_date) = "' . $month . '"')->whereRaw('YEAR(payment_date) = "' . $year . '"')->get();
        }

        if (count($paymentOb) > 0) {


            foreach ($paymentOb as $keyPayemnt => $payment) {
                $invoice = $payment->debtorInvoice;
                $debtor = $payment->debtor;
                if ($this->request->has('invoiceStateCodeId')) {

                    if ($this->request->invoiceStateCodeId == $invoice->invoice_status_code_id || $invoice->status_code == $this->invoiceStatusCode->find($this->request->invoiceStateCodeId)->code) {
                        $datas[$keyPayemnt]['ClientName'] = $clientData->name;
                        $datas[$keyPayemnt]['DebtorName'] = $debtor->name;
                        $datas[$keyPayemnt]['DebtorAddress'] = $debtor->mailing_address . ' ' . $debtor->mailing_suburb . ' ' . $debtor->mailing_state . ' ' . $debtor->mailing_postcode . ' ' . $debtor->mailing_suburb;
                        $datas[$keyPayemnt]['DebtorCode'] = $debtor->debtor_code;

                        $datas[$keyPayemnt]['OriginalDebt'] = $invoice->original_debt;
                        $datas[$keyPayemnt]['paymentDate'] = $payment->payment_date;
                        $datas[$keyPayemnt]['CurrentBalance'] = $invoice->current_balance;
                        $datas[$keyPayemnt]['invoiceCode'] = $invoice->invoice_code;
                        $datas[$keyPayemnt]['amount'] = $payment->amount;
                        $datas[$keyPayemnt]['WherePaid'] = $payment->trans_description;
                        $invoice_status_code = '';
                        if ($invoice->invoice_status_code_id == 0 || $invoice->invoice_status_code_id == '') {
                            $invoice_status_code = $invoice->status_code;
                        } else {
                            $invoice_status_code = $invoice->invoiceStatusCode->code;
                        }
                        $prev_invoice_status_code = '';
                        if (!($invoice->prev_invoice_status_code_id == 0 || $invoice->prev_invoice_status_code_id == '')) {
                            $prev_invoice_status_code = $invoice->status_code;
                        }
                        $datas[$keyPayemnt]['PreviousStatus'] = $prev_invoice_status_code;
                        $datas[$keyPayemnt]['CurrentStatus'] = $invoice_status_code;
                    }
                } else {
                    $datas[$keyPayemnt]['ClientName'] = $clientData->name;
                    $datas[$keyPayemnt]['DebtorName'] = $debtor->name;



                    $datas[$keyPayemnt]['DebtorAddress'] = $debtor->mailing_address . ' ' . $debtor->mailing_suburb . ' ' . $debtor->mailing_state . ' ' . $debtor->mailing_postcode . ' ' . $debtor->mailing_suburb;
                    $datas[$keyPayemnt]['DebtorCode'] = $debtor->debtor_code;

                    $datas[$keyPayemnt]['OriginalDebt'] = $invoice->original_debt;
                    $datas[$keyPayemnt]['paymentDate'] = $payment->payment_date;
                    $datas[$keyPayemnt]['CurrentBalance'] = $invoice->current_balance;
                    $datas[$keyPayemnt]['invoiceCode'] = $invoice->invoice_code;
                    $datas[$keyPayemnt]['amount'] = $payment->amount;
                    $datas[$keyPayemnt]['WherePaid'] = $payment->trans_description;
                    $invoice_status_code = '';
                    if ($invoice->invoice_status_code_id == 0 || $invoice->invoice_status_code_id == '') {
                        $invoice_status_code = $invoice->status_code;
                    } else {
                        $invoice_status_code = $invoice->invoiceStatusCode->code;
                    }
                    $prev_invoice_status_code = '';
                    if (!($invoice->prev_invoice_status_code_id == 0 || $invoice->prev_invoice_status_code_id == '')) {
                        $prev_invoice_status_code = $invoice->status_code;
                    }
                    $datas[$keyPayemnt]['PreviousStatus'] = $prev_invoice_status_code;
                    $datas[$keyPayemnt]['CurrentStatus'] = $invoice_status_code;
                }
            }
        }

        return $datas;
    }

    public function report9() {
        $datas = array();
        //  dd($this->request->has('to'));
        if (($this->request->has('to')) || ($this->request->has('from'))) {

            $from = $this->from;
            $to = $this->to;
            // dd($from.$to);
            $payments = $this->payment;
            if ($from != '') {

                $payments = $payments->where('payment_date', '>', $from);
            }
            if ($to != '') {
                $payments = $payments->where('payment_date', '<', $to);
            }

            $payments = $payments
                    ->where(function($q) {
                        $q->where('payment_type', 'cheque');
                        // ->orWhere('payment_type', 'EFT');
                    })
                    ->get();
        } else {

            $month = date("m");

            $year = date("Y");

            if ($this->request->has('filter')) {
                $value = $this->request->value;
                $valueArray = explode('/', $value);

                $month = $valueArray[0];
                $year = $valueArray[1];
            }

            $payments = $this->payment->whereRaw('MONTH(payment_date) = "' . $month . '"')->whereRaw('YEAR(payment_date) = "' . $year . '"')
                    ->where(function($q) {
                        $q->where('payment_type', 'cheque')
                          ->orWhere('payment_type', 'cash');
                    })
                    ->get();
        }
        //dd($client);


        foreach ($payments as $key => $payment) {
            $datas[$key]['debtor_name'] = $payment->debtor->name;
            $datas[$key]['bank'] = $payment->bank;
            $datas[$key]['branch'] = $payment->branch;
            $datas[$key]['cheque_no'] = $payment->cheque_no;
            // $datas[$key]['receipt_number'] = $payment->receipt_number;
            $datas[$key]['amount'] = $payment->amount;
             $datas[$key]['payment_type'] = $payment->payment_type;
        }



        // $datas = $this->monthArray[$month] . '/' . $year;
        //dd($datas);
        return $datas;
    }

    public function report10() {
        $datas = array();


        $month = date("m");

        $year = date("Y");

        if ($this->request->has('filter')) {
            $value = $this->request->value;
            $valueArray = explode('/', $value);

            $month = $valueArray[0];
            $year = $valueArray[1];
        }
        //dd($client);
        //
        $openingBalanceDate = $year . "-" . ($month - 1 ) . "-5";
        //dd($openingBalanceDate);
        $openingBalanceDate = date("Y-m-t", strtotime($openingBalanceDate));
        //dd($openingBalanceDate);
        $openingBalanceDatecheck = $this->openingBalance->where('last_date_of_month', '=', $openingBalanceDate)->count();
        // dd($openingBalanceDatecheck);

        $openingArray = array();

        // dd($openingArray);
        return $openingArray;
    }

    public function report11($client) {
        $clientData = $client;

        $balance = 0.00;
        $keyPayemntChek = 0;
        $month = date("m");
        $datas = array();
        $year = date("Y");
        $debtorInvoices = $clientData->debtorInvoices;

        if ($this->request->has('invoiceStateCodeId')) {

//         >where(function($q) {
//                    $q->where('invoice_status_code_id', '=', $this->request->invoiceStateCodeId)
//                    ->orWhere('status_code', $this->invoiceStatusCode->find($this->request->invoiceStateCodeId)->code);
//                     })

            $debtorInvoices1 = $clientData->debtorInvoices()
                    ->where('invoice_status_code_id', '=', $this->request->invoiceStateCodeId)
                    ->pluck('id')->toArray();
            $debtorInvoices2 = $clientData->debtorInvoices()
                    ->where('invoice_status_code_id', '=', null)
                    ->where('status_code', $this->invoiceStatusCode->find($this->request->invoiceStateCodeId)->code)
                    ->pluck('id')->toArray();

            $debtorInvoicesId = array_merge($debtorInvoices1, $debtorInvoices2);


            $debtorInvoices = $clientData->debtorInvoices()
                    ->whereIn('id', $debtorInvoicesId)
                    ->get();
        }



        foreach ($debtorInvoices as $keyPayemnt => $debtorInvoice) {

            $debtor = $debtorInvoice->debtor;
            $datas[$keyPayemnt]['clientName'] = $clientData->name;
            $datas[$keyPayemnt]['DebtorName'] = $debtor->name;
            $datas[$keyPayemnt]['DebtorCode'] = $debtor->debtor_code;
            $datas[$keyPayemnt]['OriginalDebt'] = $debtorInvoice->original_debt;
            $datas[$keyPayemnt]['CurrentBalance'] = $debtorInvoice->current_balance;



            $datas[$keyPayemnt]['DebtorAddress'] = $debtor->mailing_address . ' ' . $debtor->mailing_suburb . ' ' . $debtor->mailing_state . ' ' . $debtor->mailing_postcode . ' ' . $debtor->mailing_suburb;

            $invoice = $debtorInvoice;

            $invoice_status_code = '';
            if ($invoice->invoice_status_code_id == 0 || $invoice->invoice_status_code_id == '') {
                $invoice_status_code = $invoice->status_code;
            } else {
                $invoice_status_code = $invoice->invoiceStatusCode->code;
            }
            $prev_invoice_status_code = '';
            if (!($invoice->prev_invoice_status_code_id == 0 || $invoice->prev_invoice_status_code_id == '')) {
                $prev_invoice_status_code = $invoice->status_code;
            }

            //  $datas[$keyPayemnt]['PreviousStatus'] = $prev_invoice_status_code;
            $datas[$keyPayemnt]['CurrentStatus'] = $invoice_status_code;
        }

        return $datas;
    }

    public function report15() {
        $clientData = $client;

        $balance = 0.00;
        $keyPayemntChek = 0;
        $month = date("m");
        $datas = array();
        $year = date("Y");
        $debtorInvoices = $clientData->debtorInvoices;

        if ($this->request->has('invoiceStateCodeId')) {

//         >where(function($q) {
//                    $q->where('invoice_status_code_id', '=', $this->request->invoiceStateCodeId)
//                    ->orWhere('status_code', $this->invoiceStatusCode->find($this->request->invoiceStateCodeId)->code);
//                     })

            $debtorInvoices1 = $clientData->debtorInvoices()
                    ->where('invoice_status_code_id', '=', $this->request->invoiceStateCodeId)
                    ->pluck('id')->toArray();
            $debtorInvoices2 = $clientData->debtorInvoices()
                    ->where('invoice_status_code_id', '=', null)
                    ->where('status_code', $this->invoiceStatusCode->find($this->request->invoiceStateCodeId)->code)
                    ->pluck('id')->toArray();

            $debtorInvoicesId = array_merge($debtorInvoices1, $debtorInvoices2);


            $debtorInvoices = $clientData->debtorInvoices()
                    ->whereIn('id', $debtorInvoicesId)
                    ->get();
        }



        foreach ($debtorInvoices as $keyPayemnt => $debtorInvoice) {

            $debtor = $debtorInvoice->debtor;
            $datas[$keyPayemnt]['clientName'] = $clientData->name;
            $datas[$keyPayemnt]['DebtorName'] = $debtor->name;
            $datas[$keyPayemnt]['DebtorCode'] = $debtor->debtor_code;
            $datas[$keyPayemnt]['OriginalDebt'] = $debtorInvoice->original_debt;
            $datas[$keyPayemnt]['CurrentBalance'] = $debtorInvoice->current_balance;



            $datas[$keyPayemnt]['DebtorAddress'] = $debtor->mailing_address . ' ' . $debtor->mailing_suburb . ' ' . $debtor->mailing_state . ' ' . $debtor->mailing_postcode . ' ' . $debtor->mailing_suburb;

            $invoice = $debtorInvoice;

            $invoice_status_code = '';
            if ($invoice->invoice_status_code_id == 0 || $invoice->invoice_status_code_id == '') {
                $invoice_status_code = $invoice->status_code;
            } else {
                $invoice_status_code = $invoice->invoiceStatusCode->code;
            }
            $prev_invoice_status_code = '';
            if (!($invoice->prev_invoice_status_code_id == 0 || $invoice->prev_invoice_status_code_id == '')) {
                $prev_invoice_status_code = $invoice->status_code;
            }

            //  $datas[$keyPayemnt]['PreviousStatus'] = $prev_invoice_status_code;
            $datas[$keyPayemnt]['CurrentStatus'] = $invoice_status_code;
        }

        return $datas;
    }

    public function report12($client) {
        $month = date("m");

        $year = date("Y");

        if ($this->request->has('filter')) {
            $value = $this->request->value;
            $valueArray = explode('/', $value);

            $month = $valueArray[0];
            $year = $valueArray[1];
        }



        // dd($client_ids);
        $datas = array();
        foreach ($this->payment->where('client_id', $client->id)->whereRaw('MONTH(payment_date) = "' . $month . '"')->whereRaw('YEAR(payment_date) = "' . $year . '"')->get() as $key => $payment) {
            $datas[$key]['clientName'] = $client->name;
            $datas[$key]['client_code'] = $client->client_code;
            $datas[$key]['debtor'] = $payment->debtor->name;
            $datas[$key]['trans_description'] = $payment->trans_description;
            $datas[$key]['payment_type'] = $payment->payment_type;
            $datas[$key]['payment_date'] = $payment->payment_date;
            $datas[$key]['amount'] = $payment->amount;
        }



        return $datas;
    }



    public function report13() {
        $datas = array();


        $month = date("m");

        $year = date("Y");

        if ($this->request->has('filter')) {
            $value = $this->request->value;
            $valueArray = explode('/', $value);

            $month = $valueArray[0];
            $year = $valueArray[1];
        }
        //dd($client);
        //
     $datas = $this->clientPayment->whereRaw('MONTH(paid_date) = "' . $month . '"')->whereRaw('YEAR(paid_date) = "' . $year . '"')->get();
        //dd($datas);
        // dd($openingArray);
        return  $datas;
    }

    public function report14() {
        $datas = array();


        $month = date("m");

        $year = date("Y");

        if ($this->request->has('filter')) {
            $value = $this->request->value;
            $valueArray = explode('/', $value);

            $month = $valueArray[0];
            $year = $valueArray[1];
        }
        //dd($client);
        //
     $datas = $this->clientTransaction->whereRaw('MONTH(paid_date) = "' . $month . '"')->whereRaw('YEAR(paid_date) = "' . $year . '"')->get();
        //dd($datas);
        // dd($openingArray);
        return  $datas;
    }


    public function report10Copy() {
        $datas = array();


        $month = date("m");

        $year = date("Y");

        if ($this->request->has('filter')) {
            $value = $this->request->value;
            $valueArray = explode('/', $value);

            $month = $valueArray[0];
            $year = $valueArray[1];
        }
        //dd($client);
        //
        $openingBalanceDate = $year . "-" . ($month - 1 ) . "-5";
        //dd($openingBalanceDate);
        $openingBalanceDate = date("Y-m-t", strtotime($openingBalanceDate));
        //dd($openingBalanceDate);
        $openingBalanceDatecheck = $this->openingBalance->where('last_date_of_month', '=', $openingBalanceDate)->count();
        // dd($openingBalanceDatecheck);
        $openingArray = array();
        if ($openingArray > 0) {
            $client_ids = array();

            if ($this->request->has('filter')) {
                if ($this->request->has('clientId') && ($this->request->has('clientId') != "")) {
                    $client_ids = array($this->request->clientId);
                } else {
                    $client_ids = $this->payment->whereRaw('MONTH(payment_date) = "' . $month . '"')->whereRaw('YEAR(payment_date) = "' . $year . '"')->groupBy('client_id')->pluck("client_id")->toArray();
                }
            } else {
                $client_ids = $this->payment->whereRaw('MONTH(payment_date) = "' . $month . '"')->whereRaw('YEAR(payment_date) = "' . $year . '"')->groupBy('client_id')->pluck("client_id")->toArray();
            }
            // dd($client_ids);
            $datas = array();
            $openingArray = array();
            if ($month == 1) {
                $monthBefore = 12;
                $yearBefore = $year - 1;
            } else {
                $monthBefore = $month - 1;
                $yearBefore = $year;
            }

            $key = 0;
            $clientArrayId = 0;
            $clientArrayOpeningBalance = array();
            foreach ($client_ids as $key => $client_id) {
                $datas[$key]['client'] = $this->client->find($client_id);
                // $payments = $this->payment->where('client_id', $client_id)->whereRaw('MONTH(payment_date) = "' . $month . '"')->whereRaw('YEAR(payment_date) = "' . $year . '"')->get();

                $paidCtcAmount = $datas[$key]['client']->payments()->whereRaw('MONTH(payment_date) = "' . $month . '"')->whereRaw('YEAR(payment_date) = "' . $year . '"')
                        ->where(function($q) {
                            $q->where('trans_description', 'Paid CCS')
                            ->orWhere('trans_description', 'Paid to CTC');
                        })
                        ->sum('amount');

                $paidTotalAmountEnter = $paidCtcAmount;
                $paidCtcAmountCommission = ($paidCtcAmount * $datas[$key]['client']->commission / 100) * 1.1;

                $paidCtcAmount = $paidCtcAmount - $paidCtcAmountCommission;

                $directc = $datas[$key]['client']->payments()->whereRaw('MONTH(payment_date) = "' . $month . '"')->whereRaw('YEAR(payment_date) = "' . $year . '"')
                                ->where(function($q) {
                                    $q->where('trans_description', 'Paid to client (Instead direct)')
                                    ->orWhere('trans_description', 'Pd Direct');
                                })->sum('amount');

                $directcCommission = ($directc * $datas[$key]['client']->commission / 100) * 1.1;
                // dd($datas[$key]['client']->OpeningBalances()->get());

                $openingBalance = $this->openingBalance->where('client_id', $datas[$key]['client']->id)->whereRaw('MONTH(last_date_of_month) = "' . $monthBefore . '"')->whereRaw('YEAR(last_date_of_month) = "' . $yearBefore . '"')->first();

                $openingBalanceAmount = 0.00;
                if (count($openingBalance)) {
                    $openingBalanceAmount = $openingBalance->opening_amount_for_next_month;
                }

                $paymentAdjustments = $datas[$key]['client']->paymentAdjustments()->whereRaw('MONTH(adjustment_date) = "' . $month . '"')->whereRaw('YEAR(adjustment_date) = "' . $year . '"')->get();
                if (count($paymentAdjustments)) {
                    if ($paymentAdjustments[0]->adjustment_type == 'Debit Balance Add') {
                        $openingBalanceAmount = $openingBalance + $paymentAdjustments[0]->amount;
                    } else {
                        $openingBalanceAmount = $openingBalance - $paymentAdjustments[0]->amount;
                    }
                }

                $clientPayment = $datas[$key]['client']->clientPayments()->whereRaw('MONTH(paid_date) = "' . $month . '"')->whereRaw('YEAR(paid_date) = "' . $year . '"')->sum('amount');

                $commimissionTotal = $datas[$key]['client']->payments()->whereRaw('MONTH(payment_date) = "' . $month . '"')->whereRaw('YEAR(payment_date) = "' . $year . '"')->where('trans_description', "Comm'sion")->sum('amount');

                $totalAmountPay = 0.00;
                if ($commimissionTotal > 0) {
                    $totalAmountPay = $openingBalanceAmount + $commimissionTotal * 1.1 - ($paidTotalAmountEnter + $clientPayment);
                } else {
                    $totalAmountPay = $openingBalanceAmount + $directcCommission - ($paidCtcAmount + $clientPayment);
                }

                $fdlAmount = count($datas[$key]['client']->invoiceFollows()->whereRaw('MONTH(date) = "' . $month . '"')->where('collection_action_code_id', '=', '16')->whereRaw('YEAR(date) = "' . $year . '"')->get()) * $datas[$key]['client']->final_demand_rate;
                $totalAmountPay = $totalAmountPay + $fdlAmount;
                $clientArrayOpeningBalance[$key] = $datas[$key]['client']->id;
                if ((number_format($totalAmountPay, 2) ) > 0) {

                    // dd($datas[$key]['client']);
                    $openingArray[$key]['client'] = $datas[$key]['client'];
                    $openingArray[$key]['opening_amount_for_next_month'] = $totalAmountPay;
                    $invoiceDate = $year . "-" . $month . "-5";
                    $invoiceDate = date("Y-m-t", strtotime($invoiceDate));
                    $invoiceDate = date("d/m/Y", strtotime($invoiceDate));
                    $openingArray[$key]['last_date_of_month'] = $invoiceDate;
                }
                // $datas[$key]['clientTransactions'] = $this->clientTransaction->where('client_id', $client_id)->whereRaw('MONTH(paid_date) = "' . $month . '"')->whereRaw('YEAR(paid_date) = "' . $year . '"')->sum("amount");
                //$datas[$key]['commissionValidation'] = $this->payment->where('client_id', $client_id)->whereRaw('MONTH(payment_date) = "' . $month . '"')->whereRaw('YEAR(payment_date) = "' . $year . '"')->where('trans_description', "Comm'sion")->where('trans_description', "Comm'sion")->count();
            }
            //  dd($monthBefore.' '. $yearBefore);
            // $client_ids = join("','",$client_ids);
            //   dd($this->openingBalance->whereRaw('MONTH(last_date_of_month) = "' . $monthBefore . '"')->whereRaw('YEAR(last_date_of_month) = "' . $yearBefore . '"')->get());

            $client_id_fdl = $clientArrayOpeningBalance;
            //dd($openingArray);

            foreach ($this->openingBalance->whereNotIn('client_id', $clientArrayOpeningBalance)->whereRaw('MONTH(last_date_of_month) = "' . $monthBefore . '"')->whereRaw('YEAR(last_date_of_month) = "' . $yearBefore . '"')->get() as $openingBalance) {
                // dd(1);
                $clientPayment = $openingBalance->client->clientPayments()->whereRaw('MONTH(paid_date) = "' . $month . '"')->whereRaw('YEAR(paid_date) = "' . $year . '"')->sum('amount');
                //   if($openingBalance->opening_amount_for_next_month >  $clientPayment)
                //  {
                $key = $key + 1;
                $client_id_fdl[$key] = $openingBalance->client_id;
                $openingArray[$key]['client'] = $openingBalance->client;
                $openingArray[$key]['opening_amount_for_next_month'] = $openingBalance->opening_amount_for_next_month - $clientPayment;
                $invoiceDate = $year . "-" . $month . "-5";
                $invoiceDate = date("Y-m-t", strtotime($invoiceDate));
                $invoiceDate = date("d/m/Y", strtotime($invoiceDate));
                $openingArray[$key]['last_date_of_month'] = $invoiceDate;
                $openingArray[$key]['state'] = $openingBalance->state;
                //   }
            }

            $client_ids = $this->invoiceFollow->whereNotIn('client_id', $client_id_fdl);
            $client_ids = $client_ids->whereRaw('MONTH(date) = "' . $month . '"')->where('collection_action_code_id', '=', '16')->whereRaw('YEAR(date) = "' . $year . '"')->groupBy('client_id')->pluck("client_id")->toArray();
            // dd($client_ids);
            // $client_id_fdl[$key] =  $invoiceFollowup->client_id;
            foreach ($client_ids as $key2 => $client_id) {              // $tt[] =  $openingBalance->client_id;
                $client_id = $client_id;
                $key = $key + 1;
                $clientF = $this->client->find($client_id);
                $openingArray[$key]['client'] = $clientF;
                $openingArray[$key]['opening_amount_for_next_month'] = (count($clientF->invoiceFollows()->whereRaw('MONTH(date) = "' . $month . '"')->where('collection_action_code_id', '=', '16')->whereRaw('YEAR(date) = "' . $year . '"')->get())) * $clientF->final_demand_rate - $clientPayment;
                $invoiceDate = $year . "-" . $month . "-5";
                $invoiceDate = date("Y-m-t", strtotime($invoiceDate));
                $invoiceDate = date("d/m/Y", strtotime($invoiceDate));
                $openingArray[$key]['last_date_of_month'] = $invoiceDate;
            }
        }
        // dd($openingArray);
        return $openingArray;
    }

}
