<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Redirect;
use Response;
use Input;
use File;
use App\Models\Mail as Mailsend;
use App\Models\Payment;
use App\Models\Config;
use Illuminate\Support\Facades\Auth;
use App\Models\DebtorInvoice;
use App\Models\Due;
use App\Models\Debtor;
use App\Models\InvoiceFollow;
use App\Models\Calendar;
use App\Models\InvoiceCharge;
use App\Http\Requests\Follow\CreateRequest;
use App\Http\Requests\Follow\EditRequest;
use Illuminate\Support\Facades\Session;

class FollowController extends Controller {

    protected $request;
    protected $config;
    protected $debtorInvoice;
    protected $due;
    protected $follow;
    protected $calendar;
    protected $invoiceCharge;
    protected $debtor;

    public function __construct(Request $request, Config $config, DebtorInvoice $debtorInvoice, Due $due, InvoiceFollow $invoiceFollow, Calendar $calendar, InvoiceCharge $invoiceCharge, Debtor $debtor) {

        $this->request = $request;

        $this->config = $config;
        $this->debtorInvoice = $debtorInvoice;
        $this->due = $due;
        $this->follow = $invoiceFollow;
        $this->calendar = $calendar;
        $this->invoiceCharge = $invoiceCharge;
        $this->debtor = $debtor;
        //$this->middleware('auth');
    }

    public function index($model = '', $invoiceId = '') {

        $path = explode('/', $this->request->path());
        $paginationSize = Config::find(1)->value;
        $follow = $this->follow;
        if ($path[0] == 'follow') {
            $follows = $follow->paginate($paginationSize);
            return view('follows.index', compact('follows'));
        }
        if ($path[0] == 'debtor') {
            $debtor = $model;
        } else {
            $client = $model;
        }

        // dd($model);


        $follows = $follow->where('debtor_invoice_id', $invoiceId)->orderBy('date', 'DESC')->paginate($paginationSize);
        $invoice = $this->debtorInvoice->find($invoiceId);
//dd($follows);
        if ($path[0] == 'debtor') {
            return view('debtors.follows.index', compact('follows', 'invoice', 'client'));
        }

        return view('clients.invoices.debtor.follows.index', compact('follows', 'invoice', 'client'));
    }

    public function create($client, $invoiceId) {
        $invoice = $this->debtorInvoice->find($invoiceId);
//        echo '<pre>';var_dump($client);exit;

        return view('clients.invoices.debtor.follows.create', compact('invoice', 'client'));
    }

    public function store(CreateRequest $request, $client = '', $invoiceId = '') {

        //  dd($request->collection_action_code_id);



        $follow = $this->follow;
        $follow->collection_action_code_id = $request->collection_action_code_id;
        $follow->latest_comment = $request->latest_comment;
        $follow->previous_comment = $request->previous_comment;
        $follow->next_follow_date = $request->next_follow_date;
        $follow->date = $request->date;
        $follow->status = 'followed';
        if($invoiceId == '')
        {
           $invoiceId = $request->debtor_invoice_id;
        }
        $invoice = $this->debtorInvoice->find($invoiceId);
        //dd($this->follow->where("debtor_invoice_id", $invoice->id)->where("collection_action_code_id", ">",  0)->orderBy('id', 'DESC')->get());
        $follow->client_id = $invoice->client_id;
        $follow->debtor_id = $invoice->debtor_id;
        $follow->user_id = $invoice->user_id;
        $follow->debtor_invoice_id = $invoice->id;

        $follow->save();

        $invoice = $this->debtorInvoice->find($invoiceId);
        foreach ($this->follow->where("debtor_invoice_id", $invoice->id)->where("collection_action_code_id", "!=", 0)->orderBy('id', 'DESC')->get() as $kye => $followData) {
            if ($kye == 0) {
                $invoice->last_action = $followData->collectionActionCode->code;
            }
            if ($kye == 1) {
                $invoice->action_1st_letter_code = $followData->collectionActionCode->code;
            }
            if ($kye == 2) {
                $invoice->action_2nd_letter_code = $followData->collectionActionCode->code;
            }
            if ($kye == 3) {
                $invoice->action_3rd_letter_code = $followData->collectionActionCode->code;
            }
        }

        $invoice->save();



//        $follow = new InvoiceFollow();
//
//
//        $follow->previous_comment = $request->latest_comment;
//
//        $follow->date = $request->next_follow_date;
//        $date = new \DateTime($request->next_follow_date);
//        $date->add(new \DateInterval('P14D'));
//
//        $follow->next_follow_date = $date->format('Y-m-d');
//        $invoice = $this->debtorInvoice->find($invoiceId);
//        $follow->client_id = $invoice->client_id;
//        $follow->debtor_id = $invoice->debtor_id;
//        $follow->user_id = $invoice->user_id;
//        $follow->invoice_id = $invoice->id;
//         $follow->status = 'todo';
//        $follow->save();

        $calendar = $this->calendar;


        //$date = new \DateTime($request->next_follow_date);
        //    $date->add(new \DateInterval('P14D'));
        $calendar->name = 'Follow up :' . $invoice->debtor->debtor_code;

        $calendar->user_id = $invoice->user_id;
        $calendar->client_id = $invoice->client_id;
        $calendar->debtor_id = $invoice->debtor_id;
        $calendar->invoice_id = $invoice->id;
        $calendar->status = 'create';
        $calendar->type = 'todo';
        $calendar->start_date = $request->next_follow_date;
        $calendar->start_time = $request->start_time;
        $calendar->end_date = $request->next_follow_date;
        $calendar->end_time = $request->end_time;
        $calendar->remainder = 0;

        $calendar->save();



        if ($request->has('debtorInvoice')) {
            if($request->collection_action_code_id == 16)
            {
            $invoice->fdl_state = 'FDL send';
            $invoice->save();
            $invoiceCharge = $this->invoiceCharge;
            $invoiceCharge->type = 'FDL';
            $invoiceCharge->entry_date =$request->date;
            $invoiceCharge->amount = $client->final_demand_rate;

            $invoiceCharge->save();
            }
            if($request->debtorInvoice == 'actionMain')
            {
                return redirect()->route('debtorInvoice.mainFollow');
            }
            return redirect()->route('client.debtor.invoice.show', [$invoice->client_id, $invoice->id]);
        }

        return redirect()->route('client.debtor.invoice.follow', [$invoice->client_id, $invoice->id]);
    }

    public function show($id) {

        return view('follows.show', compact('follow'));
    }

    public function detail($follow) {

        return view('follows.show', compact('follow'));
    }

    public function invoice($follow) {

        return view('follows.invoice', compact('follow'));
    }

    public function follow($follow) {


//         $follow = $this->follow;


        $follows = $follow->follows()->paginate(2);
        return view('follows.follow', compact('follow', 'follows'));
    }

    public function edit($client, $invoiceId, $id = '') {

        $follow = $this->follow->find($id);
        $invoice = $this->debtorInvoice->find($invoiceId);
        //  dd($follow);
        return view('clients.invoices.debtor.follows.edit', compact('follow', 'invoice', 'client'));
    }

    public function update(EditRequest $request, $client = '', $invoiceId = '', $id = '') {

        $follow = $this->follow->find($id);
        $follow->collection_action_code_id = $request->collection_action_code_id;
        $follow->latest_comment = $request->latest_comment;
        $follow->previous_comment = $request->previous_comment;
        $follow->next_follow_date = $request->next_follow_date;
        $follow->date = $request->date;

        $follow->save();
        $invoice = $this->debtorInvoice->find($invoiceId);

//        foreach($this->follow->where("debtor_invoice_id", $invoice->id)->where("collection_action_code_id", ">",  0)->orderBy('id', 'DESC')->get() as $kye => $followData)
//        {
//           if($kye == 0)
//           {
//              $invoice->last_action  = $followData->collectionActionCode->code;
//           }
//           if($kye == 1)
//           {
//               $invoice->action_1st_letter_code = $followData->collectionActionCode->code;
//           }
//           if($kye == 2)
//           {
//               $invoice->action_2nd_letter_code = $followData->collectionActionCode->code;
//           }
//           if($kye == 3)
//           {
//                $invoice->action_3rd_letter_code = $followData->collectionActionCode->code;
//           }
//
//
//
//
//        }
//
//        $invoice->save();
        return redirect()->route('client.debtor.invoice.follow', [$invoice->client_id, $invoice->id, $follow->id]);
    }

    public function model($id) {

        return $this->follow->find($id);
    }

    public function delete($client, $invoiceId, $id = '') {

        $invoice = $this->debtorInvoice->find($invoiceId);

        $follow = $this->follow->find($id);

        return view('clients.invoices.debtor.follows.delete', compact('follow', 'client', 'invoice'));
    }

    public function send($client, $invoiceId, $id) {

        $follow = $this->model($id);
        $invoice = $follow->debtorInvoice;
        if ($invoice->solicitor_id) {
            $closureData['fromMail'] = $user_id = Auth::user()->email;
            $closureData['subject'] = 'test';
            $data['content'] = '';
            $closureData['to'] = $invoice->solicitor->email;
            Mailsend::queue('emails.test', $data, function($message) use($closureData) {
                $message->to($closureData['to'])->subject($closureData['subject']);
                $message->from($closureData['fromMail']);
            });
        } else {

            Session::put('error', 'Please add the  solicitor');
        }

        return redirect()->route('client.debtor.invoice.follow', [$invoice->client_id, $invoice->id]);
    }

    public function destroy($client, $invoiceId, $id) {

        // dd(1);
        $invoice = $this->debtorInvoice->find($invoiceId);

        $follow = $this->follow->find($id);

        $follow->delete();

        return redirect()->route('client.debtor.invoice.follow', [$client->id, $invoiceId]);
    }

    public function mainFollowUp()
    {
        $debtorInvoices = $this->debtorInvoice;

        $debtor= '';

        if($this->request->has('debtor'))
        {
            $debtorsArray = array("0" => 0);
            $debtorsArray = $this->debtor->where('debtor_code', 'like', '%' . $this->request->debtor . '%')->pluck('id')->toArray();
           // dd($debtorsArray);
            $debtor = $this->request->debtor;
            $debtorInvoices = $debtorInvoices->whereIn('id', $debtorsArray);
        }

        $debtorInvoices = $debtorInvoices->where('fdl_state', '=', null )->orderBy('created_at', 'DESC')->paginate(20);


        return view('actions.index', compact('debtorInvoices', 'debtor'));
        dd($debtorInvoices);

    }

}
