<?php namespace App\Http\Controllers;
use Illuminate\Http\Request;
use Response;
use Validator;
use URL;
use Route;
use App\Models\GroupPortalUser;
use App\Models\Model;
use App\Models\Action;
use App\Models\Group;
use App\Http\Requests\Group\CreateRequest;


class GroupController extends Controller {
    protected $request;
    protected $group;
    public function __construct(Request $request ,Group $group) {
        $this->request = $request;
        $this->group=$group;
    }

    public function index() {

        $groups =$this->group;

        $groups = $groups->paginate(10);
        if ($this->request->has('search')) {




                return redirect()->route('client.index', ['search' => $this->request->search]);


            $search = $this->request->search;
        }
        return view('groups/index', compact('groups'));
    }

    public function create() {

        $this->updateModelActions();


        $models = Model::all();
        $actions = Action::all();

        return view('groups/create', compact( 'models', 'actions'));
    }

    public function store(CreateRequest $request) {
        $input = $this->request->all();
        $group_array = array();

        foreach ($input as $key => $value) {
            if (!($key == '_token' || $key == 'name' || $key == '_method')) {

                $key = str_replace('_', '.', $key);

                $group_array[$key] = 1;
            }
        }
//        dd($group_array);
//        exit;
        $group = $this->group;
         $name = $input['name'];
        $group->permissions = $group_array;
         $group->name = $name;
        $group->save();
        return redirect()->route('group.index');
    }

    private function updateModelActions() {
        $routeCollection = Route::getRoutes();
        $model_array = array();
        $action_array = array();
        $model_action = array();

        foreach ($routeCollection as $route) {
            $action_name = $route->getActionName();
            $at_pos = strpos($action_name, '@');
            if ($at_pos) {
                $model_name = class_basename(str_replace('Controller', '', substr($action_name, 0, $at_pos)));

if(!($model_name =='Auth' || $model_name =='Password') )
{

                $action_name = substr($action_name, $at_pos + 1);
                $model_array[] = $model_name;
                $action_array[] = $action_name;
                $model_action[$model_name][] = $action_name;
}
            }
            $model_array = array_values(array_unique($model_array));
            $action_array = array_values(array_unique($action_array));
        }


        Model::truncate();

        Action::truncate();

        foreach ($model_array as $model_name) {
            $model = new Model;
            $model->name = $model_name;
            $model->save();
        }

        foreach ($action_array as $action_name) {
            $action = new Action;
            $action->name = $action_name;
            $action->save();
        }

        foreach($model_action as $model_name => $action_array) {
            $model = Model::where('name', '=', $model_name)->first();
            $actions = Action::whereIn('name', $action_array)->pluck('id')->toArray();
            $model->actions()->sync($actions);
        }

    }

    public function edit($id) {

        $this->updateModelActions();

        $group = Group::find($id);
        $models = Model::all();
        $actions = Action::all();

        if (is_null($group)) {
            return redirect()->route('group.index');
        }
        return view('groups/edit', compact('group', 'models', 'actions'));
    }



    public function update($id) {
        $input = $this->request->all();
        $group_array = '';
        foreach ($input as $key => $value) {
            if (!($key == '_token' || $key == 'name' || $key == '_method')) {

                $key = str_replace('_', '.', $key);

                $group_array[$key] = 1;
            }
        }
//        dd($group_array);
//        exit;
        $group = Group::find($id);
        $group->permissions = $group_array;
        $group->save();
        return redirect()->route('group.index');
    }



}
