<?php

namespace App\Http\Controllers;

use App\Models\Debtor;
use App\Models\User;
use App\Models\Client;
use App\Models\Due;
use Illuminate\Http\Request;
use App\Models\OpeningBalance;

class HomeController extends Controller {

    protected $debtor;
    protected $client;
    protected $user;
    protected $request;
    protected $due;
    protected $openingBalance;

    public function __construct(User $user, Debtor $debtor, Client $client, Request $request, Due $due, OpeningBalance $openingBalance) {
        $this->user = $user;
        $this->debtor = $debtor;
        $this->client = $client;
        $this->request = $request;
        $this->openingBalance = $openingBalance;
        $this->due=$due;
        //$this->middleware('auth');
    }

    public function index() {
        $userCount = $this->user->count();
        $debtorCount = $this->debtor->count();
        $clientCount = $this->client->count();
        if ($this->request->has('search')) {
             $url = route('client.index');
            return redirect($url.'?search='.$this->request->search);
            // redirect()->route('profile', [1]);
        }
       // dd(1);
        $upcomingDues=$this->due->whereDate('due_date', '>=', date('Y-m-d'))->where('due_state', 'due')->paginate(100);
        $pendingDues=$this->due->whereDate('due_date', '<', date('Y-m-d'))->where('due_state', 'due')->paginate(100);

        $debtorCodeDuplcates = $this->debtor->where('debtor_code', '!=',  '')->groupBy('debtor_code')->orderBy('debtor_code', 'ASC')->havingRaw('COUNT(*) > 1')->get();



       // dd($dueUpcomings);
        return view('home.index', compact('userCount', 'debtorCount', 'clientCount', 'upcomingDues', 'pendingDues', 'debtorCodeDuplcates'));
    }

    public function openingBalanceStore($month, $year)
    {
       // dd($this->request);
         $all = $this->request->all();

//dd($all);

        foreach ($all as $key => $value) {
        if (strpos($key, 'date') !== false) {
            $keyId = str_replace('date', '', $key);
            $openingBalance= new OpeningBalance();
            $openingBalance->last_date_of_month = $all['date' . $keyId];
             $openingBalance->client_id = $all['client' . $keyId];
              $openingBalance->opening_amount_for_next_month = $all['amount' . $keyId];
            $openingBalance->save();
        }
        }
        return redirect()->route('fixed.report.show', [10,'filter'=>'filter', 'value'=> $month.'/'.$year]);
    }

}
