<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Redirect;
use Response;
use Input;
use File;
use App\Models\Mail;
use App\Models\Mail as Mailsend;
use App\Models\User;
use App\Models\Client;
use App\Models\Debtor;
use App\Models\Config;
use App\Models\DebtorInvoice;
use App\Models\MailField;
use App\Http\Requests\Mail\CreateRequest;

class IncomeMailController extends Controller {

    protected $request;
    protected $mail;
    protected $user;
    protected $debtor;
    protected $client;
    protected $debtorInvoice;
    protected $mailField;
    protected $toData = '';
    protected $ccData = '';
    protected $bccData = '';

    public function __construct(Request $request, Mail $mail, User $user, Debtor $debtor, Client $client, MailField $mailField, DebtorInvoice $debtorInvoice) {

        $this->request = $request;
        $this->mail = $mail;
        $this->user = $user;
        $this->debtor = $debtor;
        $this->client = $client;
        $this->mailField = $mailField;
        $this->debtorInvoice = $debtorInvoice;


        //$this->middleware('auth');
    }

    public function index($model = '', $model2 = '') {

        $mail = $this->mail;

        $path = explode('/', $this->request->path());
        $paginationSize = Config::find(1)->value;

        if ($path[0] == 'debtor') {
            $debtor = $model;
            $mailField = $this->mailField;
            $mails = $mailField->where('entity_id', $debtor->id)->where('entity', 'debtor')->paginate($paginationSize);
            return view('debtors.email', compact('mails', 'debtor'));
        }


        if ($path[0] == 'client') {
            $client = $model;
            $debtor = $model2;
            $mailField = $this->mailField;
            if ($path[2] == 'mail') {



                $mailArray = $mailField->where('entity_id', $client->id)->where('entity', 'client')->pluck('mail_id')->toArray();
                if (!$mailArray) {
                    $mailArray = array(0 => 0);
                }

                $mails = $this->mail->whereIn('id', $mailArray)->paginate($paginationSize);

                return view('clients.email', compact('mails', 'client'));

//                $mails = $mailField->where('entity_id', $client->id)->where('entity', 'client')->paginate($paginationSize);
//                return view('clients.email', compact('mails', 'client'));
            } else {

                $mailArray = $mailField->where('entity_id', $debtor->id)->where('entity', 'debtor')->pluck('mail_id')->toArray();

                if (!$mailArray) {
                    $mailArray = array(0 => 0);
                }

                $mails = $this->mail->whereIn('id', $mailArray)->paginate($paginationSize);
                return view('clients.debtors.email', compact('mails', 'client', 'debtor'));

//                $mails = $mailField->where('entity_id', $debtor->id)->where('entity', 'debtor')->paginate($paginationSize);
//                return view('clients.debtors.email', compact('mails', 'client', 'debtor'));
            }
        }



        $mails = $mail->orderBy('id', 'DESC')->paginate($paginationSize);

        return view('mails.index', compact('mails'));
    }

    public function create() {
        return view('mails.create');
    }

    public function send() {
        if ($this->request->ajax()) {

            $debtor = $this->debtor;
            $user = $this->user;
            $client = $this->client;
            if ($this->request->model == 'debtor') {

                if ($this->request->has('cId')) {

                    if ($this->request->has('dId')) {
                        return Response::json($debtor->where('id', $this->request->dId)->get());
                    }

                    $debtorsAraay = $this->debtorInvoice->where('client_id', $this->request->cId)->pluck('debtor_id')->toArray();
                    return Response::json($debtor->whereIn('id', $debtorsAraay)->where('name', 'LIKE', '%' . $this->request->term . '%')->get());
                }

                return Response::json($debtor->where('name', 'LIKE', '%' . $this->request->term . '%')->get());
            }
            if ($this->request->model == 'client') {

                if ($this->request->has('cId')) {
                    return Response::json($client->where('name', 'LIKE', '%' . $this->request->term . '%')->where('id', $this->request->cId)->get());
                }


                return Response::json($client->where('name', 'LIKE', '%' . $this->request->term . '%')->get());
            }
            if ($this->request->model == 'user') {

                return Response::json($user->where('last_name', 'LIKE', '%' . $this->request->term . '%')->get());
            }
        }
        return view('mails.send');
    }

    public function store(CreateRequest $request, $model = '', $model2 = '') {

        $request = $this->request;

        $fieldData = array();

        $mail = $this->mail;

        $mail->content = $request->content;
        if ($request->subject == '') {
            $request->subject = 'None subject';
        }
        $mail->subject = $request->subject;
        $mail->user_id = $request->user()->id;


        $mail->save();
        $closureData = array();
        $toDatas = explode(',', $request->to);
        $ccDatas = array();


        $bccDatas = array();

        $closureData['to'] = $this->dataField($toDatas, 'to', $mail->id);
        $closureData['cc'] = array();
        $closureData['bcc'] = array();
        if ($request->cc != '') {

            $ccDatas = explode(',', $request->cc);

            $closureData['cc'] = $this->dataField($ccDatas, 'cc', $mail->id);
        }

        if ($request->bcc != '') {
            $bccDatas = explode(',', $request->bcc);

            $closureData['bcc'] = $this->dataField($bccDatas, 'bcc', $mail->id);
        }
        $mail->cc = json_encode($closureData['cc']);
        $mail->bcc = json_encode($closureData['bcc']);
        $mail->to = json_encode($closureData['to']);




        $mail->save();

        //  $closureData['to'] = explode(',', $this->request->to);
        $closureData['subject'] = $request->subject;
        $data = array();

        $data['content'] = $request->content;


        $closureData['fromMail'] = $request->user()->email;


        Mailsend::queue('emails.test', $data, function($message) use($closureData) {
            $message->to($closureData['to'])->subject($closureData['subject']);
            $message->from($closureData['fromMail']);
            $message->cc($closureData['cc']);


            $message->bcc($closureData['bcc']);
        });

        $path = explode('/', $this->request->path());


        if ($path[0] == 'client') {
            $client = $model;
            $debtor = $model2;
            if ($path[2] == 'mail') {
                return redirect()->route('client.detail', [$client->id]);
            } else {
                return redirect()->route('client.debtor.show', [$client->id, $debtor->id]);
            }
        }
        if ($path[0] == 'debtor') {
            $debtor = $model;
            return redirect()->route('debtors.show', [$debtor->id]);
        }

        return redirect()->route('mail.send');
    }

    public function show($id) {
        if ($this->request->ajax()) {

            return Response::json($this->mail->find($id));
        }



        return view('mails.show', compact('mail'));
    }

    public function model($id) {

        return $this->mail->find($id);
    }

    public function dataField($datas = '', $field = '', $mialId = '') {
        $returnData = array();
        $this->toData = '';

        foreach ($datas as $data) {

            $dataArray = explode('&&', $data);
            $returnData[] = $dataArray[0];
//            if($field=='to')
//            {
//            $this->toData=$this->toData.' '.$dataArray[0];
//            }
//            if($field=='cc')
//            {
//            $this->ccData=$this->ccData.' '.$dataArray[0];
//            }
//            if($field=='bcc')
//            {
//            $this->bccData=$this->bccData.' '.$dataArray[0];
//            }
            $mailField = new MailField;
            $mailField->field = $field;
            $mailField->mail_id = $mialId;
            $mailField->entity = $dataArray[1];
            $mailField->entity_id = $dataArray[2];
            $mailField->save();
        }
        return $returnData;
    }


}


