<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Models\InvoiceStatusCode;
use Illuminate\Http\Request;
use Redirect;
use Response;
use Input;
use File;
use App\Http\Requests\InvoiceStatusCode\CreateRequest;
use App\Http\Requests\InvoiceStatusCode\EditRequest;

class InvoiceStatusCodeController extends Controller {

    protected $request;
    protected $invoiceStatusCode;

    public function __construct(Request $request, InvoiceStatusCode $invoiceStatusCode) {

        $this->request = $request;
        $this->invoiceStatusCode = $invoiceStatusCode;

        //$this->middleware('auth');
    }

    public function index() {

        $invoiceStatusCode = $this->invoiceStatusCode;

        //   $pagination = invoiceStatusCode('setting.pagination');;

         if ($this->request->ajax()) {

             $invoiceStatusCode = $invoiceStatusCode->where(function ($query) {
                $query->where('code', 'like', '%' . $this->request->term . '%');
//                        ->orWhere('description', 'like', '%' . $this->request->search . '%')
//                        ->orWhere('type', 'like', '%' . $this->request->search . '%');
            });

            return Response::json($invoiceStatusCode->get());
        }


         if ($this->request->has('search')) {

            $invoiceStatusCode = $invoiceStatusCode->where(function ($query) {
                $query->where('code', 'like', '%' . $this->request->search . '%')
                        ->orWhere('description', 'like', '%' . $this->request->search . '%');
            });

            $search=$this->request->search;
        }
        $search=$this->request->search;
 $invoiceStatusCodes = $invoiceStatusCode->paginate(20);
        return view('settings/invoiceStatusCodes.index', compact('invoiceStatusCodes', 'search'));
    }

    public function create() {
        return view('settings/invoiceStatusCodes.create');
    }

    public function store(CreateRequest $request) {

        $invoiceStatusCode = $this->invoiceStatusCode;

        $invoiceStatusCode->code = $request->code;
        $invoiceStatusCode->description = $request->description;
         $invoiceStatusCode->group = $request->group;





        $invoiceStatusCode->save();

        return redirect()->route('invoiceStatusCode.index');
    }

    public function show($id) {

        return view('settings/invoiceStatusCodes.show', compact('invoiceStatusCode'));
    }

    public function edit($invoiceStatusCode) {

        return view('settings/invoiceStatusCodes.edit', compact('invoiceStatusCode'));
    }

    public function update(EditRequest $request, $invoiceStatusCode) {


       $invoiceStatusCode->code = $request->code;
        $invoiceStatusCode->description = $request->description;
         $invoiceStatusCode->group = $request->group;



        $invoiceStatusCode->save();
        return redirect()->route('invoiceStatusCode.index');
    }

    public function model($id) {

        return $this->invoiceStatusCode->find($id);
    }

    public function delete($id) {

        $invoiceStatusCode = $this->model($id);



        return view('settings/invoiceStatusCodes.delete', compact('invoiceStatusCode'));
    }

    public function destroy($invoiceStatusCode) {

        $id = $invoiceStatusCode->id;


        $invoiceStatusCode->delete();

        return redirect()->route('invoiceStatusCode.index');
    }

}
