<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Response;
use Input;
use File;
use App\Models\Mail as MailModel;
use App\Models\User;
use App\Models\Client;
use App\Models\Debtor;
use App\Models\Config;
use App\Models\DebtorInvoice;
use App\Models\MailField;
use App\Http\Requests\Mail\CreateRequest;
use App\Models\IncomeMail;
use App\Services\ImapMailbox;
use Illuminate\Support\Facades\Auth;
use App;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Mail;
use App\Mail\SendMail;



class MailController extends Controller {

    protected $request;
    protected $mail;
    protected $user;
    protected $debtor;
    protected $client;
    protected $debtorInvoice;
    protected $mailField;
    protected $toData = '';
    protected $ccData = '';
    protected $bccData = '';
    protected $incomeMail;
    protected $loginUser;
    protected $connection;
    public $content;

    public function __construct(Request $request, Mail $mail, User $user, Debtor $debtor, Client $client, MailField $mailField, DebtorInvoice $debtorInvoice, IncomeMail $incomeMail, Auth $auth) {

        $this->request = $request;
        $this->mail = $mail;
        $this->user = $user;
        $this->debtor = $debtor;
        $this->client = $client;
        $this->mailField = $mailField;
        $this->debtorInvoice = $debtorInvoice;
        $this->incomeMail = $incomeMail;
        $this->loginUser = Auth::user();


        //$this->middleware('auth');
    }

    public function index($model = '', $model2 = '') {

        $mail = $this->mail;

        $path = explode('/', $this->request->path());
        $paginationSize = Config::find(1)->value;

        if ($path[0] == 'debtor') {
            $debtor = $model;
            $mailField = $this->mailField;
            $mails = $mailField->where('entity_id', $debtor->id)->where('entity', 'debtor')->paginate($paginationSize);
            return view('debtors.email', compact('mails', 'debtor'));
        }


        if ($path[0] == 'client') {
            $client = $model;
            $debtor = $model2;
            $mailField = $this->mailField;
            if ($path[2] == 'mail') {
                $mailArray = $mailField->where('entity_id', $client->id)->where('entity', 'client')->pluck('mail_id')->toArray();
                if (!$mailArray) {
                    $mailArray = array(0 => 0);
                }

                $mails = $this->mail->whereIn('id', $mailArray)->paginate($paginationSize);

                return view('clients.email', compact('mails', 'client'));
            } else {

                $mailArray = $mailField->where('entity_id', $debtor->id)->where('entity', 'debtor')->pluck('mail_id')->toArray();

                if (!$mailArray) {
                    $mailArray = array(0 => 0);
                }

                $mails = $this->mail->whereIn('id', $mailArray)->paginate($paginationSize);
                return view('clients.debtors.email', compact('mails', 'client', 'debtor'));
            }
        }

        $incomeMail = $this->incomeMail;

        $mails = $incomeMail->where('user_id', Auth::user()->id)->orderBy('id', 'DESC')->paginate($paginationSize);
        $this->incomeIndex();
        if ($this->request->has('search')) {




            return redirect()->route('client.index', ['search' => $this->request->search]);


            $search = $this->request->search;
        }
        return view('mails.index', compact('mails'));
    }

    public function create() {
        return view('mails.create');
    }

    public function send() {
        if ($this->request->ajax()) {

            $debtor = $this->debtor;
            $user = $this->user;
            $client = $this->client;
            if ($this->request->model == 'debtor') {

                if ($this->request->has('cId')) {

                    if ($this->request->has('dId')) {
                        return Response()->json($debtor->where('id', $this->request->dId)->get());
                    }

                    $debtorsAraay = $this->debtorInvoice->where('client_id', $this->request->cId)->pluck('debtor_id')->toArray();
                    return Response()->json($debtor->whereIn('id', $debtorsAraay)->where('name', 'LIKE', '%' . $this->request->term . '%')->get());
                }

                return Response()->json($debtor->where('name', 'LIKE', '%' . $this->request->term . '%')->get());
            }
            if ($this->request->model == 'client') {

                if ($this->request->has('cId')) {
                    return Response()->json($client->where('name', 'LIKE', '%' . $this->request->term . '%')->where('id', $this->request->cId)->get());
                }


                return Response()->json($client->where('name', 'LIKE', '%' . $this->request->term . '%')->get());
            }
            if ($this->request->model == 'user') {

                return Response()->json($user->where('last_name', 'LIKE', '%' . $this->request->term . '%')->get());
            }
        }
        return view('mails.send');
    }

    public function store(CreateRequest $request, $model = '', $model2 = '') {

        $request = $this->request;

        $fieldData = array();

        $mail = new MailModel();

        $mail->content = $request->input('content');
        if ($request->subject == '') {
            $request->subject = 'None subject';
        }
        $mail->subject = $request->subject;
        $mail->user_id = $request->user()->id;


        $mail->save();
        $closureData = array();
        $toDatas = explode(',', $request->to);
        $ccDatas = array();


        $bccDatas = array();

        $closureData['to'] = $this->dataField($toDatas, 'to', $mail->id);
        $closureData['cc'] = array();
        $closureData['bcc'] = array();
        if ($request->cc != '') {

            $ccDatas = explode(',', $request->cc);

            $closureData['cc'] = $this->dataField($ccDatas, 'cc', $mail->id);
        }

        if ($request->bcc != '') {
            $bccDatas = explode(',', $request->bcc);

            $closureData['bcc'] = $this->dataField($bccDatas, 'bcc', $mail->id);
        }
        $mail->cc = json_encode($closureData['cc']);
        $mail->bcc = json_encode($closureData['bcc']);
        $mail->to = json_encode($closureData['to']);




        $mail->save();

        //  $closureData['to'] = explode(',', $this->request->to);
        $closureData['subject'] = $request->subject;
        $data = array();

        $data['content'] = $request->input('content');


        $closureData['fromMail'] = $request->user()->office_mail;

        $validator = Validator::make(
            ['name' => $request->user()->office_mail], ['name' => 'required|email']
        );
        if ($validator->fails()) {
            // The given data did not pass validation
            $closureData['fromMail'] =$request->user()->email;
        }

//        Mail::queue('emails.test', $data, function($message) use($closureData) {
//            $message->to($closureData['to'])->subject($closureData['subject']);
//            $message->from($closureData['fromMail']);
//            $message->cc($closureData['cc']);
//
//
//            $message->bcc($closureData['bcc']);
//        });
$content = $this->request->input('content');
        Mail::to('tsuthesan1996@live.com')->queue(new SendMail($content,$closureData));

        $path = explode('/', $this->request->path());


        if ($path[0] == 'client') {
            $client = $model;
            $debtor = $model2;
            if ($path[2] == 'mail') {
                return redirect()->route('client.detail', [$client->id]);
            } else {
                return redirect()->route('client.debtor.show', [$client->id, $debtor->id]);
            }
        }
        if ($path[0] == 'debtor') {
            $debtor = $model;
            return redirect()->route('debtor.show', [$debtor->id]);
        }

        return redirect()->route('mail.send');
    }

    public function show($id) {
        if ($this->request->ajax()) {

            return Response()->json($this->mail->find($id));
        }


        $incomeMail = $this->incomeMail;

        $mail = $incomeMail->find($id);



        return view('mails.show', compact('mail'));
    }

    public function model($id) {

        return $this->mail->find($id);
    }

    public function dataField($datas = '', $field = '', $mailId = '', $mailType = '') {
        $returnData = array();
        $this->toData = '';

        foreach ($datas as $data) {

            $dataArray = explode('&&', $data);
            $returnData[] = $dataArray[0];
            if ($mailType == '') {
                $mailField = new MailField;
                $mailField->field = $field;
                $mailField->mail_id = $mailId;
                $mailField->entity = $dataArray[1];
                $mailField->entity_id = $dataArray[2];
                $mailField->save();
            }
        }
        return $returnData;
    }

    public function incomeIndex() {



        $email = Auth::user()->office_mail;
        $password = Auth::user()->mail_password;
        $mail_imap = Auth::user()->mail_imap;
        $mailbox = new ImapMailbox($mail_imap, $email, $password, 'data', 'utf-8');

        $imapStream_error = @imap_open($mail_imap, $email, $password);
        //dd(imap_last_error());
        $result = 'ok';


        if (!$imapStream_error) {
            //  $request->session()->flash('error', "Your mail setting is wrong . check profile");
            Session::put('error', 'Your mail setting is wrong  <a href="'. route('profile.edit', [Auth::user()->id]) .'" class="btn btn-default btn-flat">Profile</a>');
            return 1;
        }
        $invoiceDirForUser = 'data';
        if (!File::isDirectory($invoiceDirForUser) and $invoiceDirForUser)
            @File::makeDirectory($invoiceDirForUser);

        $mailbox = new ImapMailbox($mail_imap, $email, $password, $invoiceDirForUser, 'utf-8');
        $mailsIds = $mailbox->searchMailBox('ALL');

        foreach ($mailsIds as $mailId) {
            $count = $this->incomeMail->where('mail_id', $mailId)->where('user_id', $this->loginUser->id)->count();
            if ($count < 1) {
                $mail = $mailbox->getMail($mailId, $invoiceDirForUser . '/' . $mailId);


                $incomeMail = new IncomeMail;
                $incomeMail->user_id = $this->loginUser->id;
                $incomeMail->mail_id = $mailId;
                $incomeMail->mail_type = 'inbox';
                $incomeMail->from_mail = $mail->fromAddress;
                $incomeMail->subject = $mail->subject;
                $incomeMail->content = $mail->textHtml;
                $incomeMail->mail_time = $mail->date;
                $incomeMail->save();
            }
        }
    }

    public function forward33($id) {
        $incomeMail = $this->incomeMail;

        $mail = $incomeMail->find($id);

        $content = $this->Message_Parse($id);

        return view('mails.show', compact('mail', 'content'));
    }

    public function forward(CreateRequest $request, $id) {
        $email = $this->loginUser->office_mail;
        $password = $this->loginUser->mail_password;
        $mail_imap = $this->loginUser->mail_imap;
        $this->connection = imap_open($mail_imap, $email, $password) or die('Cannot connect to mail: ' . imap_last_error());
        $mail_id = $this->incomeMail->find($id)->mail_id;
        $dataReturn = $this->Message_Parse($mail_id);
        $toDatas = explode(',', $request->to);
        $ccDatas = explode(',', $request->cc);
        $bccDatas = explode(',', $request->bcc);
        $closureData['to'] = $this->dataField($toDatas, 'to', $mail_id, 'forward');
        $closureData['cc'] = array();
        $closureData['bcc'] = array();
        if ($request->cc != '') {



            $closureData['cc'] = $this->dataField($ccDatas, 'cc', $mail_id, 'forward');
        }

        if ($request->bcc != '') {


            $closureData['bcc'] = $this->dataField($bccDatas, 'bcc', $mail_id, 'forward');
        }
        $closureData['fromMail'] = 'ravi@radus28.com';
        $closureData['subject'] = 'test';
        $closureData['emailTemplate'] = 'emails.forward';
        $data['content'] = nl2br($dataReturn['text']);
        $this->sendMail($closureData, $data);

        return redirect()->route('mail.show', [$id]);
    }

    public function reply(CreateRequest $request, $id) {
        $email = Auth::user()->office_mail;
        $password = Auth::user()->mail_password;
        $mail_imap = Auth::user()->mail_imap;
        $this->connection = imap_open($mail_imap, $email, $password) or die('Cannot connect to mail: ' . imap_last_error());
        $mail_id = $this->incomeMail->find($id)->mail_id;
        $dataReturn = $this->Message_Parse($mail_id);
        $toDatas = explode(',', $request->to);
        $ccDatas = explode(',', $request->cc);
        $bccDatas = explode(',', $request->bcc);
        $closureData['to'] = $this->dataField($toDatas, 'to', $mail_id, 'forward');
        $closureData['cc'] = array();
        $closureData['bcc'] = array();
        if ($request->cc != '') {



            $closureData['cc'] = $this->dataField($ccDatas, 'cc', $mail_id, 'forward');
        }

        if ($request->bcc != '') {


            $closureData['bcc'] = $this->dataField($bccDatas, 'bcc', $mail_id, 'forward');
        }
        $closureData['fromMail'] = 'ravi@radus28.com';
        $closureData['subject'] = 'test';
        $closureData['emailTemplate'] = 'emails.reply';
        $data['contentOld'] = nl2br($dataReturn['text']);
//        $pdf = App::make('dompdf'); //Note: in 0.6.x this will be 'dompdf.wrapper'
//        $pdf->loadHTML($dataReturn['text']);
//        return $pdf->stream();
        $data['content'] = $request->input('content');
        $this->sendMail($closureData, $data);

        return redirect()->route('mail.show', [$id]);
    }

    public function printEmail(CreateRequest $request, $id) {
        $email = $this->loginUser->office_mail;
        $password = $this->loginUser->mail_password;
        $mail_imap = $this->loginUser->mail_imap;
        $this->connection = imap_open($mail_imap, $email, $password) or die('Cannot connect to mail: ' . imap_last_error());
        $mail_id = $this->incomeMail->find($id)->mail_id;
        $dataReturn = $this->Message_Parse($mail_id);
        // dd($dataReturn);
        $pdf = App::make('dompdf'); //Note: in 0.6.x this will be 'dompdf.wrapper'
        $pdf->loadHTML(nl2br($dataReturn['text']));
        return $pdf->stream();
    }

    function Message_Parse($id) {
        if (is_resource($this->connection)) {
            $result = array
            (
                'text' => null,
                'html' => null,
                'attachments' => array(),
            );

            $structure = imap_fetchstructure($this->connection, $id, FT_UID);

            if (array_key_exists('parts', $structure)) {
                foreach ($structure->parts as $key => $part) {
                    if (($part->type >= 2) || (($part->ifdisposition == 1) && ($part->disposition == 'ATTACHMENT'))) {
                        $filename = null;

                        if ($part->ifparameters == 1) {
                            $total_parameters = count($part->parameters);

                            for ($i = 0; $i < $total_parameters; $i++) {
                                if (($part->parameters[$i]->attribute == 'NAME') || ($part->parameters[$i]->attribute == 'FILENAME')) {
                                    $filename = $part->parameters[$i]->value;

                                    break;
                                }
                            }

                            if (is_null($filename)) {
                                if ($part->ifdparameters == 1) {
                                    $total_dparameters = count($part->dparameters);

                                    for ($i = 0; $i < $total_dparameters; $i++) {
                                        if (($part->dparameters[$i]->attribute == 'NAME') || ($part->dparameters[$i]->attribute == 'FILENAME')) {
                                            $filename = $part->dparameters[$i]->value;

                                            break;
                                        }
                                    }
                                }
                            }
                        }

                        $result['attachments'][] = array
                        (
                            'filename' => $filename,
                            'content' => str_replace(array("\r", "\n"), '', trim(imap_fetchbody($this->connection, $id, ($key + 1), FT_UID))),
                        );
                    } else {
                        if ($part->subtype == 'PLAIN') {
                            $result['text'] = imap_fetchbody($this->connection, $id, ($key + 1), FT_UID);
                        } else if ($part->subtype == 'HTML') {
                            $result['html'] = imap_fetchbody($this->connection, $id, ($key + 1), FT_UID);
                        } else {
                            foreach ($part->parts as $alternative_key => $alternative_part) {
                                if ($alternative_part->subtype == 'PLAIN') {
                                    echo '<h2>' . $alternative_part->subtype . ' ' . $alternative_part->encoding . '</h2>';

                                    $result['text'] = imap_fetchbody($this->connection, $id, ($key + 1) . '.' . ($alternative_key + 1), FT_UID);
                                } else if ($alternative_part->subtype == 'HTML') {
                                    echo '<h2>' . $alternative_part->subtype . ' ' . $alternative_part->encoding . '</h2>';

                                    $result['html'] = imap_fetchbody($this->connection, $id, ($key + 1) . '.' . ($alternative_key + 1), FT_UID);
                                }
                            }
                        }
                    }
                }
            } else {
                $result['text'] = imap_body($this->connection, $id, FT_UID);
            }

            $result['text'] = imap_qprint($result['text']);
            $result['html'] = imap_qprint(imap_8bit($result['html']));

            return $result;
        }




        return false;
    }

    public function sendMail($closureData, $data) {
        $emailTemplate = 'emails.test';
        Mail::queue($closureData['emailTemplate'], $data, function($message) use($closureData) {
            $message->to($closureData['to'])->subject($closureData['subject']);
            // $message->from($closureData['fromMail']);
            $message->cc($closureData['cc']);


            $message->bcc($closureData['bcc']);
            $message->content($closureData['content']);
        });
    }

}

