<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Redirect;
use Response;
use Input;
use File;
use App\Models\Client;
use App\Models\Debtor;
use App\Models\Config;
use App\Models\Note;
use App\Models\User;
use App\Models\ClientInvoice;
use App\Models\DebtorInvoice;
use App\Http\Requests\Client\CreateRequest;
use App\Http\Requests\Client\EditRequest;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;


class NoteController extends Controller {

    protected $request;
    protected $client;
    protected $config;
    protected $paginationSize;
    protected $user;
    protected $notes;
    protected $loginUser;
    protected $debtorInvoice;

    public function __construct(Request $request, Client $client, Config $config, User $user, Note $note, DebtorInvoice $debtorInvoice) {

        $this->request = $request;
        $this->client = $client;
        $this->config = $config;
        $this->user = $user;
        $this->paginationSize = $config->find(1)->value;
        $this->notes = $note;
        $this->loginUser = \Auth::user();
        $this->debtorInvoice = $debtorInvoice;
        //$this->middleware('auth');
    }

    public function create() {
        return view('clients.create');
    }

    public function store($client, $debtor = '') {
        $path = explode('/', $this->request->path());
        $request = $this->request;
        $notes = $this->notes;
        $notes->note = $request->contents;
        if ($path[0] == 'client' && $path[2] == 'note') {
            $notes->client_id = $client->id;
        }
        if ($path[0] == 'client' && $path[2] == 'debtor' && $path[4] == 'note') {
            $notes->debtor_id = $debtor->id;
        }

        if (isset($path[3])) {
            if ($path[0] == 'client' && $path[3] == 'invoice') {
                $notes->debtor_invoice_id = $debtor;
            }
        }

        if ($path[0] == 'debtor') {
            $notes->debtor_id = $client->id;
            $debtor = $client;
            $client = $this->client;
        }
        $notes->user_name = Auth::user()->first_name . ' ' . Auth::user()->last_name;
        $notes->save();
        if (isset($path[3])) {
            if ($path[0] == 'client' && $path[3] == 'invoice') {
                $notes = DB::table('notes')->where('debtor_invoice_id', $debtor)->orderBy('created_at', 'DESC')->paginate($this->paginationSize);
                $notes->setPath('show');
                $invoice = $this->debtorInvoice->find($debtor);
                return   redirect()->route('client.debtor.invoice.show', [$client->id, $debtor]);
                return view('clients.invoices.debtor.show', compact('client', 'notes', 'invoice'));
            }
        }
        if ($path[0] == 'client' && $path[2] == 'note') {
            $notes = DB::table('notes')->where('client_id', $client->id)->orderBy('created_at', 'DESC')->paginate($this->paginationSize);
            $calendars = DB::table('calendars')->where('client_id', $client->id)->where('type', 'call')->orderBy('id', 'DESC')->paginate($this->paginationSize);
            $call = view('calendars.result', compact('calendars'));
            $calendars = DB::table('calendars')->where('client_id', $client->id)->where('type', 'todo')->orderBy('id', 'DESC')->paginate($this->paginationSize);
            $todo = view('calendars.result', compact('calendars'));
            $notes->setPath('detail');
            return view('clients.show', compact('client', 'notes','call','todo'));
        }
        if ($path[0] == 'client' && $path[2] == 'debtor') {
            $notes = DB::table('notes')->where('debtor_id', $debtor->id)->orderBy('created_at', 'DESC')->paginate($this->paginationSize);
            $calendars = DB::table('calendars')->where('debtor_id', $debtor->id)->where('type', 'call')->orderBy('id', 'DESC')->paginate($this->paginationSize);
            $call = view('calendars.result', compact('calendars'));
            $calendars = DB::table('calendars')->where('debtor_id', $debtor->id)->where('type', 'todo')->orderBy('id', 'DESC')->paginate($this->paginationSize);
            $todo = view('calendars.result', compact('calendars'));
            $notes->setPath('detail');


            return view('clients.debtors.show', compact('client', 'debtor', 'notes','call','todo'));
        }

        if ($path[0] == 'debtor') {
            $notes = DB::table('notes')->where('debtor_id', $debtor->id)->orderBy('created_at', 'DESC')->paginate($this->paginationSize);
            $calendars = DB::table('calendars')->where('debtor_id', $debtor->id)->where('type', 'call')->orderBy('id', 'DESC')->paginate($this->paginationSize);
            $call = view('calendars.result', compact('calendars'));
            $calendars = DB::table('calendars')->where('debtor_id', $debtor->id)->where('type', 'todo')->orderBy('id', 'DESC')->paginate($this->paginationSize);
            $todo = view('calendars.result', compact('calendars'));
//            $notes->setPath('detail');
            return view('debtors.show', compact('debtor', 'notes','call', 'todo','client'));
        }
    }

}
