<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Redirect;
use Response;
use Input;
use File;
use App\Models\Solicitor;
use App\Models\PaymentAdjustment;
use App\Http\Requests\PaymentAdjustment\CreateRequest;
use App\Http\Requests\PaymentAdjustment\EditRequest;

class PaymentAdjustmentController extends Controller {

    protected $request;
    protected $solicitor;
    protected $paymentAdjustment;

    public function __construct(Request $request, Solicitor $solicitor, PaymentAdjustment $paymentAdjustment) {

        $this->request = $request;
        $this->solicitor = $solicitor;
        $this->paymentAdjustment = $paymentAdjustment;

        //$this->middleware('auth');
    }

    public function index($client) {
        //dd($client->paymentAdjustments);
        $paymentAdjustments = $client->paymentAdjustments;

// $paymentAdjustments = $paymentAdjustments->paginate(20);
// dd($paymentAdjustments);
        return view('clients.paymentAdjustments.index', compact('paymentAdjustments', 'client'));
    }

    public function create() {
        return view('solicitors.create');
    }

    public function store(CreateRequest $request, $client) {
       // dd($request);
        $paymentAdjustment = $this->paymentAdjustment;

         $paymentAdjustment->adjustment_type = $request->adjustment_type;
          $paymentAdjustment->adjustment_date = $request->adjustment_date;
        $paymentAdjustment->amount = $request->amount;
        $paymentAdjustment->description = $request->description;
         $paymentAdjustment->client_id = $client->id;



          $paymentAdjustment->save();

        return redirect()->route('client.paymentAdjustment.index', [$client->id]);
    }

    public function show($id) {

        return view('solicitors.show', compact('solicitor'));
    }

    public function edit($solicitor) {

        return view('solicitors.edit', compact('solicitor'));
    }

    public function update(EditRequest $request, $solicitor) {



        $solicitor->name = $request->name;
        $solicitor->email = $request->email;

        $solicitor->save();
        return redirect()->route('solicitor.index');
    }

    public function model($id) {

        return $this->solicitor->find($id);
    }

    public function delete($solicitor) {
        $id = $solicitor->id;



        return view('solicitors.delete', compact('solicitor'));
    }

    public function destroy($solicitor) {

        $id = $solicitor->id;


        $solicitor->delete();

        return redirect()->route('solicitor.index');
    }

}
