<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Redirect;
use App\Models\Mail as Mailsend;
use App\Models\Payment;
use App\Models\Config;
use Illuminate\Support\Facades\Auth;
use App\Models\DebtorInvoice;
use App\Models\Due;
use App\Models\Debtor;
use App\Models\InvoiceFollow;
use App\Http\Requests\Payment\CreateRequest;
use App\Http\Requests\Payment\EditRequest;
use Illuminate\Support\Facades\Session;

class PaymentController extends Controller
{
    protected $request;
    protected $payment;
    protected $config;
    protected $debtorInvoice;
    protected $due;
    protected $debtor;
    protected $invoiceFollow;

    public function __construct(Request $request, Payment $payment, Config $config, DebtorInvoice $debtorInvoice, Due $due, Debtor $debot, InvoiceFollow $invoiceFollow)
    {
        $this->request = $request;
        $this->payment = $payment;
        $this->config = $config;
        $this->debtorInvoice = $debtorInvoice;
        $this->due = $due;
        $this->debtor = $debot;
        $this->invoiceFollow = $invoiceFollow;
        //$this->middleware('auth');
    }

    public function index($model = '', $invoiceId = '')
    {
        $path = explode('/', $this->request->path());
        $paginationSize = Config::find(1)->value;
        $payment = $this->payment;
        if ($path[0] == 'payment') {
            $payments = $payment->paginate($paginationSize);

            return view('payments.index', compact('payments'));
        }
        if ($path[0] == 'debtor') {
            $debtor = $model;
        } else {
            $client = $model;
        }

        $payments = $payment->where('debtor_invoice_id', $invoiceId)->orderBy('id', 'DESC')->paginate($paginationSize);
        $invoice = $this->debtorInvoice->find($invoiceId);

        if ($path[0] == 'debtor') {
            return view('debtors.payments.index', compact('payments', 'invoice', 'client'));
        }
        // return view('pdfs/paymentPdf');
//        $pdf = \App::make('dompdf.wrapper');
//
//        $debtor = $this->debtor->find($invoice->debtor_id);
//
//
//        $pdf->loadView('pdfs/paymentPdf', compact('payments', 'invoice', 'client', 'debtor'));
//        return $pdf->stream();

        return view('clients.invoices.debtor.payments.index', compact('payments', 'invoice', 'client'));
    }

    public function create($client, $invoiceId)
    {
        $invoice = $this->debtorInvoice->find($invoiceId);
//        echo '<pre>';var_dump($client);exit;
        return view('clients.invoices.debtor.payments.create', compact('invoice', 'client'));
    }

    public function store(CreateRequest $request, $client = '', $invoiceId = '')
    {
        $dues = $this->due->where('debtor_invoice_id', $invoiceId)->orderBy('due_date', 'asc')->get();
        // dd($dues);
        $totalPaymenAmount = $request->amount;
        foreach ($dues as $keyDue => $dueValue) {
            if ($totalPaymenAmount > 0) {
                $balancePaymenAmount = (float) $totalPaymenAmount - (float) $dueValue->balance;

                if ($balancePaymenAmount > 0) {
                    $dueValue->balance = 0;
                    $dueValue->due_state = 'paid';
                } else {
                    $dueValue->balance = (float) $dueValue->balance - (float) $totalPaymenAmount;
                }
            }
            $totalPaymenAmount = $balancePaymenAmount;
            $dueValue->save();
        }
        $payment = $this->payment;
        $path = explode('/', $this->request->path());
        $payment->payment_state = 'paid';
//        if ($path[0] == 'payment') {
//            $invoiceId = $request->debtor_invoice_id;
//            $payment->payment_state = 'pay';
//        }
//
//        if ($payment->payment_state == 'due') {
//            $payment->payment_date = $request->payment_date;
//        }
        // if ($payment->payment_state == 'pay') {
        if ($request->paid_place == 'Paid to CTC') {
            $payment->payment_type = $request->payment_type;
        }

        $payment->payment_date = $request->payment_date;
        if ($request->payment_type == 'cheque') {
            $payment->bank = $request->bank;
            $payment->branch = $request->branch;
            $payment->drawer = $request->drawer;

            $payment->cheque_no = $request->cheque_no;
            $payment->paid_date = $request->paid_date;
        }

        if ($request->payment_type == 'credit card' || $request->payment_type == 'debit card') {
            $payment->name_on_card = $request->name_on_card;
            $payment->card_number = $request->card_number;
            $payment->card_expiry_month = $request->card_expiry_month;

            $payment->card_expiry_year = $request->card_expiry_year;
            $payment->receipt_number = $request->receipt_number;
        }
        //  }
        $payment->amount = $request->amount;
        $payment->trans_description = $request->paid_place;
        $payment->paid_place = $request->paid_place;
        $invoice = $this->debtorInvoice->find($invoiceId);
        $payment->client_id = $invoice->client_id;
        $payment->debtor_id = $invoice->debtor_id;
        //  if ($payment->payment_state == 'pay') {
        $invoice->last_payment = $request->amount;
        $invoice->last_paid = $request->payment_date;
        $invoice->current_balance = (float) $invoice->current_balance - (float) $request->amount;
        $invoice->total_paid = (float) $invoice->total_paid + (float) $request->amount;
        // }
        $payment->commission = $request->commission;
        $payment->debtor_invoice_id = $invoice->id;
        $invoice->save();
        $payment->save();
        if ($invoice->current_balance <= 0) {
            foreach ($this->invoiceFollow->where('debtor_invoice_id', '=', $invoice->id)->where('status', '=', 'todo')->get() as $invoiceFollow) {
                $invoiceFollow->status = 'cancel';
                $invoiceFollow->save();
            }
            $invoice->invoice_status_code_id = 18;
            $invoice->save();
        }

        if ($this->request->has('mainPayment')) {
            return redirect()->route('debtorInvoice.mainPayment');
        }

        return redirect()->route('client.debtor.invoice.payment', [$invoice->client_id, $invoice->id]);
    }

    public function show($id)
    {
        return view('payments.show', compact('payment'));
    }

    public function detail($payment)
    {
        return view('payments.show', compact('payment'));
    }

    public function invoice($payment)
    {
        return view('payments.invoice', compact('payment'));
    }

    public function payment($payment)
    {
//         $payment = $this->payment;

        $payments = $payment->payments()->paginate(2);

        return view('payments.payment', compact('payment', 'payments'));
    }

    public function edit($client, $invoiceId, $id = '')
    {
        $path = explode('/', $this->request->path());
        if ($path[0] == 'payment') {
            $payment = $this->model($invoiceId);
            $invoice = $payment->debtorInvoice;

            return view('payments.edit', compact('payment', 'invoice'));
        }
        $payment = $this->model($id);
        $invoice = $payment->debtorInvoice;

        return view('clients.invoices.debtor.payments.edit', compact('payment', 'invoice', 'client'));
    }

    public function update(EditRequest $request, $client = '', $invoiceId = '', $id = '')
    {
        $path = explode('/', $this->request->path());

        //--------------------------------------

        $dues = $this->due->where('debtor_invoice_id', $invoiceId)->orderBy('due_date', 'asc')->get();
        // dd($dues);
        $payment = $this->payment->find($id);
        if ($request->amount != $payment->amount) {
            $totalPaymenAmount = (float) $request->amount - (float) $payment->amount;
            foreach ($dues as $keyDue => $dueValue) {
                if ($totalPaymenAmount > 0) {
                    $balancePaymenAmount = (float) $totalPaymenAmount - (float) $dueValue->balance;

                    if ($balancePaymenAmount > 0) {
                        $dueValue->balance = 0;
                        $dueValue->due_state = 'paid';
                    } else {
                        $dueValue->balance = (float) $dueValue->balance - (float) $totalPaymenAmount;
                    }
                    $totalPaymenAmount = $balancePaymenAmount;
                    $dueValue->save();
                }
            }
        }
        $path = explode('/', $this->request->path());
        $payment->payment_state = 'paid';
//        if ($path[0] == 'payment') {
//            $invoiceId = $request->debtor_invoice_id;
//            $payment->payment_state = 'pay';
//        }
//
//        if ($payment->payment_state == 'due') {
//            $payment->payment_date = $request->payment_date;
//        }
        // if ($payment->payment_state == 'pay') {
        $payment->payment_type = $request->payment_type;

        $payment->payment_date = $request->payment_date;
        if ($request->payment_type == 'cheque') {
            $payment->bank = $request->bank;
            $payment->branch = $request->branch;
            $payment->drawer = $request->drawer;

            $payment->cheque_no = $request->cheque_no;
            $payment->paid_date = $request->paid_date;
        }
        //  }

        if ($request->payment_type == 'credit card' || $request->payment_type == 'debit card') {
            $payment->name_on_card = $request->name_on_card;
            $payment->card_number = $request->card_number;
            $payment->card_expiry_month = $request->card_expiry_month;

            $payment->card_expiry_year = $request->card_expiry_year;
            $payment->receipt_number = $request->receipt_number;
        }

        $payment->trans_description = $request->paid_place;
        $payment->paid_place = $request->paid_place;
        $invoice = $this->debtorInvoice->find($invoiceId);
        $payment->client_id = $invoice->client_id;
        $payment->debtor_id = $invoice->debtor_id;
        //  if ($payment->payment_state == 'pay') {
        $invoice->last_payment = $request->amount;

        $invoice->current_balance = ((float) $invoice->current_balance + (float) $payment->amount) - (float) $request->amount;
        $invoice->total_paid = ((float) $invoice->total_paid + (float) $request->amount) - (float) $payment->amount;

        // }
        $payment->amount = $request->amount;
        $payment->commission = number_format($request->amount / 100 * $invoice->client->commission, 2);
        $payment->debtor_invoice_id = $invoice->id;
        $invoice->save();
        $payment->save();

        if ($path[0] == 'payment') {
            return redirect()->route('payment.index');
        }

        return redirect()->route('client.debtor.invoice.payment', [$invoice->client_id, $invoice->id]);
    }

    public function model($id)
    {
        return $this->payment->find($id);
    }

    public function delete($payment)
    {
        $id = $payment->id;

        return view('payments.delete', compact('payment'));
    }

    public function send($client, $invoiceId, $id)
    {
        $payment = $this->model($id);
        $invoice = $payment->debtorInvoice;
        if ($invoice->solicitor_id) {
            $closureData['fromMail'] = $user_id = Auth::user()->email;
            $closureData['subject'] = 'test';
            $data['content'] = '';
            $closureData['to'] = $invoice->solicitor->email;
            Mailsend::queue('emails.test', $data, function ($message) use ($closureData) {
                $message->to($closureData['to'])->subject($closureData['subject']);
                $message->from($closureData['fromMail']);
            });
        } else {
            Session::put('error', 'Please add the  solicitor');
        }

        return redirect()->route('client.debtor.invoice.payment', [$invoice->client_id, $invoice->id]);
    }

    public function destroy($payment)
    {
        $id = $payment->id;

        $payment->delete();

        return redirect()->route('payment.index');
    }

    public function paymentPdfHtml()
    {
    }

    public function mainPayment()
    {
        $invoice = $this->debtorInvoice->orderBy('created_at', 'desc')->first();
        $debtorInvoice = 'yes';
        if ($this->request->has('id')) {
            $invoice = $this->debtorInvoice->where('debtor_id', $this->request->id)->first();

//            if (!count($invoice)) {
//                $debtorInvoice = 'no';
//            }
            if ($invoice === null) {
                $debtorInvoice = 'no';
            }
        }
        $debtorInvoices = [];
        $current_balance = '';
        if ($this->request->has('current_balance')) {
            $current_balance = $this->request->current_balance;
            $debtorInvoices = $this->debtorInvoice->where('current_balance', $current_balance)->orderBy('created_at', 'desc')->get();
        }

        $amount = '';

        if ($this->request->has('amount')) {
            $payments = $this->payment->orderBy('id', 'desc')->paginate(20);
            $payments = $this->payment->where(function ($query) {
                $query->where('amount', '=', $this->request->amount);
            })->orderBy('id', 'desc')->paginate(20);
            $amount = $this->request->amount;

            return view('payments.index', compact('payments', 'invoice', 'debtorInvoice', 'amount', 'debtorInvoices', 'current_balance'));
        }

        $payments = $this->payment->orderBy('id', 'desc')->paginate(20);

        return view('payments.index', compact('payments', 'invoice', 'debtorInvoice', 'amount', 'debtorInvoices', 'current_balance'));
    }
}
