<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Redirect;
use Response;
use Input;
use File;
use Hash;
use App\Models\User;
use App\Models\Config;
use App\Models\Group;
use App\Services\ImapMailbox;
use App\Http\Requests\Profile\EditRequest;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;

class ProfileController extends Controller {

    protected $request;
    protected $user;
    protected $config;
    protected $group;

    public function __construct(Request $request, User $user, Config $config, Group $group) {

        $this->request = $request;
        $this->user = $user;
        $this->config = $config;
        $this->group = $group;
        //$this->middleware('auth');
    }

    public function edit($id) {
        $user_id = Auth::user()->id;
        if ($user_id != $id) {

            return redirect()->route('home.index');
        }
        $user = $this->model($id);


        return view('users.profile', compact('user'));
    }

    public function update(EditRequest $request, $id) {
        $user_id = Auth::user()->id;
        if ($user_id != $id) {

            return redirect()->route('home.index');
        }

        $user = $this->model($id);

        $user->first_name = $request->first_name;
        $user->last_name = $request->last_name;
        $user->office_mail = $request->office_mail;
        $user->mail_password = $request->mail_password;
        $user->mail_imap = $request->mail_imap;
        if($request->password != '')
        {
         $user->password = Hash::make($request->password);
        }
        $user->save();
     /**   $mail_imap = $request->mail_imap;
        $email = $request->office_mail;
        $mail_password = $request->mail_password;
        $imapStream_error = @imap_open($mail_imap, $email, $password);
        $result = 'ok';
        dd($imapStream_error);
        if (!$imapStream_error) {
            $request->session()->flash('success', "Your email connection success");
        } else {
            $request->session()->flash('warning', "Your email connection fail ");
        }
      *
      */
        return redirect()->route('profile.edit', [$id]);
    }

    public function model($id) {

        return $this->user->find($id);
    }

}
