<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Redirect;
use Response;
use Input;
use File;
use App\Models\Report;
use App\Models\Client;
use App\Models\Debtor;
use App\Models\Condition;
use App\Models\Payment;
use App\Models\DebtorInvoice;
use App\Http\Requests\Report\CreateRequest;
use App\Http\Requests\Report\EditRequest;
use Maatwebsite\Excel\Facades\Excel;

class ReportController extends Controller {

    protected $request;
    protected $report;
    protected $condition;
    protected $client;
    protected $debtor;
    protected $modelOb = array();

    public function __construct(Request $request, Report $report, Client $client, Debtor $debtor, Condition $condition, Payment $payment, DebtorInvoice $debtorInvoice) {

        $this->request = $request;
        $this->report = $report;
        $this->condition = $condition;
        $this->client = $client;
        $this->debtor = $client;
        $this->modelOb['Client'] = $client;
        $this->modelOb['Debtor'] = $debtor;
        $this->modelOb['Payment'] = $payment;
        $this->modelOb['DebtorInvoice'] = $debtorInvoice;
        $this->modelOb['Payment'] = $payment;
        $this->modelOb['Payment'] = $payment;


        //$this->middleware('auth');
    }

    public function index() {

        $report = $this->report;

        //   $pagination = report('setting.pagination');;

        if ($this->request->ajax()) {


            return Response::json($report->get());
        }

        $reports = $report->paginate(20);
        if ($this->request->has('search')) {




                return redirect()->route('client.index', ['search' => $this->request->search]);


            $search = $this->request->search;
        }

        return view('reports.index', compact('reports'));
    }

    public function create() {
        return view('reports.create');
    }

    public function store(CreateRequest $request) {


        $report = $this->report;

        $report->name = $request->name;

        $report->model_id = $request->model_id;


        $report->save();
        // dd(explode(',', $request->field_id));
        $report->fields()->attach(explode(',', $request->field_id));


        $all = $request->all();

//dd($all);

        foreach ($all as $key => $value) {


            if (strpos($key, 'condition_id_') !== false) {
                $keyId = str_replace('condition_id_', '', $key);
                if ($all['field_id_' . $keyId] != "" && $all['condition_id_' . $keyId] != "") {
                    $condition = new Condition();
                    $condition->report_id = $report->id;
                    $condition->field_id = $all['field_id_' . $keyId];
                    $condition->operator_id = $all['condition_id_' . $keyId];
                    $condition->type = $all['condition_type_' . $keyId];
                    if ($this->request->has('condition_value_' . $keyId)) {
                        $condition->value = $all['condition_value_' . $keyId];
                    }

                    $condition->save();
                }
            }
        }


        return redirect()->route('report.index');
    }

    public function conditionAnd($modelName, $report) {
        foreach ($report->conditions()->where('type', '=', 'and')->get() as $condition) {

            $fieldName = $condition->field->db_name;
            $operatorOb = $condition->operator;
            $operatorName = $operatorOb->operator;
            $conditionValue = $condition->value;

            if ($operatorOb->type == "text" || $operatorOb->type == "number") {
                if ($operatorOb->value_type == "text") {

                    if ($operatorOb->name == "Start with") {
                        //dd($conditionValue);
                        $modelName = $modelName->where($fieldName, "LIKE", $conditionValue . "%");

                        // dd($modelName->get());
                    } elseif ($operatorOb->name == "Ends with") {
                        //dd($conditionValue);
                        $modelName = $modelName->where($fieldName, "LIKE", "%" . $conditionValue);

                        // dd($modelName->get());
                    } elseif ($operatorOb->name == "Contains") {
                        //dd($conditionValue);
                        $modelName = $modelName->where($fieldName, "LIKE", "%" . $conditionValue . "%");

                        // dd($modelName->get());
                    } elseif ($operatorOb->name == "Does not contains") {
                        //dd($conditionValue);
                        $modelName = $modelName->where($fieldName, "NOT LIKE", "%" . $conditionValue . "%");

                        // dd($modelName->get());
                    } else {
                        $modelName = $modelName->where($fieldName, $operatorName, $conditionValue);
                    }
                } else {

                    if ($operatorOb->name == "Is empty") {
                        //dd($conditionValue);
                        $modelName = $modelName->whereRaw($fieldName . ' = ""');

                        // dd($modelName->get());
                    }
                    if ($operatorOb->name == "Is not empty") {

                        $modelName = $modelName->whereRaw($fieldName . ' != ""');
                    }
                }

                //
            }
            if ($operatorOb->type == "date") {

                if ($operatorOb->value_type == "hidden") {
                    $today = date("Y-m-d");
                    if ($operatorOb->value == "today") {
                        $today = date("Y-m-d");
                        $modelName = $modelName->whereRaw('DATE(' . $fieldName . ') = "' . $today . '"');
                    }
                    if ($operatorOb->value == "1m") {
                        $month = date("m");
                        $modelName = $modelName->whereRaw('MONTH(' . $fieldName . ') = "' . $month . '"');
                    }
                    if ($operatorOb->value == "1y") {
                        $year = date("Y");
                        $modelName = $modelName->whereRaw('YEAR(' . $fieldName . ') = "' . $year . '"');
                    }
                } else {
                    $today = date("Y-m-d");
                    $modelName = $modelName->whereRaw('DATE(' . $fieldName . ') ' . $operatorName . ' "' . $conditionValue . '"');
                }
            }
        }

        return $modelName;
    }

    public function conditionOr($modelNameOr, $report) {

        $modelNameNew = $modelNameOr->where(function ($modelName) use ($report) {

            foreach ($report->conditions()->where('type', '=', 'or')->get() as $keyConditio => $condition) {


                if ($keyConditio == 0) {



                    $fieldName = $condition->field->db_name;
                    $operatorOb = $condition->operator;
                    $operatorName = $operatorOb->operator;
                    $conditionValue = $condition->value;

                    if ($operatorOb->type == "text" || $operatorOb->type == "number") {
                        if ($operatorOb->value_type == "text") {

                            if ($operatorOb->name == "Start with") {
                                //dd($conditionValue);
                                $modelName = $modelName->where($fieldName, "LIKE", $conditionValue . "%");

                                // dd($modelName->get());
                            } elseif ($operatorOb->name == "Ends with") {
                                //dd($conditionValue);
                                $modelName = $modelName->where($fieldName, "LIKE", "%" . $conditionValue);

                                // dd($modelName->get());
                            } elseif ($operatorOb->name == "Contains") {
                                //dd($conditionValue);
                                $modelName = $modelName->where($fieldName, "LIKE", "%" . $conditionValue . "%");

                                // dd($modelName->get());
                            } elseif ($operatorOb->name == "Does not contains") {
                                //dd($conditionValue);
                                $modelName = $modelName->where($fieldName, "NOT LIKE", "%" . $conditionValue . "%");

                                // dd($modelName->get());
                            } else {
                                $modelName = $modelName->where($fieldName, $operatorName, $conditionValue);
                            }
                        } else {

                            if ($operatorOb->name == "Is empty") {
                                //dd($conditionValue);
                                $modelName = $modelName->whereRaw($fieldName . ' = ""');

                                // dd($modelName->get());
                            }
                            if ($operatorOb->name == "Is not empty") {

                                $modelName = $modelName->whereRaw($fieldName . ' != ""');
                            }
                        }

                        //
                    }
                    if ($operatorOb->type == "date") {

                        if ($operatorOb->value_type == "hidden") {
                            $today = date("Y-m-d");
                            if ($operatorOb->value == "today") {
                                $today = date("Y-m-d");
                                $modelName = $modelName->whereRaw('DATE(' . $fieldName . ') = "' . $today . '"');
                            }
                            if ($operatorOb->value == "1m") {
                                $month = date("m");
                                $modelName = $modelName->whereRaw('MONTH(' . $fieldName . ') = "' . $month . '"');
                            }
                            if ($operatorOb->value == "1y") {
                                $year = date("Y");
                                $modelName = $modelName->whereRaw('YEAR(' . $fieldName . ') = "' . $year . '"');
                            }
                        } else {
                            $today = date("Y-m-d");
                            $modelName = $modelName->whereRaw('DATE(' . $fieldName . ') ' . $operatorName . ' "' . $conditionValue . '"');
                        }
                    }
                } else {



                    $fieldName = $condition->field->db_name;
                    $operatorOb = $condition->operator;
                    $operatorName = $operatorOb->operator;
                    $conditionValue = $condition->value;

                    if ($operatorOb->type == "text" || $operatorOb->type == "number") {
                        if ($operatorOb->value_type == "text") {

                            if ($operatorOb->name == "Start with") {
                                //dd($conditionValue);
                                $modelName = $modelName->orWhere($fieldName, "LIKE", $conditionValue . "%");

                                // dd($modelName->get());
                            } elseif ($operatorOb->name == "Ends with") {
                                //dd($conditionValue);
                                $modelName = $modelName->orWhere($fieldName, "LIKE", "%" . $conditionValue);

                                // dd($modelName->get());
                            } elseif ($operatorOb->name == "Contains") {
                                //dd($conditionValue);
                                $modelName = $modelName->orWhere($fieldName, "LIKE", "%" . $conditionValue . "%");

                                // dd($modelName->get());
                            } elseif ($operatorOb->name == "Does not contains") {
                                //dd($conditionValue);
                                $modelName = $modelName->orWhere($fieldName, "NOT LIKE", "%" . $conditionValue . "%");

                                // dd($modelName->get());
                            } else {
                                $modelName = $modelName->orWhere($fieldName, $operatorName, $conditionValue);
                            }
                        } else {

                            if ($operatorOb->name == "Is empty") {
                                //dd($conditionValue);
                                $modelName = $modelName->orWhereRaw($fieldName . ' = ""');

                                // dd($modelName->get());
                            }
                            if ($operatorOb->name == "Is not empty") {

                                $modelName = $modelName->orWhereRaw($fieldName . ' != ""');
                            }
                        }

                        //
                    }
                    if ($operatorOb->type == "date") {

                        if ($operatorOb->value_type == "hidden") {
                            $today = date("Y-m-d");
                            if ($operatorOb->value == "today") {
                                $today = date("Y-m-d");
                                $modelName = $modelName->orWhereRaw('DATE(' . $fieldName . ') = "' . $today . '"');
                            }
                            if ($operatorOb->value == "1m") {
                                $month = date("m");
                                $modelName = $modelName->orWhereRaw('MONTH(' . $fieldName . ') = "' . $month . '"');
                            }
                            if ($operatorOb->value == "1y") {
                                $year = date("Y");
                                $modelName = $modelName->orWhereRaw('YEAR(' . $fieldName . ') = "' . $year . '"');
                            }
                        } else {
                            $today = date("Y-m-d");
                            $modelName = $modelName->orWhereRaw('DATE(' . $fieldName . ') ' . $operatorName . ' "' . $conditionValue . '"');
                        }
                    }
                }
            }
        });

        return $modelNameNew;
    }

    public function show($report) {
        // dd($report->model->name);


        $modelName = $this->modelOb[$report->model->name];


        $modelName = $this->conditionAnd($modelName, $report);
        $modelName = $this->conditionOr($modelName, $report);

        $datas = $modelName->get();
        $fields = $report->fields;

        if ($this->request->type == 'export') {
            $fileArray = array();
            foreach ($fields as $keyF => $field) {
                $fileArray[0][$keyF] = $field->name;
                $fileArray[1][$keyF] = "";
            }
            foreach ($datas as $keyD => $data) {
                foreach ($fields as $keyF => $field) {

                    $fileArray[$keyD + 2][$keyF] = $data[$field->db_name];
                }
            }



            if ($this->request->action == 'excel5') {
                Excel::create('Filename', function($excel) use($fileArray) {

                    $excel->sheet('Sheetname', function($sheet) use($fileArray) {

                        $sheet->fromArray($fileArray);
                    });
                })->export('xls');
            }
            if ($this->request->action == 'excel2007') {
                Excel::create('Filename', function($excel) use($fileArray) {

                    $excel->sheet('Sheetname', function($sheet) use($fileArray) {

                        $sheet->fromArray($fileArray);
                    });
                })->export('xls');
            }

            if ($this->request->action == 'csv') {
                Excel::create('Filename', function($excel) use($fileArray) {

                    $excel->sheet('Sheetname', function($sheet) use($fileArray) {

                        $sheet->fromArray($fileArray);
                    });
                })->export('csv');
            }

            if ($this->request->action == 'pdf') {
                Excel::create('Filename', function($excel) use($fileArray) {

                    $excel->sheet('Sheetname', function($sheet) use($fileArray) {
                        $sheet->freezeFirstRow();

                        $sheet->fromArray($fileArray, null, 'A1', true);
                    });
                })->export('pdf');
            }

            exit;
        }





        // dd($fields[0]->name);

        return view('reports.show', compact('report', 'datas', 'fields'));
    }

    public function edit($report) {




        return view('reports.edit', compact('report', 'fields'));
    }

    public function update(EditRequest $request, $report) {





        $report->name = $request->name;

        $report->model_id = $request->model_id;


        $report->save();
        // dd(explode(',', $request->field_id));

        $report->fields()->detach();
        $report->fields()->attach(explode(',', $request->field_id));


        $all = $request->all();

//dd($all);
        $this->condition->where('report_id', $report->id)->forceDelete();

        // dd($all);
        foreach ($all as $key => $value) {


            if (strpos($key, 'condition_id_') !== false) {
                $keyId = str_replace('condition_id_', '', $key);
                if ($all['field_id_' . $keyId] != "" && $all['condition_id_' . $keyId] != "") {
                    $condition = new Condition();
                    $condition->report_id = $report->id;
                    $condition->field_id = $all['field_id_' . $keyId];
                    $condition->operator_id = $all['condition_id_' . $keyId];
                    $condition->type = $all['condition_type_' . $keyId];
//               dd($this->request->has('condition_value_' . $keyId));
                    if ($this->request->has('condition_value_' . $keyId)) {

                        $condition->value = $all['condition_value_' . $keyId];
                    }

                    $condition->save();
                }
            }
        }

        return redirect()->route('report.index');
    }

    public function model($id) {

        return $this->report->find($id);
    }

    public function delete($report) {
        $id = $report->id;



        return view('reports.delete', compact('report'));
    }

    public function destroy($report) {

        $id = $report->id;


        $report->delete();

        return redirect()->route('report.index');
    }

}
