<?php

namespace App\Http\Controllers;

use App\Http\Requests\Solicitor\CreateRequest;
use App\Http\Requests\Solicitor\EditRequest;
use App\Models\Solicitor;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Response;

class SolicitorController extends Controller
{
    protected $request;
    protected $solicitor;

    public function __construct(Request $request, Solicitor $solicitor) {

        $this->request = $request;
        $this->solicitor = $solicitor;

        //$this->middleware('auth');
    }

    public function index() {

        $solicitor = $this->solicitor;

        //   $pagination = solicitor('setting.pagination');;

        if ($this->request->ajax()) {


            return Response::json($solicitor->get());
        }


        if ($this->request->has('search')) {

            $solicitor = $solicitor->where(function ($query) {
                $query->where('email', 'like', '%' . $this->request->search . '%')
                    ->orWhere('name', 'like', '%' . $this->request->search . '%');
            });

            $search=$this->request->search;
        }
        $search=$this->request->search;
        $solicitors = $solicitor->paginate(20);
        return view('solicitors.index', compact('solicitors', 'search'));
    }

    public function create() {
        return view('solicitors.create');
    }

    public function store(CreateRequest $request) {

        $solicitor = $this->solicitor;

        $solicitor->name = $request->name;
        $solicitor->email = $request->email;



        $solicitor->save();

        return redirect()->route('solicitor.index');
    }

    public function show($id) {

        return view('solicitors.show', compact('solicitor'));
    }

    public function edit($solicitor) {

        return view('solicitors.edit', compact('solicitor'));
    }

    public function update(EditRequest $request, $solicitor) {
        $solicitor->name = $request->name;
        $solicitor->email = $request->email;

        $solicitor->save();
        return redirect()->route('solicitor.index');
    }

    public function model($id) {

        return $this->solicitor->find($id);
    }

    public function delete($solicitor) {
        $id = $solicitor->id;
        return view('solicitors.delete', compact('solicitor'));
    }

    public function destroy($solicitor) {
        $id = $solicitor->id;
        $solicitor->delete();

        return redirect()->route('solicitor.index');
    }

}
