<?php

namespace App\Http\Controllers;

use App\Http\Requests\User\CreateRequest;
use App\Http\Requests\User\EditRequest;
use App\Models\Config;
use App\Models\Group;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Response;

class UserController extends Controller
{
    protected $request;
    protected $user;
    protected $config;
    protected $group;

    public function __construct(Request $request, User $user, Config $config, Group $group) {

        $this->request = $request;
        $this->user = $user;
        $this->config = $config;
        $this->group = $group;
        //$this->middleware('auth');
    }

    public function index() {

        $user = $this->user;
        $paginationSize = Config::find(1)->value;

        if ($this->request->ajax()) {


            return Response::json($user->where('last_name', 'LIKE', '%' . $this->request->term . '%')->get());
        }
        if ($this->request->has('search')) {

            $user = $user->where(function ($query) {
                $query->where('first_name', 'like', '%' . $this->request->search . '%')
                    ->orWhere('last_name', 'like', '%' . $this->request->search . '%')
                    ->orWhere('email', 'like', '%' . $this->request->search . '%');
            });

            if(count($user->get()) < 1)
            {


                return redirect()->route('client.index', ['search' => $this->request->search]);
            }


            $search=$this->request->search;
        }
        $search=$this->request->search;
        $users = $user->orderBy('id', 'DESC')->paginate($paginationSize);

        return view('users.index', compact('users', 'search'));
    }

    public function create() {
        $groups = $this->group->pluck('name', 'id')->toArray();
        return view('users.create', compact('groups'));
    }

    public function store(CreateRequest $request) {

        $user = $this->user;

        $user->email = $request->email;
        $user->first_name = $request->first_name;
        $user->last_name = $request->last_name;
        $user->group_id = $request->group_id;
        $user->password = Hash::make($request->password);

        $user->save();

        return redirect()->route('user.index');
    }

    public function edit($id) {
        $user = $this->model($id);
        $groups = $this->group->pluck('name', 'id')->toArray();
        return view('users.edit', compact('user', 'groups'));
    }

    public function update(EditRequest $request, $id) {
        // dd($request);
        $user = $this->model($id);

        $user->first_name = $request->first_name;
        $user->last_name = $request->last_name;
        $user->group_id = $request->group_id;
        $user->phone_number = $request->phone_number;
        $user->save();
        return redirect()->route('user.index');
    }

    public function model($id) {

        return $this->user->find($id);
    }

    public function delete($id) {

        $user = $this->model($id);


        return view('users.delete', compact('user'));
    }

    public function destroy($id) {
        $user = $this->model($id);
        $user->delete();

        return redirect()->route('user.index');
    }

}
