<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class ClientMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        if ($request->has('search')) {
            $url = route('client.index');

            // Merge the search parameter to the URL query parameters
            // $url = url($url)->merge(['search' => $request->search]);
//            $url = url($url)->to($url . '?' . http_build_query(['search' => $request->search], '', '&'));
            $url = url($url . '?' . http_build_query(['search' => $request->search], '', '&'));

            // Redirect to the modified URL
            return redirect($url);
        }

        return $next($request);
    }
}
