<?php

namespace App\Http\Requests\Payment;

use App\Http\Requests\Request;
use Illuminate\Foundation\Http\FormRequest;

class CreateRequest extends FormRequest {

    public function rules() {


        $rules = [
            'amount' => 'required',
            'payment_date' => 'required',
            'payment_type' => 'required',
        ];

        if ($this->payment_type == 'debit card' || $this->payment_type == 'credit card') {
            $rules['card_number'] = 'required|string|between:13,19';
            $rules['name_on_card'] = 'required';
            $rules['card_expiry_month'] = 'required';
            $rules['card_expiry_year'] = 'required';
        }
        return $rules;
    }

    public function authorize() {
        return true;
    }

}
