<?php

namespace App\Http\Requests\Transaction;

use App\Http\Requests\Request;
use Illuminate\Foundation\Http\FormRequest;

class CreateRequest extends FormRequest {

    public function rules() {
       $rules = [
            'amount' => 'required',
            'paid_date' => 'required',
            'payment_type' => 'required',
        ];

        if ($this->payment_type == 'cheque') {

            $rules['bank'] = 'required';
            $rules['branch'] = 'required';
            $rules['cheque_no'] = 'required';
        }


        return $rules;
    }

    public function authorize() {
        return true;
    }

}
