<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class SendMail extends Mailable
{
    use Queueable, SerializesModels;


    protected $closureData;
    protected $content;

    /**
     * Create a new message instance.
     * @param  string $content
 * @return void
     */


    public function __construct(string $content, $closureData)
    {
        $this->content = $content;
        $this->closureData = $closureData;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->view('emails.test')
            ->with([
                'content' => $this->content,
            ])
            ->to($this->closureData['to'])
            ->subject($this->closureData['subject'])
            ->from($this->closureData['fromMail'])
            ->cc($this->closureData['cc'])
            ->bcc($this->closureData['bcc']);

    }


}
