<?php namespace App\Models;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Model as L5Model;

class Action extends L5Model {

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $guarded = array('id');
    protected $fillable = array('name');
    public $columns = array(
        array(
            'field' => 'first_name',
            'title' => 'First name',
            'type' => 'self'
        )
    );
    public $forms = array(
        'creatable' => array(
            array(
                'field' => 'email',
                'title' => 'Email',
                'type' => 'text',
                'autofocus' => 'autofocus',
                'class' => ''
            ),
            array(
                'field' => 'password',
                'title' => 'Password',
                'type' => 'password',
                'autofocus' => 'autofocus',
                'class' => 'form-control'
            ),
            array(
                'field' => 'password_confirmation',
                'title' => 'Confirm Password',
                'type' => 'password',
                'autofocus' => 'autofocus',
                'class' => 'form-control'
            )
        )
    );
    public static $rules = array(
        'name' => 'required|unique:users',
    );

    public function groupPortal() {
        return $this->belongsTo('App\GroupPortalUser');
    }

    public function groups() {
        return $this->belongsToMany('App\Group');
    }

    public function portals() {
        return $this->belongsToMany('App\Portal');
    }

    public function models() {
        return $this->belongsToMany('App\Model');
    }

}
