<?php namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Model;

class Calendar extends Model {
    use SoftDeletes;

//  public function clients() {
//        return $this->belongsToMany('App\Client');
//    }


    public function client() {
        return $this->belongsTo(Client::class);
    }

    public function debtor() {
        return $this->belongsTo(Debtor::class);
    }


    public function setStartDateAttribute($value) {
        $this->attributes['start_date'] = Carbon::createFromFormat('d/m/Y', $value)->format('Y-m-d');
    }

//    public function getStartDateAttribute($value) {
//
//         if($value == '')
//        {
//            return $value;
//        }
//
//        return \Carbon\Carbon::createFromFormat('Y-m-d', $value)->format('d/m/Y');
//    }

    public function setEndDateAttribute($value) {

         if($value == '')
        {
            return $value;
        }

        $this->attributes['end_date'] = Carbon::createFromFormat('d/m/Y', $value)->format('Y-m-d');
    }

//    public function getEndDateAttribute($value) {
//
//
//
//         if($value == '')
//        {
//            return $value;
//        }
//
//        return \Carbon\Carbon::createFromFormat('Y-m-d', $value)->format('d/m/Y');
//    }
}
