<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Model;

class Client extends Model {

    use SoftDeletes;

    public function debtors() {
        return $this->belongsToMany(Debtor::class);
    }

    public function debtorInvoice() {


        return $this->belongsToMany(Debtor::class, 'debtor_invoices', 'client_id', 'debtor_id')->withPivot('id', 'invoice_date', 'invoice_state', 'user_id', 'account_state', 'original_debt', 'current_balance', 'last_payment', 'last_paid', 'invoice_code', 'invoice_status_code_id');
    }

    public function debtorInvoices() {

       return $this->hasMany(DebtorInvoice::class);

    }
     public function clientInvoices() {

       return $this->hasMany(ClientInvoice::class);

    }
    public function invoiceFollows() {

       return $this->hasMany(InvoiceFollow::class);

    }
    public function dues() {

       return $this->hasMany(Due::class);

    }
    public function payments() {
        return $this->hasMany(Payment::class);
    }

    public function clientAccounts() {
        return $this->hasMany(ClientAccount::class);
    }

    public function clientTransactions() {
        return $this->hasMany(ClientTransaction::class);
    }

    public function clientPayments() {
        return $this->hasMany(ClientPayment::class);
    }

    public function openingBalances() {
        return $this->hasMany(OpeningBalance::class);
    }

    public function paymentAdjustments() {
        return $this->hasMany(PaymentAdjustment::class);
    }

}


