<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Model;

class Debtor extends Model {

    use SoftDeletes;

    protected $guarded = [];

    public function clients() {
        return $this->belongsToMany(Client::class);
    }

    public function debtorInvoice() {


        return $this->belongsToMany(Debtor::class, 'debtor_invoices', 'debtor_id', 'client_id')->withPivot('invoice_date', 'invoice_state', 'account_state');
    }

    public function debtorInvoice2() {
        return $this->hasMany(DebtorInvoice::class);
    }

     public function payments() {
        return $this->hasMany(Payment::class);
    }

     public function dues() {

       return $this->hasMany(Due::class);

    }

     public function clientInvoices() {

       return $this->hasMany(ClientInvoice::class);

    }
    public function invoiceFollows() {

       return $this->hasMany(InvoiceFollow::class);

    }


    public function clientDetail() {
        $debtorInvoices = $this->debtorInvoice2()->first();
//        $client = array();
//        if (count($debtorInvoices)) {
//            $client = $debtorInvoices->client;
//        }
        $client = null;
        if($debtorInvoices){
            $client = $debtorInvoices->client;
        }

        return $client;
    }

}
