<?php

namespace App\Models;

use App\Models\DebtType;
use App\Models\Import;
use App\Models\InvoiceStatusCode;
use App\Models\Payment;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Model;

class DebtorInvoice extends Model {

    use SoftDeletes;

    protected $guarded = [];

    protected $table = 'debtor_invoices';

    public function client() {
        return $this->belongsTo(Client::class);
    }

    public function debtor() {
        return $this->belongsTo(Debtor::class);
    }

    public function payments() {
        return $this->hasMany(Payment::class);
    }

    public function user() {
        return $this->belongsTo(User::class);
    }

    public function solicitor() {
        return $this->belongsTo(Solicitor::class);
    }

    public function debtType() {
        return $this->belongsTo(DebtType::class);
    }

    public function invoiceStatusCode() {
        return $this->belongsTo(InvoiceStatusCode::class);
    }
     public function invoicePreviousStatusCode() {
        return $this->belongsTo(InvoiceStatusCode::class, 'prev_invoice_status_code_id');
    }

    public function follows() {
        return $this->hasMany(InvoiceFollow::class);
    }

     public function clientInvoices() {

       return $this->hasMany(ClientInvoice::class);

    }

     public function dues() {

       return $this->hasMany(Due::class);

    }

    public function import(){

        return $this->belongsTo(Import::class);

    }



    public function setLastPaidAttribute($value) {

         if($value == '')
        {
            return $value;
        }

        $this->attributes['last_paid'] = Carbon::createFromFormat('d/m/Y', $value)->format('Y-m-d');
    }

    public function getLastPaidAttribute($value) {

         if($value == '' || $value == '0000-00-00')
        {
            return '';
        }

        return Carbon::createFromFormat('Y-m-d', $value)->format('d/m/Y');
    }

    public function setInvoiceDateAttribute($value) {

         if($value == '')
        {
            return $value;
        }

        $this->attributes['invoice_date'] = Carbon::createFromFormat('d/m/Y', $value)->format('Y-m-d');
    }

    public function getInvoiceDateAttribute($value) {

        if($value == '' || $value == '0000-00-00')
        {

            return '';
        }

        return Carbon::createFromFormat('Y-m-d', $value)->format('d/m/Y');
    }

}
