<?php namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Model;

class Due  extends Model {
    use SoftDeletes;

  public function client()
    {
        return $this->belongsTo(Client::class);
    }
     public function debtor()
    {
        return $this->belongsTo(Debtor::class);
    }

    public function getDueDateAttribute($value) {
        if($value == '' || $value == '0000-00-00')
        {
            return '';
        }

        return Carbon::createFromFormat('Y-m-d', $value)->format('d/m/Y');
    }
}
