<?php namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Model;

class Group extends Model {

    use SoftDeletes;
    protected $dates = ['deleted_at'];


    public function getPermissionsAttribute($value)
    {
        return json_decode($value);
    }
    public function setPermissionsAttribute($value)
    {
        $this->attributes['permissions'] = json_encode($value);
    }

    public function getPermissions()
    {
        return $this->permissions;
    }

    public function hasAccess($permissions, $all = true)
    {
        $groupPermissions = $this->getPermissions();

        $groupPermissionsArray =  (array)  $groupPermissions;

       return array_key_exists($permissions, $groupPermissionsArray);

    }


}
