<?php namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Model;

class InvoiceCharge extends Model {
    use SoftDeletes;

  public function client()
    {
        return $this->belongsTo(Client::class);
    }


    public function setPaidDateAttribute($value) {

         if($value == '')
        {
            return $value;
        }

        $this->attributes['paid_date'] = Carbon::createFromFormat('d/m/Y', $value)->format('Y-m-d');
    }

    public function getPaidDateAttribute($value) {

         if($value == '' || $value == '0000-00-00')
        {
            return '';
        }

        return Carbon::createFromFormat('Y-m-d', $value)->format('d/m/Y');
    }
     public function setEntryDateAttribute($value) {

         if($value == '')
        {
            return $value;
        }

        $this->attributes['entry_date'] = Carbon::createFromFormat('d/m/Y', $value)->format('Y-m-d');
    }
     public function getEntryDateAttribute($value) {

         if($value == '' || $value == '0000-00-00')
        {
            return '';
        }

        return Carbon::createFromFormat('Y-m-d', $value)->format('d/m/Y');
    }

    public function setForMonthAttribute($value) {

         if($value == '')
        {
            return $value;
        }

        $this->attributes['for_month'] = Carbon::createFromFormat('d/m/Y', $value)->format('Y-m-d');
    }

    public function getForMonthAttribute($value) {

         if($value == '' || $value == '0000-00-00')
        {
            return '';
        }

        return Carbon::createFromFormat('Y-m-d', $value)->format('d/m/Y');
    }


}

