<?php namespace App\Models;


use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class InvoiceFollow extends Model {
    use SoftDeletes;

  protected $table = 'invoice_follows';

    public function client()
    {
        return $this->belongsTo(Client::class);
    }
     public function debtor()
    {
        return $this->belongsTo(Debtor::class);
    }
     public function debtorInvoice()
    {
        return $this->belongsTo(DebtorInvoice::class);
    }
     public function collectionActionCode()
    {
        return $this->belongsTo(CollectionActionCode::class);
    }

    public function setDateAttribute($value) {

         if($value == '')
        {
            return $value;
        }

        $this->attributes['date'] = Carbon::createFromFormat('d/m/Y', $value)->format('Y-m-d');
    }

    public function getDateAttribute($value) {
        if($value == '' || $value == '0000-00-00')
        {
            return '';
        }
        return Carbon::createFromFormat('Y-m-d', $value)->format('d/m/Y');
    }

    public function setNextFollowDateAttribute($value) {
        $this->attributes['next_follow_date'] = Carbon::createFromFormat('d/m/Y', $value)->format('Y-m-d');
    }

    public function getNextFollowDateAttribute($value) {
       if($value == '' || $value == '0000-00-00')
        {
            return '';
        }

        return Carbon::createFromFormat('Y-m-d', $value)->format('d/m/Y');
    }


}

