<?php namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Model;

class OpeningBalance extends Model {
    use SoftDeletes;

  public function client()
    {
        return $this->belongsTo(Client::class);
    }


    public function setLastDateOfMonthAttribute($value) {

         if($value == '')
        {
            return $value;
        }

        $this->attributes['last_date_of_month'] = Carbon::createFromFormat('d/m/Y', $value)->format('Y-m-d');
    }

    public function getLastDateOfMonthAttribute($value) {

         if($value == '' || $value == '0000-00-00')
        {
            return '';
        }

        return Carbon::createFromFormat('Y-m-d', $value)->format('d/m/Y');
    }


}

