<?php namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Model;


class Payment  extends Model {
    use SoftDeletes;

  public function client()
    {
        return $this->belongsTo(Client::class);
    }
     public function debtor()
    {
        return $this->belongsTo(Debtor::class);
    }
     public function debtorInvoice()
    {
        return $this->belongsTo(DebtorInvoice::class, 'debtor_invoice_id');
    }

     public function setPaymentDateAttribute($value)
    {
          if($value == '')
        {
            return $value;
        }
        // dd(\Carbon\Carbon::createFromFormat('d/m/Y', $value)->format('Y-m-d'));

          $this->attributes['payment_date'] = Carbon::createFromFormat('d/m/Y', $value)->format('Y-m-d');
         // \Carbon\Carbon::createFromFormat('d/m/Y', $value)->format('Y-m-d');

       // return   \Carbon\Carbon::createFromFormat('d/m/Y', $value)->format('Y-m-d');

    }



      public function getPaymentDateAttribute($value)
    {

        // dd(\Carbon\Carbon::createFromFormat('d/m/Y', $value)->format('Y-m-d'));

        if($value == '' || $value == '0000-00-00')
        {
            return '';
        }

          return  Carbon::createFromFormat('Y-m-d', $value)->format('d/m/Y');

       // return   \Carbon\Carbon::createFromFormat('d/m/Y', $value)->format('Y-m-d');

    }

}

