<?php namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Model;

class PaymentAdjustment extends Model {
    use SoftDeletes;

  public function client()
    {
        return $this->belongsTo(Client::class);
    }


    public function setAdjustmentDateAttribute($value) {

         if($value == '')
        {
            return $value;
        }

        $this->attributes['adjustment_date'] = Carbon::createFromFormat('d/m/Y', $value)->format('Y-m-d');
    }

    public function getAdjustmentDateAttribute($value) {

         if($value == '' || $value == '0000-00-00')
        {
            return '';
        }

        return Carbon::createFromFormat('Y-m-d', $value)->format('d/m/Y');
    }




}

