@extends('layouts.master')
@section('title')
@parent
@if($type == 'call')
{!! 'Create Call' !!}
@elseif($type == 'todo')
{!! 'Create ToDo' !!}
@endif
@stop

@section('content')
<div class="box">
    <div class="box-body">

        @if($formPath == 0)
            @if($type == 'call')
                {!! Form::open(array('route' => array('calendar.call.store'), 'autocomplete' => 'off')) !!}
            @elseif($type == 'todo')
                {!! Form::open(array('route' => array('calendar.todo.store'), 'autocomplete' => 'off')) !!}
            @endif
        @endif

        @if($formPath == 1)
            @if($type == 'call')
                {!! Form::open(array('route' => array('calendar.call.client.store',$clientArray['id']), 'autocomplete' => 'off')) !!}
            @elseif($type == 'todo')
                {!! Form::open(array('route' => array('calendar.todo.client.store',$clientArray['id']), 'autocomplete' => 'off')) !!}
            @endif
        @endif

        @if($formPath == 2)
            @if($type == 'call')
                {!! Form::open(array('route' => array('calendar.call.client.debtor.store',$clientArray['id'],$debtorArray['id']), 'autocomplete' => 'off')) !!}
            @elseif($type == 'todo')
                {!! Form::open(array('route' => array('calendar.todo.client.debtor.store',$clientArray['id'],$debtorArray['id']), 'autocomplete' => 'off')) !!}
            @endif
        @endif

        @if($formPath == 3)
            @if($type == 'call')
                {!! Form::open(array('route' => array('calendar.call.debtor.store',$debtorArray['id']), 'autocomplete' => 'off')) !!}
            @elseif($type == 'todo')
                {!! Form::open(array('route' => array('calendar.todo.debtor.store',$debtorArray['id']), 'autocomplete' => 'off')) !!}
            @endif
        @endif
        <div class="box box-info">
            <div class="box-header">
                <h3 class="box-title">
                    @if($type == 'call')
                    {!! 'Create Call' !!}
                    @elseif($type == 'todo')
                    {!! 'Create ToDo' !!}
                    @endif
                </h3>
            </div>
            <div class="box-body">
                <div class="row">
                    <div class="col-md-6">

                        <div class="form-group {!! ($errors->has('name')) ? 'has-error' : '' !!}">
                            {!! Form::label('name', 'Name') !!}
                            {!! Form::text('name','',array('class' => 'form-control', 'placeholder' => 'Name', 'autocomplete' => 'off',)) !!}
                            {!! ($errors->has('name') ? $errors->first('name') : '') !!}
                        </div>

                        @if($type == 'call')
                        <div class="form-group {!! ($errors->has('type')) ? 'has-error' : '' !!}">
                            {!! Form::label('type', 'Type', ['class' => 'control-label']) !!}
                            {!!  Form::select('type',  [ 'call'=>'Call', 'todo'=>'ToDo'], 'call'  ,['class' => 'form-control', 'placeholder' => 'Type', 'required'])  !!}
                            <span class="help-block">{!! ($errors->has('type') ? $errors->first('type') : '') !!}</span>
                        </div>
                        @elseif($type == 'todo')
                        <div class="form-group {!! ($errors->has('type')) ? 'has-error' : '' !!}">
                            {!! Form::label('type', 'Type', ['class' => 'control-label']) !!}
                            {!!  Form::select('type',  [ 'call'=>'Call', 'todo'=>'ToDo'], 'todo'  ,['class' => 'form-control', 'placeholder' => 'Type', 'required'])  !!}
                            <span class="help-block">{!! ($errors->has('type') ? $errors->first('type') : '') !!}</span>
                        </div>
                        @endif

                        <div class="form-group {!! ($errors->has('client_id')) ? 'has-error' : '' !!}">
                            {!! Form::label('client_id', 'Client Name', ['class' => 'control-label']) !!}
                            <div class="row">
                                <div class="col-md-12">
                                    <input type="hidden"  class="client-select" id="client-select-id" name="client_id">
                                </div>
                            </div>


                            <span class="help-block">{!! ($errors->has('client_id') ? $errors->first('client_id') : '') !!}</span>
                        </div>

                        <div class="form-group {!! ($errors->has('start_date')) ? 'has-error' : '' !!}">
                            {!! Form::label('start_date', 'Start Date') !!}
                            {!! Form::text('start_date',\Carbon\Carbon::now(), array('class' => 'form-control datepicker', 'placeholder' => '2015-01-01')) !!}
                            {!! ($errors->has('start_date') ? $errors->first('start_date') : '') !!}
                        </div>

                        <div class="form-group {!! ($errors->has('start_time')) ? 'has-error' : '' !!}">
                            {!! Form::label('start_time', 'Start Time') !!}
                            {!! Form::select('start_time', ['00:00' => '12:00 AM', '00:15' => '12:15 AM','00:30' => '12:30 AM','00:45' => '12:45 AM'
                            ,'01:00' => '01:00 AM','01:15' => '01:15 AM','01:30' => '01:30 AM','01:45' => '01:45 AM'
                            ,'02:00' => '02:00 AM','02:15' => '02:15 AM','02:30' => '02:30 AM','02:45' => '02:45 AM'
                            ,'03:00' => '03:00 AM','03:15' => '03:15 AM','03:30' => '03:30 AM','03:45' => '03:45 AM'
                            ,'04:00' => '04:00 AM','04:15' => '04:15 AM','04:30' => '04:30 AM','04:45' => '04:45 AM'
                            ,'05:00' => '05:00 AM','05:15' => '05:15 AM','05:30' => '05:30 AM','05:45' => '05:45 AM'
                            ,'06:00' => '06:00 AM','06:15' => '06:15 AM','06:30' => '06:30 AM','06:45' => '06:45 AM'
                            ,'07:00' => '07:00 AM','07:15' => '07:15 AM','07:30' => '07:30 AM','07:45' => '07:45 AM'
                            ,'08:00' => '08:00 AM','08:15' => '08:15 AM','08:30' => '08:30 AM','08:45' => '08:45 AM'
                            ,'09:00' => '09:00 AM','09:15' => '09:15 AM','09:30' => '09:30 AM','09:45' => '09:45 AM'
                            ,'10:00' => '10:00 AM','10:15' => '10:15 AM','10:30' => '10:30 AM','10:45' => '10:45 AM'
                            ,'11:00' => '11:00 AM','11:15' => '11:15 AM','11:30' => '11:30 AM','11:45' => '11:45 AM'
                            ,'12:00' => '12:00 PM','12:15' => '12:15 PM','12:30' => '12:30 PM','12:45' => '12:45 PM'
                            ,'13:00' => '01:00 PM','13:15' => '01:15 PM','13:30' => '01:30 PM','13:45' => '01:45 PM'
                            ,'14:00' => '02:00 PM','14:15' => '02:15 PM','14:30' => '02:30 PM','14:45' => '02:45 PM'
                            ,'15:00' => '03:00 PM','15:15' => '03:15 PM','15:30' => '03:30 PM','15:45' => '03:45 PM'
                            ,'16:00' => '04:00 PM','16:15' => '04:15 PM','16:30' => '04:30 PM','16:45' => '04:45 PM'
                            ,'17:00' => '05:00 PM','17:15' => '05:15 PM','17:30' => '05:30 PM','17:45' => '05:45 PM'
                            ,'18:00' => '06:00 PM','18:15' => '06:15 PM','18:30' => '06:30 PM','18:45' => '06:45 PM'
                            ,'19:00' => '07:00 PM','19:15' => '07:15 PM','19:30' => '07:30 PM','19:45' => '07:45 PM'
                            ,'20:00' => '08:00 PM','20:15' => '08:15 PM','20:30' => '08:30 PM','20:45' => '08:45 PM'
                            ,'21:00' => '09:00 PM','21:15' => '09:15 PM','21:30' => '09:30 PM','21:45' => '09:45 PM'
                            ,'22:00' => '10:00 PM','22:15' => '10:15 PM','22:30' => '10:30 PM','22:45' => '10:45 PM'
                            ,'23:00' => '11:00 PM','23:15' => '11:15 PM','23:30' => '11:30 PM','23:45' => '11:45 PM'], null, array('class' => 'form-control', 'placeholder' => '12:00 AM')) !!}
                            {!! ($errors->has('start_time') ? $errors->first('start_time') : '') !!}
                        </div>


                    </div>
                    <div class="col-md-6">
                        <div class="form-group {!! ($errors->has('status')) ? 'has-error' : '' !!}">
                            {!! Form::label('status', 'Status', ['class' => 'control-label']) !!}
                            {!!  Form::select('status',  [ 'create'=>'Create', 'processing'=>'Processing', 'complete'=>'Complete', 'held'=>'Held', 'cancel'=>'Cancel'], 'create'  ,['class' => 'form-control', 'placeholder' => 'Status', 'required'])  !!}
                            <span class="help-block">{!! ($errors->has('status') ? $errors->first('status') : '') !!}</span>
                        </div>

                        <div class="form-group {!! ($errors->has('remainder')) ? 'has-error' : '' !!}">
                            {!! Form::label('remainder', 'Remainder') !!}
                            {!! Form::text('remainder', null, array('class' => 'form-control', 'placeholder' => 'Remainder')) !!}
                            {!! ($errors->has('remainder') ? $errors->first('remainder') : '') !!}
                        </div>

                        <div class="form-group {!! ($errors->has('debtor_id')) ? 'has-error' : '' !!}">
                            {!! Form::label('debtor_id', 'Debtor Name', ['class' => 'control-label']) !!}
                            <div class="row">
                                <div class="col-md-12">
                                    <input type="hidden"  class="debtor-select" id="debtor-select-id" name="debtor_id">
                                </div>
                            </div>


                            <span class="help-block">{!! ($errors->has('debtor_id') ? $errors->first('debtor_id') : '') !!}</span>
                        </div>
                        <div class="form-group {!! ($errors->has('end_date')) ? 'has-error' : '' !!}">
                            {!! Form::label('end_date', 'End Date') !!}
                            {!! Form::text('end_date', null, array('class' => 'form-control datepicker', 'placeholder' => '2015-01-01', 'autocomplete' => 'off')) !!}
                            {!! ($errors->has('end_date') ? $errors->first('end_date') : '') !!}
                        </div>

                        <div class="form-group {!! ($errors->has('end_time')) ? 'has-error' : '' !!}">
                            {!! Form::label('end_time', 'End Time') !!}
                            {!! Form::select('end_time', ['00:00' => '12:00 AM', '00:15' => '12:15 AM','00:30' => '12:30 AM','00:45' => '12:45 AM'
                            ,'01:00' => '01:00 AM','01:15' => '01:15 AM','01:30' => '01:30 AM','01:45' => '01:45 AM'
                            ,'02:00' => '02:00 AM','02:15' => '02:15 AM','02:30' => '02:30 AM','02:45' => '02:45 AM'
                            ,'03:00' => '03:00 AM','03:15' => '03:15 AM','03:30' => '03:30 AM','03:45' => '03:45 AM'
                            ,'04:00' => '04:00 AM','04:15' => '04:15 AM','04:30' => '04:30 AM','04:45' => '04:45 AM'
                            ,'05:00' => '05:00 AM','05:15' => '05:15 AM','05:30' => '05:30 AM','05:45' => '05:45 AM'
                            ,'06:00' => '06:00 AM','06:15' => '06:15 AM','06:30' => '06:30 AM','06:45' => '06:45 AM'
                            ,'07:00' => '07:00 AM','07:15' => '07:15 AM','07:30' => '07:30 AM','07:45' => '07:45 AM'
                            ,'08:00' => '08:00 AM','08:15' => '08:15 AM','08:30' => '08:30 AM','08:45' => '08:45 AM'
                            ,'09:00' => '09:00 AM','09:15' => '09:15 AM','09:30' => '09:30 AM','09:45' => '09:45 AM'
                            ,'10:00' => '10:00 AM','10:15' => '10:15 AM','10:30' => '10:30 AM','10:45' => '10:45 AM'
                            ,'11:00' => '11:00 AM','11:15' => '11:15 AM','11:30' => '11:30 AM','11:45' => '11:45 AM'
                            ,'12:00' => '12:00 PM','12:15' => '12:15 PM','12:30' => '12:30 PM','12:45' => '12:45 PM'
                            ,'13:00' => '01:00 PM','13:15' => '01:15 PM','13:30' => '01:30 PM','13:45' => '01:45 PM'
                            ,'14:00' => '02:00 PM','14:15' => '02:15 PM','14:30' => '02:30 PM','14:45' => '02:45 PM'
                            ,'15:00' => '03:00 PM','15:15' => '03:15 PM','15:30' => '03:30 PM','15:45' => '03:45 PM'
                            ,'16:00' => '04:00 PM','16:15' => '04:15 PM','16:30' => '04:30 PM','16:45' => '04:45 PM'
                            ,'17:00' => '05:00 PM','17:15' => '05:15 PM','17:30' => '05:30 PM','17:45' => '05:45 PM'
                            ,'18:00' => '06:00 PM','18:15' => '06:15 PM','18:30' => '06:30 PM','18:45' => '06:45 PM'
                            ,'19:00' => '07:00 PM','19:15' => '07:15 PM','19:30' => '07:30 PM','19:45' => '07:45 PM'
                            ,'20:00' => '08:00 PM','20:15' => '08:15 PM','20:30' => '08:30 PM','20:45' => '08:45 PM'
                            ,'21:00' => '09:00 PM','21:15' => '09:15 PM','21:30' => '09:30 PM','21:45' => '09:45 PM'
                            ,'22:00' => '10:00 PM','22:15' => '10:15 PM','22:30' => '10:30 PM','22:45' => '10:45 PM'
                            ,'23:00' => '11:00 PM','23:15' => '11:15 PM','23:30' => '11:30 PM','23:45' => '11:45 PM'], null, array('class' => 'form-control', 'placeholder' => '12:00 AM')) !!}
                            {!! ($errors->has('end_time') ? $errors->first('end_time') : '') !!}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="box-footer clearfix">
        <div class=" pull-right">
            {!! Form::submit('Create', array('class' => 'btn btn-success')) !!} &nbsp;&nbsp;
            <a href="{!!URL::route('calendar.index')!!}" class="btn btn-default">Cancel</a>
            {!!Form::close()!!}
        </div>
    </div>
</div>


@stop
@section('include-js')
@parent

@stop
<script>
    @section('document-ready-js')
            @parent


            var getDebtorUrl = '{!! route("debtor.index") !!}';
    var getClientUrl = '{!! route("client.index") !!}';
    var getUserUrl = '{!! route("user.index") !!}';
    $('.client-select').select2({
        width: '100%',
        minimumInputLength: 1,
        ajax: {
            url: getClientUrl,
            dataType: 'json',
            quietMillis: 100,
            data: function (term) {
                return {
                    term: term
                };
            },
            results: function (data) {

                console.log(data);
                var results = [];

                $.each(data, function (index, item) {

                    results.push({
                        id: item.id,
                        text: item.name + ' ' + item.client_code,
                    });
                });

                return {
                    results: results
                };
            }
        }
    });



    $('.debtor-select').select2({
        width: '100%',
        minimumInputLength: 1,
        ajax: {
            url: getDebtorUrl,
            dataType: 'json',
            quietMillis: 100,
            data: function (term) {
                return {
                    term: term
                };
            },
            results: function (data) {

                console.log(data);
                var results = [];

                $.each(data, function (index, item) {

                    results.push({
                        id: item.id,
                        text: item.name + ' ' + item.debtor_code,
                    });
                });

                return {
                    results: results
                };
            }
        }
    });
    var getSolicitorrUrl = '{!! route("solicitor.index") !!}';
    $('.solicitor-select').select2({
        width: '100%',
        minimumInputLength: 1,
        ajax: {
            url: getSolicitorrUrl,
            dataType: 'json',
            quietMillis: 100,
            data: function (term) {
                return {
                    term: term
                };
            },
            results: function (data) {


                var results = [];

                $.each(data, function (index, item) {

                    results.push({
                        id: item.id,
                        text: item.name,
                    });
                });

                return {
                    results: results
                };
            }
        }
    });

    if ("{!! $debtorArray['set'] !!}" != 'no')
    {
        $('body .debtor-select .select2-chosen').text("{!! $debtorArray['name'] !!}" + ' ' + "{!! $debtorArray['debtor_code'] !!}");
        $('body  #debtor-select-id').val("{!! $debtorArray['id'] !!}");
    }

    if ("{!! $clientArray['set'] !!}" != 'no')
    {
        $('body .client-select .select2-chosen').text("{!! $clientArray['name'] !!}" + ' ' + "{!! $clientArray['client_code'] !!}");
        $('body  #client-select-id').val("{!! $clientArray['id'] !!}");
    }

    @stop
</script>
