@extends('layouts.master')
@section('title')
@parent
Calendar List
@stop

@section('content')
<div class="box">
    <div class="box-header">
        <h3 class="box-title">Calendar List </h3> 
        <div class="btn-group pull-right">
           
              <a href="{!! route('calendar.call.create') !!}" class="btn btn-success margin"><span><i class="fa    fa-plus" rel="tooltip" ></i> Add Call </span> </a>
              <a href="{!! route('calendar.todo.create') !!}" class="btn btn-success margin"><span><i class="fa    fa-plus" rel="tooltip" ></i> Add To Do </span> </a>
              
        </div>
    </div><!-- /.box-header -->
    <div class="box-body"> 
        <table class="table table-bordered">
            <tr>
                <th style="width: 10px">#</th>
                   <th>Name</th>
                   <th>Type</th>
                <th>Status</th>
                <th>Start Date & Time</th>
                <th>End Date & Time</th>
                <th>User</th>
                <th >Action</th>
            </tr> 
            @foreach($calendars as $calendar)
               
            <tr>
                <td></td>
                <td><a href="{!! route('calendar.detail', [$calendar->id]) !!}" >{!!$calendar->name !!}</a></td>
                  <td>{!! $calendar->type !!}</td>
                <td>{!! $calendar->status !!}</td>
                <td>{!! $calendar->start_date !!} {!! $calendar->start_time !!}</td>
                <td>{!! $calendar->end_date !!} {!! $calendar->end_time !!}</td>
                <td>
                    {!! $calendar->user_name !!}
                </td>
                <td>
                    <a href="{!! route('calendar.detail', [$calendar->id]) !!}"><i class="fa  fa-bars" rel="tooltip" title="Detail"></i>  </a>&nbsp;&nbsp;
                    <a href="{!! route('calendar.edit', [$calendar->id]) !!}"><i class="fa  fa-edit" rel="tooltip" title="Edit"></i>  </a>&nbsp;&nbsp;
                    <a href="{!! route('calendar.delete', [$calendar->id]) !!}"><i class="fa  fa-archive" rel="tooltip" title="Delete"></i>  </a>
                </td>
            </tr>
            @endforeach
        </table>
    </div><!-- /.box-body -->
    <div class="box-footer clearfix">
        {!! $calendars->render() !!}
    </div>
</div>

@stop
@section('include-js')
@parent

@stop

