@extends('layouts.master')
@section('title')
@parent
Client detail
@stop

@section('content')
<div class="row">
    <div class="col-sm-12">
        <h4 class="pull-left page-title"> </h4>
        <ol class="breadcrumb pull-right">
            <li><a href="{!! route('home.index') !!}">Dashboard</a></li>
            <li><a href="{!! URL::route('client.index') !!}">Client</a></li> 
            <li class="active" >{!! $client->name !!}</li> 
            <li class="active" >Invoice</li> 
        </ol>
    </div>
</div> 
<div class="nav-tabs-custom">
    @include('clients/nav')
    <div class="tab-content">
        <div class="tab-pane active"> 
            <div class="panel panel-default">
                <div class="panel-heading">
                    <div class="row"> 
                        <div class="col-md-12">
                            <div class="panel-heading pull-left">
                                <h3 class="panel-title">Client invoice</h3>
                            </div>

                            <div class="pull-right">

                            </div> 
                        </div>
                    </div>
                </div><!-- /.box-header -->
                <div class="panel-body table-rep-plugin"> 
                    <div class="table-responsive" data-pattern="priority-columns">
                        <table id="tech-companies-1" class="table  table-bordered ">
                            <thead>
                                <tr>
                                    <th style="width: 10px">
                                       @if(count($orderBy))
                            
                                            @if($orderBy['dataId']== 'id')

                                            <a href="{!! route('client.invoice', [$client->id]).'?orderBy='.$orderBy['orderBy'].'&&dataId=id' !!}" >   <div style="cursor:pointer"  class=" fa {!! $orderBy['icon'] !!}" ></div>  </a>

                                             @else 
                                            <a href="{!! route('client.invoice', [$client->id]).'?orderBy=asc&&dataId=id' !!}" >   <div style="cursor:pointer"  class="fa fa-arrows-v" ></div>  </a>


                                            @endif

                                            @else 
                                            <a href="{!! route('client.invoice', [$client->id]).'?orderBy=asc&&dataId=id' !!}" >   <div style="cursor:pointer"  class="fa fa-arrows-v" ></div>  </a>

                                            @endif  
                                    
                                    
                                    </th>
                                    <th>Debtor name</th>
                                   
                                   
                                    <th data-priority="3" >Collect amount</th>
                                    <th data-priority="3" >Pay amount</th>



                                    <th data-priority="3" >Action</th>
                                </tr> 
                            </thead>
                            <tbody>
                                @foreach($clientInvoices as $clientInvoice)

                                <tr>
                                    <td></td>
                                    <td>{!! ($clientInvoice->debtor)? $clientInvoice->debtor->name : '' !!}</td>
                                   
                                   
                                     <td> 
                                        {!! ($clientInvoice->debtorInvoice->payments()->where('trans_description', '!=' , "Comm'sion")->sum('amount')) !!}
                                    </td> 
                                    <td>
                                        {!! ($clientInvoice->amount) !!}
                                    </td> 

                                    <td>
                                        <a href="{!! route('client.invoice.detail', [$client->id, $clientInvoice->id]) !!}"><i class="fa   fa-bars" rel="tooltip" title="Detail"></i>  </a>&nbsp;&nbsp;
                                        <a href="{!! route('client.invoice.edit', [$client->id, $clientInvoice->id]) !!}"><i class="fa   fa-edit" rel="tooltip" title="Edit"></i>  </a>&nbsp;&nbsp; 
                                        <a href="{!! route('client.invoice.transaction', [$client->id, $clientInvoice->id]) !!}"><i class="fa   fa-money" rel="tooltip" title="Payment"></i>  </a>&nbsp;&nbsp;
                                    </td>

                                </tr>
                                @endforeach 
                            </tbody>
                        </table>
                    </div>
                </div> 
                <div class="panel-footer"> 
                    <div class=" pull-right">

                    </div>
                </div>
            </div>


        </div><!-- /.tab-content -->
    </div>
</div>





@stop
@section('include-js')
@parent

@stop

