@extends('layouts.master')
@section('title')
@parent
Client detail
@stop

@section('content')
<div class="row">
    <div class="col-sm-12">
        <h4 class="pull-left page-title"> </h4>
        <ol class="breadcrumb pull-right">
            <li><a href="{!! route('home.index') !!}">Dashboard</a></li>
            <li><a href="{!! URL::route('client.index') !!}">Client</a></li> 
            <li class="active" >{!! $client->name !!}</li> 
            <li class="active" >Debtor invoice</li> 
        </ol>
    </div>
</div>

<div class="nav-tabs-custom">
    @include('clients/nav')
    <div class="tab-content">

        <!-- /.tab-pane -->

        <div class="tab-pane active" > 
            <div class="panel panel-default">
                <div class="panel-heading">
                    <div class="row"> 
                        <div class="col-md-12">
                            <div class="panel-heading pull-left">
                                <h3 class="panel-title"> Debtor invoice</h3>
                            </div>

                            <div class=" pull-right"> 
                                <a href="{!! route('client.debtor.invoice.create', [$client->id]) !!}" class="btn btn-primary"><span><i class="fa    fa-plus" rel="tooltip" ></i> Create debtor invoice </span> </a>

                            </div>
                        </div>
                    </div>
                </div><!-- /.box-header -->
                <div class="panel-body table-rep-plugin">  
                   <div class="row">
                        <div class="col-md-8">
                            
                        </div>
                        <div class="col-md-1">
                            Debtor Code
                        </div> 
                        <div class="col-md-2">
                            <input value="{!! $debtorCode !!}" id="debtor_code" name="debtor_code" type="text">
                        </div> 
                        <div class="col-md-1">
                            <button  id="debtor_code_button">Search</button>
                        </div>
                    </div>  
                    <br> 
                    <div class="table-responsive" data-pattern="priority-columns">
                        <table id="tech-companies-1" class="table  table-bordered ">
                            <thead>

                                <tr>
                                    <th style="width: 10px">
                                        
                                        @if(count($orderBy))
                            
                                            @if($orderBy['dataId']== 'id')

                                            <a href="{!! route('client.debtor.invoice', [$client->id]).'?orderBy='.$orderBy['orderBy'].'&&dataId=id' !!}" >   <div style="cursor:pointer"  class=" fa {!! $orderBy['icon'] !!}" ></div>  </a>

                                             @else 
                                            <a href="{!! route('client.debtor.invoice', [$client->id]).'?orderBy=asc&&dataId=id' !!}" >   <div style="cursor:pointer"  class="fa fa-arrows-v" ></div>  </a>


                                            @endif

                                            @else 
                                            <a href="{!! route('client.debtor.invoice', [$client->id]).'?orderBy=asc&&dataId=id' !!}" >   <div style="cursor:pointer"  class="fa fa-arrows-v" ></div>  </a>

                                            @endif
                                        
                                    </th>
                                    <th data-priority="1" >
                                        Debtor code
                                    </th>
                                    <th  >Invoice code</th>
                                    <th data-priority="6" >Invoice date</th> 
                                    <th data-priority="6" >Invoice state</th> 
                                    <th data-priority="1" >Original debt </th>
                                    <th data-priority="1" >current balance</th>
                                    <th data-priority="3" >Action</th>
                                </tr> 
                            </thead> 
                            <tbody>
                            @foreach($debtors as $debtor)

                            <tr>
                                <td></td>
                                <td>{!!$debtor->debtor_code !!}</td>
                                <td>{!!    $debtor->pivot->invoice_code !!}</td>
                                <td>
                                    {!! $debtor->pivot->invoice_date !!}
                                </td> 
                                <td>
                                    {!! $debtor->pivot->invoice_state !!}
                                </td>  
                                <td>
                                    {!! $debtor->pivot->original_debt !!}
                                </td> 

                                <td>
                                    {!! $debtor->pivot->current_balance !!}
                                </td> 
                                <td> 
                                    
                                    <a href="{!! route('client.debtor.invoice.show', [$client->id, $debtor->pivot->id]) !!}"><i class="fa  fa-bars" rel="tooltip" title="Detail"></i>  </a>&nbsp;&nbsp; 
                                   
                                     
                                    
                                    <a href="{!! route('client.debtor.invoice.edit', [$client->id, $debtor->pivot->id]) !!}"><i class="fa  fa-edit" rel="tooltip" title="Edit"></i>  </a>&nbsp;&nbsp; 
                                    @if($debtor->pivot->invoice_status_code_id != 18)
                                     <a href="{!! route('client.debtor.invoice.delete', [$client->id, $debtor->pivot->id]) !!}"><i class="fa  fa-archive" rel="tooltip" title="Edit"></i>  </a>&nbsp;&nbsp;
                                     @endif
                                    <a href="{!! route('client.debtor.invoice.payment', [$client->id, $debtor->pivot->id]) !!}"><i class="fa  fa-money" rel="tooltip" title="Payment"></i>  </a>&nbsp;&nbsp;
                                 <a href="{!! route('client.debtor.invoice.due', [$client->id, $debtor->pivot->id]) !!}"><i class="fa  fa-pie-chart" rel="tooltip" title="Due"></i>  </a>&nbsp;&nbsp;
                                <a href="{!! route('client.debtor.invoice.follow', [$client->id, $debtor->pivot->id]) !!}"><i class="fa  fa-leaf" rel="tooltip" title="Follow"></i>  </a>&nbsp;&nbsp;
                              
                               
                                </td>

                            </tr>
                            @endforeach 
                            </tbody>
                        </table> 
                    </div>
                </div><!-- /.box-body -->
                <div class="box-footer clearfix">
                    {!! $debtors->render() !!}
                </div>
            </div>
        </div>
        <!-- /.tab-pane -->
    </div><!-- /.tab-content -->
</div>






@stop
@section('include-js')
@parent

@stop 

@section('document-ready-js')
            @parent 
            
 $(".panel-default .pagination li a").each(function( index ) { 
 
 var orderBy = getUrlParameter('orderBy');
var dataId = getUrlParameter('dataId'); 
var page = getUrlParameter('page');

if(orderBy != undefined)
{ 
var newUrl = $( this ).attr('href');
if(page == undefined )
{
 
   newUrl = newUrl + '&&orderBy='+orderBy+'&&dataId='+dataId;
   
    $( this ).attr('href', newUrl);
} else 

{
newUrl = newUrl + 'orderBy='+orderBy+'&&dataId='+dataId; 
 $( this ).attr('href', newUrl);
}



}

});  



 $("#debtor_code_button").click(function () {
        var url = "{!! route('client.debtor.invoice', [$client->id]) !!}";

        var debtor= $('#debtor_code').val()
        window.location.href = url + "?debtorCode=" + debtor ;
    });


function getUrlParameter(sParam) {
    var sPageURL = decodeURIComponent(window.location.search.substring(1)),
        sURLVariables = sPageURL.split('&'),
        sParameterName,
        i;

    for (i = 0; i < sURLVariables.length; i++) {
        sParameterName = sURLVariables[i].split('=');

        if (sParameterName[0] === sParam) {
            return sParameterName[1] === undefined ? true : sParameterName[1];
        }
    }
}

@stop 