@extends('layouts.master')
@section('title')
@parent
Debitor
@stop

@section('content')
<div class="box">
    <div class="box-header">
        <ol class="breadcrumb">
            <li><a href="{!! URL::route('debtor.index') !!}">Debtor</a></li>
            <li>Create debtor</li>
        </ol>
    </div><!-- /.box-header -->
    <div class="box-body">
        {!! Form::open(array('route' => array('debtor.store'), 'autocomplete' => 'off')) !!}   




        <div class="form-group {!! ($errors->has('email')) ? 'has-error' : '' !!}">
            {!! Form::label('email', 'Email') !!}
            {!! Form::text('email', null, array('class' => 'form-control', 'placeholder' => 'Eg: example@example.com', 'autocomplete' => 'off')) !!}
            {!! ($errors->has('email') ? $errors->first('email') : '') !!}
        </div>


        <div class="form-group {!! ($errors->has('name')) ? 'has-error' : '' !!}">
            {!! Form::label('name', 'Name') !!}
            {!! Form::text('name', null, array('class' => 'form-control', 'placeholder' => 'Eg: Emery')) !!}
            {!! ($errors->has('name') ? $errors->first('name') : '') !!}
        </div> 
        <div class="form-group {!! ($errors->has('mailing_address')) ? 'has-error' : '' !!}">
            {!! Form::label('mailing_address', 'Mailing address') !!}
            {!! Form::text('mailing_address', null, array('class' => 'form-control', 'placeholder' => 'Eg: aus')) !!}
            {!! ($errors->has('mailing_address') ? $errors->first('mailing_address') : '') !!}
        </div>   
        <div class="form-group {!! ($errors->has('mailing_suburb')) ? 'has-error' : '' !!}">
            {!! Form::label('mailing_suburb', 'Mailing suburb') !!}
            {!! Form::text('mailing_suburb', null, array('class' => 'form-control', 'placeholder' => 'Eg: aus')) !!}
            {!! ($errors->has('mailing_suburb') ? $errors->first('mailing_suburb') : '') !!}
        </div>
        <div class="form-group {!! ($errors->has('mailing_state')) ? 'has-error' : '' !!}">
            {!! Form::label('mailing_state', 'Mailing state') !!}
            {!! Form::text('mailing_state', null, array('class' => 'form-control', 'placeholder' => 'Eg: aus')) !!}
            {!! ($errors->has('mailing_state') ? $errors->first('mailing_state') : '') !!}
        </div> 
        <div class="form-group {!! ($errors->has('mailing_postcode ')) ? 'has-error' : '' !!}">
            {!! Form::label('mailing_postcode ', 'Mailing postcode ') !!}
            {!! Form::text('mailing_postcode ', null, array('class' => 'form-control', 'placeholder' => 'Eg: 011222444')) !!}
            {!! ($errors->has('mailing_postcode ') ? $errors->first('mailing_postcode ') : '') !!}
        </div> 
        <div class="form-group {!! ($errors->has('contact_number ')) ? 'has-error' : '' !!}">
            {!! Form::label('contact_number ', 'Contact Number ') !!}
            {!! Form::text('contact_number', null, array('class' => 'form-control', 'placeholder' => 'Eg: aus')) !!}
            {!! ($errors->has('contact_number ') ? $errors->first('contact_number ') : '') !!}
        </div>
    </div>
    <div class="box-footer clearfix"> 
        <div class=" pull-right">
            {!! Form::submit('Create', array('class' => 'btn btn-success')) !!} &nbsp;&nbsp;
            <a href="{!!URL::route('debtor.index')!!}" class="btn btn-default">Cancel</a>
            {!!Form::close()!!} 
        </div>
    </div>
</div>

@stop
@section('include-js')
@parent

@stop

