@extends('layouts.master')
@section('title')
@parent
Debtors
@stop

@section('content')
<div class="row">
    <div class="col-sm-12">
        <h4 class="pull-left page-title"> </h4>
        <ol class="breadcrumb pull-right">
            <li><a href="{!! route('home.index') !!}">Dashboard</a></li>
            <li><a href="{!! URL::route('client.index') !!}">Client</a></li> 
            <li class="active" >{!! $client->name !!}</li> 
            <li class="active" >Debtor</li> 
        </ol>
    </div>
</div> 

<div class="nav-tabs-custom">
    @include('clients/nav')
    <div class="tab-content">
        <div class="tab-pane active" >
            <div class="panel panel-default">
                <div class="panel-heading">
                    <div class="row"> 
                        <div class="col-md-12">
                            <div class="panel-heading pull-left">
                                <h3 class="panel-title"> Debtor</h3>
                            </div>

                            <div class=" pull-right"> 

                            </div>
                        </div>
                    </div>
                </div><!-- /.box-header -->
                <div class="panel-body table-rep-plugin"> 
                    <div class="row">
                        <div class="col-md-8">
                            
                        </div>
                        <div class="col-md-1">
                            Debtor Code
                        </div> 
                        <div class="col-md-2">
                            <input value="{!! $debtorCode !!}" id="debtor_code" name="debtor_code" type="text">
                        </div> 
                        <div class="col-md-1">
                            <button  id="debtor_code_button">Search</button>
                        </div>
                    </div> 
                    <br>
                    <div class="table-responsive" data-pattern="priority-columns">
                        <table id="tech-companies-1" class="table  table-bordered ">
                            <thead>
                                <tr>
                                    <th style="width: 10px">#</th> 
                                    <th data-priority="6" >Email</th>
                                    <th data-priority="1" >Name</th>
                                    <th data-priority="1" >Debtor code</th> 
                                    <th data-priority="1" >Client code</th>
                                    <th data-priority="6" >Mailing address</th>
                                    <th data-priority="6" >Mailing suburb</th>
                                    <th data-priority="1" >Action</th>
                                </tr> 
                            </thead> 
                            <tbody>
                                @foreach($debtors as $debtor)

                                <tr>
                                    <td></td>
                                    <td>{!! $debtor->email !!}</td>  
                                    <td>
                                        {!! $debtor->name !!}
                                    </td>
                                    <td>{!! $debtor->debtor_code !!}</td> 
                                    <td> {!! $debtor->clientDetail()->client_code !!}</td> 

                                    <td>
                                        {!! $debtor->mailing_address !!}
                                    </td> 
                                    <td>
                                        {!! $debtor->mailing_suburb !!}
                                    </td> 
                                    <td>
                                        <a href="{!! route('client.debtor.show', [$client->id, $debtor->id]) !!}"><i class="fa  fa-bars" rel="tooltip" title="Detail"></i>  </a>&nbsp;&nbsp;
                                        <a href="{!! route('client.debtor.edit', [$client->id,$debtor->id]) !!}"><i class="fa  fa-edit" rel="tooltip" title="Edit"></i>  </a>&nbsp;&nbsp;
                                    </td>

                                </tr>
                                @endforeach 
                            </tbody>
                        </table> 
                    </div>
                </div><!-- /.box-body -->
                <div class="box-footer clearfix">
                    {!! $debtors->render() !!}
                </div>
            </div>
        </div>
    </div>
</div>
@stop
@section('include-js')
@parent

@stop


    @section('document-ready-js')
            @parent

            $("#debtor_code_button").click(function () {
        var url = "{!! route('client.debtor', [$client->id]) !!}";

        var debtor= $('#debtor_code').val()
        window.location.href = url + "?debtorCode=" + debtor ;
    });



    @stop




