@extends('layouts.master')
@section('title')
@parent
Debtor detail
@stop

@section('content') 
<div class="row">
    <div class="col-sm-12">
        <h4 class="pull-left page-title"> </h4>
        <ol class="breadcrumb pull-right">
            <li><a href="{!! route('home.index') !!}">Dashboard</a></li>
            <li><a href="{!! URL::route('client.index') !!}">Client</a></li> 
            <li class="active" >{!! $client->name !!}</li> 

            <li><a href="{!! URL::route('client.debtor', [$client->id]) !!}">Debtor</a></li>
            <li class="active" >{!! $debtor->name !!}</li> 
        </ol>
    </div>
</div> 

<div class="row"> 
    <div class="col-md-9"> 


        <div class="nav-tabs-custom">
            @include('clients/nav')
            <div class="tab-content">
                <div class="tab-pane active"> 

                    <div class="panel panel-default">
                        <div class="panel-heading">
                            <div class="row"> 
                                <div class="col-md-12">
                                    <div class="panel-heading pull-left">
                                        <h3 class="panel-title"> Debtor information </h3>
                                    </div>

                                    <div class=" pull-right"> 
                                        <a href="{!!URL::route('client.debtor',[$client->id])!!}" class="btn btn-default"> Back </a>
                                    </div>
                                </div>
                            </div>
                        </div><!-- /.box-header -->
                        <div class="panel-body">
                            <table class="table table-bordered detail-table">

                                <tr>
                                    <td class="detail-content-label">Name :</td>
                                    <td class="detail-content-value">{!! $debtor->name !!}</td>
                                    <td class="detail-content-label">Mailing suburb :</td>
                                    <td class="detail-content-value" >{!! $debtor->mailing_suburb !!}</td>
                                </tr>
                                <tr>

                                    <td class="detail-content-label"> Debtor code : </td>
                                    <td class="detail-content-value">{!! $debtor->debtor_code !!}</td>


                                    <td class="detail-content-label"> Mailing address: </td>
                                    <td class="detail-content-value" >{!! $debtor->mailing_address !!}</td> 

                                </tr>  
                                <tr> 
                                    <td class="detail-content-label"> Email: 
                                       
                                    </td>
                                    <td class="detail-content-value" >{!! $debtor->email !!} 
                                       
                                    </td> 


                                    <td class="detail-content-label">Mailing postcode:</td>
                                    <td class="detail-content-value" >{!! $debtor->mailing_postcode !!}</td>

                                </tr>  
                                <tr> 
                                    <td class="detail-content-label"> 
                                        
                                        Contact Number
                                    </td>
                                    <td class="detail-content-value" >
                                    
                                        {!! $debtor->contact_number !!} 
                                    </td> 


                                    <td class="detail-content-label"></td>
                                    <td class="detail-content-value" ></td>

                                </tr> 
                                <tr class="" >
                                    <td class="detail-content-label  ">Create Time :</td>
                                    <td class="detail-content-value" >  {!!  $debtor->created_at->format('d/m/Y H:i:s') !!}  </td>
                                    <td class="detail-content-label">Modified Time  </td>
                                    <td class="detail-content-value">{!!  $debtor->updated_at->format('d/m/Y H:i:s') !!}</td>
                                </tr>
                                <tr> 
                                    <td class="detail-content-label"> Client Code: </td>
                                    <td class="detail-content-value" >{!! $debtor->clientDetail()->client_code !!}</td> 


                                    <td class="detail-content-label">Client Name:</td>
                                    <td class="detail-content-value" >{!! $debtor->clientDetail()->name !!}</td>

                                </tr>   


                            </table> 
                        </div>
                    </div> 
                    <div class="panel panel-default">
                        <div class="panel-heading">
                            <div class="row"> 
                                <div class="col-md-12">
                                    <div class="panel-heading pull-left">
                                        <h3 class="panel-title"> Debtor Invoice Detail </h3>
                                    </div>

                                    <div class=" pull-right"> 

                                    </div>
                                </div>
                            </div>
                        </div><!-- /.box-header -->
                        <div class="panel-body">
                            <table class="table table-bordered detail-table">

                                <tr>
                                    <td class="detail-content-label">Original Debt :</td>
                                    <td class="detail-content-value">{!! $debtor->debtorInvoice2[0]->original_debt !!}</td>
                                    <td class="detail-content-label">Paid/Recovery( paid till date) :</td>
                                    <td class="detail-content-value" ></td>
                                </tr>
                                <tr>

                                    <td class="detail-content-label"> Current debt : </td>
                                    <td class="detail-content-value">{!! $debtor->debtorInvoice2[0]->current_balance !!}</td>


                                    <td class="detail-content-label"> <a href="{!! route('client.debtor.invoice.show', [$debtor->clientDetail()->id, $debtor->debtorInvoice2[0]->id]) !!}"> Invoice Number </a></td>
                                    <td class="detail-content-value" >{!! $debtor->debtorInvoice2[0]->invoice_code !!}</td> 

                                </tr>   
                                <tr>

                                    <td class="detail-content-label"> Reference 1: </td>
                                    <td class="detail-content-value">{!! $debtor->debtorInvoice2[0]->reference1 !!}</td>


                                    <td class="detail-content-label">Last Action(Letter) code </td>
                                    <td class="detail-content-value" >{!! $debtor->debtorInvoice2[0]->last_action !!}</td> 

                                </tr>   
                                <tr>

                                    <td class="detail-content-label"> Reference 2   </td>
                                    <td class="detail-content-value">{!! $debtor->debtorInvoice2[0]->reference2 !!}</td>


                                    <td class="detail-content-label"> 1st Prev. Action(Letter) Code </td>
                                    <td class="detail-content-value" >{!! $debtor->debtorInvoice2[0]->action_1st_letter_code !!}</td> 

                                </tr>   
                                <tr>

                                    <td class="detail-content-label"> Reference 3 </td>
                                    <td class="detail-content-value">{!! $debtor->debtorInvoice2[0]->reference3 !!}</td>


                                    <td class="detail-content-label"> 2nd Prev. Action(Letter) Code</td>
                                    <td class="detail-content-value" >{!! $debtor->debtorInvoice2[0]->action_2nd_letter_code !!}</td> 

                                </tr> 
                                <tr>

                                    <td class="detail-content-label"> Reference 4</td>
                                    <td class="detail-content-value">{!! $debtor->debtorInvoice2[0]->reference4 !!}</td>


                                    <td class="detail-content-label">3rd Prev. Action(Letter) Code </td>
                                    <td class="detail-content-value" >{!! $debtor->debtorInvoice2[0]->action_3rd_letter_code  !!}</td> 

                                </tr>  
                                <tr>

                                    <td class="detail-content-label"> Reference 5</td>
                                    <td class="detail-content-value">{!! $debtor->debtorInvoice2[0]->reference5 !!}</td>


                                    <td class="detail-content-label">  </td>
                                    <td class="detail-content-value" ></td> 

                                </tr> 
                                <tr>

                                    <td class="detail-content-label"> Debt Type</td>
                                    <td class="detail-content-value" > 
                                        @if($debtor->debtorInvoice2[0]->debt_type_id  != 0)
                                        {!! $debtor->debtorInvoice2[0]->debtType->code !!}
                                        @else 
                                        {!! $debtor->debtorInvoice2[0]->details_debt_code !!}
                                        @endif

                                    </td> 


                                    <td class="detail-content-label"> Status Code </td>
                                    <td class="detail-content-value" > 
                                        @if($debtor->debtorInvoice2[0]->invoice_status_code_id  != 0)
                                        {!! $debtor->debtorInvoice2[0]->invoiceStatusCode->code !!}
                                        @else 
                                        {!! $debtor->debtorInvoice2[0]->status_code !!}
                                        @endif

                                    </td> 

                                </tr>  





                            </table>


                        </div>
                    </div> 


                    @include('clients/debtors/menu/footerMenu')


                </div>
            </div>
        </div>
    </div> 

    <div class="col-md-3 "> 
        @include('clients/debtors/menu/sideMenu')
    </div>
</div>
@include('clients/debtors/include/pop/debtorEmail')


@stop
@section('include-js')
@parent

@stop


@section('document-ready-js')
@parent

@include('clients/debtors/include/pop/debtorEmailJs')

@stop

